/*
 * Decompiled with CFR 0.152.
 */
package com.higherfrequencytrading.chronicle.impl;

import com.higherfrequencytrading.chronicle.EnumeratedMarshaller;
import com.higherfrequencytrading.chronicle.Excerpt;
import com.higherfrequencytrading.chronicle.StopCharTester;
import com.higherfrequencytrading.chronicle.impl.UnsafeExcerpt;
import java.io.Externalizable;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalizableMarshaller<E extends Externalizable>
implements EnumeratedMarshaller<E> {
    @NotNull
    private final Class<E> classMarshaled;

    public ExternalizableMarshaller(@NotNull Class<E> classMarshaled) {
        this.classMarshaled = classMarshaled;
    }

    @Override
    public void write(Excerpt bytes, @NotNull E e) {
        try {
            e.writeExternal(bytes);
        }
        catch (IOException e2) {
            throw new IllegalStateException(e2);
        }
    }

    @Override
    public E read(Excerpt bytes) {
        Externalizable e;
        try {
            e = (Externalizable)UnsafeExcerpt.UNSAFE.allocateInstance(this.classMarshaled);
            e.readExternal(bytes);
        }
        catch (Exception e2) {
            throw new IllegalStateException(e2);
        }
        return (E)e;
    }

    @Override
    @NotNull
    public Class<E> classMarshaled() {
        return this.classMarshaled;
    }

    @Override
    @Nullable
    public E parse(@NotNull Excerpt excerpt, @NotNull StopCharTester tester) {
        throw new UnsupportedOperationException();
    }
}

