/*
 * Decompiled with CFR 0.152.
 */
package com.higherfrequencytrading.chronicle.impl;

import com.higherfrequencytrading.chronicle.Excerpt;
import com.higherfrequencytrading.chronicle.impl.AbstractChronicle;
import com.higherfrequencytrading.chronicle.impl.AbstractExcerpt;
import com.higherfrequencytrading.chronicle.impl.ByteBufferExcerpt;
import com.higherfrequencytrading.chronicle.impl.MappedFile;
import com.higherfrequencytrading.chronicle.impl.MappedMemory;
import com.higherfrequencytrading.chronicle.impl.UnsafeExcerpt;
import com.higherfrequencytrading.chronicle.tools.ChronicleTools;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.util.ConcurrentModificationException;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndexedChronicle
extends AbstractChronicle {
    public static final long MAX_VIRTUAL_ADDRESS = 0x1000000000000L;
    public static final int DEFAULT_DATA_BITS_SIZE = 27;
    public static final int DEFAULT_DATA_BITS_SIZE32 = 22;
    private static final Logger logger = Logger.getLogger(IndexedChronicle.class.getName());
    protected final int indexLowMask;
    private final int indexBitSize;
    private final int dataBitSize;
    private final int dataLowMask;
    private final MappedFile indexCache;
    private final MappedFile dataCache;
    private final ByteOrder byteOrder;
    private final boolean synchronousMode;
    private boolean useUnsafe = false;
    private AbstractExcerpt lastAppender;
    private Thread appendingThread;

    public IndexedChronicle(String basePath) throws IOException {
        this(basePath, ChronicleTools.is64Bit() ? 27 : 22);
    }

    public IndexedChronicle(String basePath, int dataBitSizeHint) throws IOException {
        this(basePath, dataBitSizeHint, ByteOrder.nativeOrder());
    }

    public IndexedChronicle(String basePath, int dataBitSizeHint, ByteOrder byteOrder) throws IOException {
        this(basePath, dataBitSizeHint, byteOrder, !ChronicleTools.is64Bit());
    }

    public IndexedChronicle(String basePath, int dataBitSizeHint, ByteOrder byteOrder, boolean minimiseByteBuffers) throws IOException {
        this(basePath, dataBitSizeHint, byteOrder, minimiseByteBuffers, false);
    }

    public IndexedChronicle(String basePath, int dataBitSizeHint, ByteOrder byteOrder, boolean minimiseByteBuffers, boolean synchronousMode) throws IOException {
        super(IndexedChronicle.extractName(basePath));
        this.byteOrder = byteOrder;
        this.synchronousMode = synchronousMode;
        this.indexBitSize = Math.min(30, Math.max(12, dataBitSizeHint - 3));
        this.dataBitSize = Math.min(30, Math.max(12, dataBitSizeHint));
        this.indexLowMask = (1 << this.indexBitSize) - 1;
        this.dataLowMask = (1 << this.dataBitSize) - 1;
        File parentFile = new File(basePath).getParentFile();
        if (parentFile != null) {
            parentFile.mkdirs();
        }
        this.indexCache = new MappedFile(basePath + ".index", 1L << this.indexBitSize);
        this.dataCache = new MappedFile(basePath + ".data", 1L << this.dataBitSize);
        long indexSize = this.indexCache.size() >>> this.indexBitSize();
        if (indexSize > 0L) {
            --indexSize;
            while (indexSize > 0L && this.getIndexData(indexSize) == 0L) {
                --indexSize;
            }
            logger.info(basePath + ", size=" + indexSize);
            this.size = indexSize;
        } else {
            logger.info(basePath + " created.");
        }
    }

    private static String extractName(String basePath) {
        File file = new File(basePath);
        String name = file.getName();
        if (name != null && name.length() > 0) {
            return name;
        }
        if ((file = file.getParentFile()) == null) {
            return "chronicle";
        }
        name = file.getName();
        if (name != null && name.length() > 0) {
            return name;
        }
        return "chronicle";
    }

    @Override
    public long getIndexData(long indexId) {
        long indexOffset = indexId << this.indexBitSize();
        MappedMemory mappedMemory = this.acquireIndexBuffer(indexOffset);
        MappedByteBuffer indexBuffer = mappedMemory.buffer();
        long num = indexBuffer.getLong((int)(indexOffset & (long)this.indexLowMask));
        mappedMemory.release();
        return num;
    }

    @NotNull
    protected MappedMemory acquireIndexBuffer(long startPosition) {
        if (startPosition >= 0x1000000000000L) {
            this.throwByteOrderIsIncorrect();
        }
        try {
            MappedMemory mbb = this.indexCache.acquire(startPosition >>> this.indexBitSize);
            mbb.buffer().order(this.byteOrder);
            return mbb;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @NotNull
    private MappedMemory throwByteOrderIsIncorrect() {
        throw new IllegalStateException("ByteOrder is incorrect.");
    }

    protected int indexBitSize() {
        return 3;
    }

    @Override
    public long sizeInBytes() {
        return this.indexCache.size() + this.dataCache.size();
    }

    public void useUnsafe(boolean useUnsafe) {
        this.useUnsafe = useUnsafe && this.byteOrder == ByteOrder.nativeOrder();
    }

    public boolean useUnsafe() {
        return this.useUnsafe;
    }

    @Override
    public ByteOrder byteOrder() {
        return this.byteOrder;
    }

    @Override
    @NotNull
    public Excerpt createExcerpt() {
        return this.useUnsafe ? new UnsafeExcerpt(this) : new ByteBufferExcerpt(this);
    }

    @Override
    @Nullable
    public MappedMemory acquireDataBuffer(long startPosition) {
        if (startPosition >= 0x1000000000000L) {
            return this.throwByteOrderIsIncorrect();
        }
        try {
            MappedMemory mbb = this.dataCache.acquire(startPosition >>> this.dataBitSize);
            mbb.buffer().order(ByteOrder.nativeOrder());
            return mbb;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public int positionInBuffer(long startPosition) {
        return (int)(startPosition & (long)this.dataLowMask);
    }

    @Override
    public long startExcerpt(AbstractExcerpt appender, int capacity) {
        boolean debug = false;
        if (!$assertionsDisabled) {
            debug = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (debug) {
            assert (this.lastAppender == null || this.lastAppender == appender) : "Chronicle cannot safely have more than one appender ";
            assert (this.appendingThread == null) : "Chronicle is already being appended to in " + this.appendingThread;
            this.lastAppender = appender;
            this.appendingThread = Thread.currentThread();
        }
        long size = this.size;
        long startPosition = this.getIndexData(size);
        assert (size == 0L || startPosition != 0L) : "size: " + size + " startPosition: " + startPosition + " is the chronicle corrupted?";
        if ((startPosition & (long)(~this.dataLowMask)) != (startPosition + (long)capacity & (long)(~this.dataLowMask))) {
            startPosition = startPosition + (long)this.dataLowMask & (long)(~this.dataLowMask);
            this.setIndexData(size, startPosition);
        }
        return startPosition;
    }

    @Override
    public void incrementSize(long expected) {
        if (this.size + 1L != expected) {
            throw new ConcurrentModificationException("size: " + (this.size + 1L) + ", expected: " + expected + ", Have you updated the chronicle without thread safety?");
        }
        assert (this.size == 0L || this.getIndexData(this.size) > 0L) : "Failed to set the index at " + this.size + " was 0.";
        ++this.size;
        this.appendingThread = null;
    }

    public void clear() {
        this.size = 0L;
        this.setIndexData(1L, 0L);
    }

    @Override
    public void setIndexData(long indexId, long indexData) {
        long indexOffset = indexId << this.indexBitSize();
        MappedMemory indexBuffer = this.acquireIndexBuffer(indexOffset);
        indexBuffer.buffer().putLong((int)(indexOffset & (long)this.indexLowMask), indexData);
        if (this.synchronousMode()) {
            indexBuffer.force();
        }
        indexBuffer.release();
    }

    @Override
    public boolean synchronousMode() {
        return this.synchronousMode;
    }

    @Override
    public void close() {
        try {
            this.indexCache.close();
            this.dataCache.close();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }
}

