/*
 * Decompiled with CFR 0.152.
 */
package com.higherfrequencytrading.chronicle.impl;

import java.nio.MappedByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import sun.misc.Cleaner;
import sun.nio.ch.DirectBuffer;

public class MappedMemory {
    private final MappedByteBuffer buffer;
    private final long index;
    private final AtomicInteger refCount = new AtomicInteger(1);
    private volatile boolean unmapped = false;

    public MappedMemory(MappedByteBuffer buffer, long index) {
        this.buffer = buffer;
        this.index = index;
    }

    private static void unmap(MappedByteBuffer bb) {
        Cleaner cl = ((DirectBuffer)((Object)bb)).cleaner();
        if (cl != null) {
            cl.clean();
        }
    }

    public long index() {
        return this.index;
    }

    public void reserve() {
        if (this.unmapped) {
            throw new IllegalStateException();
        }
        this.refCount.incrementAndGet();
    }

    public void release() {
        if (this.unmapped) {
            throw new IllegalStateException();
        }
        if (this.refCount.decrementAndGet() > 0) {
            return;
        }
        this.close();
    }

    public MappedByteBuffer buffer() {
        return this.buffer;
    }

    public long address() {
        return ((DirectBuffer)((Object)this.buffer)).address();
    }

    public int refCount() {
        return this.refCount.get();
    }

    public static void release(MappedMemory mapmem) {
        if (mapmem != null) {
            mapmem.release();
        }
    }

    public void force() {
        if (!this.unmapped) {
            this.buffer.force();
        }
    }

    public void close() {
        MappedMemory.unmap(this.buffer);
        this.unmapped = true;
    }
}

