/*
 * Decompiled with CFR 0.152.
 */
package com.higherfrequencytrading.chronicle.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringInterner {
    @NotNull
    private final String[] interner;
    private final int mask;

    public StringInterner(int capacity) {
        int n = StringInterner.nextPower2(capacity, 128);
        this.interner = new String[n];
        this.mask = n - 1;
    }

    private static boolean isEqual(@Nullable CharSequence s, @NotNull CharSequence cs) {
        if (s == null) {
            return false;
        }
        if (s.length() != cs.length()) {
            return false;
        }
        for (int i = 0; i < cs.length(); ++i) {
            if (s.charAt(i) == cs.charAt(i)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public String intern(@NotNull CharSequence cs) {
        String s2;
        int h = (int)(StringInterner.hashOf(cs) & (long)this.mask);
        String s = this.interner[h];
        if (StringInterner.isEqual(s, cs)) {
            return s;
        }
        this.interner[h] = s2 = cs.toString();
        return this.interner[h];
    }

    public static int nextPower2(int n, int min) {
        if (n < min) {
            return min;
        }
        if ((n & n - 1) == 0) {
            return n;
        }
        int i = min;
        while (i < n) {
            if ((i *= 2) > 0) continue;
            return 0x40000000;
        }
        return i;
    }

    public static long hashOf(CharSequence s) {
        long hash = 0L;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            hash = 57L * hash + (long)s.charAt(i);
        }
        return hash;
    }
}

