/*
 * Decompiled with CFR 0.152.
 */
package com.higherfrequencytrading.chronicle.impl;

import com.higherfrequencytrading.chronicle.EnumeratedMarshaller;
import com.higherfrequencytrading.chronicle.Excerpt;
import com.higherfrequencytrading.chronicle.StopCharTester;
import java.util.BitSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaEnumMarshaller<E extends Enum<E>>
implements EnumeratedMarshaller<E> {
    @NotNull
    private final Class<E> classMarshaled;
    private final E[] interner = new Enum[1024];
    private final BitSet internerDup = new BitSet(1024);
    private final Map<String, E> map = new LinkedHashMap<String, E>();
    private final E defaultValue;
    private final StringBuilder reader = new StringBuilder();

    public VanillaEnumMarshaller(@NotNull Class<E> classMarshaled, E defaultValue) {
        this.classMarshaled = classMarshaled;
        this.defaultValue = defaultValue;
        for (Enum e : (Enum[])classMarshaled.getEnumConstants()) {
            this.map.put(e.name(), e);
            int idx = this.hashFor(e.name()) & this.interner.length - 1;
            if (this.internerDup.get(idx)) continue;
            if (this.interner[idx] != null) {
                this.interner[idx] = null;
                this.internerDup.set(idx);
                continue;
            }
            this.interner[idx] = e;
        }
    }

    private int hashFor(@NotNull CharSequence cs) {
        int h = 0;
        int length = cs.length();
        for (int i = 0; i < length; ++i) {
            h = 31 * h + cs.charAt(i);
        }
        h ^= h >>> 20 ^ h >>> 12;
        h ^= h >>> 7 ^ h >>> 4;
        return h & this.interner.length - 1;
    }

    @Override
    @NotNull
    public Class<E> classMarshaled() {
        return this.classMarshaled;
    }

    @Override
    public void write(@NotNull Excerpt excerpt, @Nullable E e) {
        excerpt.writeUTF(e == null ? "" : ((Enum)e).name());
    }

    @Override
    public E read(@NotNull Excerpt excerpt) {
        excerpt.readUTF(this.reader);
        return this.builderToEnum();
    }

    private E builderToEnum() {
        int num = this.hashFor(this.reader);
        int idx = num & this.interner.length - 1;
        Object e = this.interner[idx];
        if (e != null) {
            return e;
        }
        if (!this.internerDup.get(idx)) {
            return this.defaultValue;
        }
        e = (Enum)this.map.get(this.reader.toString());
        return e == null ? this.defaultValue : e;
    }

    @Override
    public E parse(@NotNull Excerpt excerpt, @NotNull StopCharTester tester) {
        this.reader.setLength(0);
        excerpt.parseUTF(this.reader, tester);
        return this.builderToEnum();
    }
}

