/*
 * Decompiled with CFR 0.152.
 */
package com.higherfrequencytrading.chronicle.tcp;

import com.higherfrequencytrading.chronicle.Chronicle;
import com.higherfrequencytrading.chronicle.EnumeratedMarshaller;
import com.higherfrequencytrading.chronicle.Excerpt;
import com.higherfrequencytrading.chronicle.impl.WrappedExcerpt;
import com.higherfrequencytrading.chronicle.tcp.NamedThreadFactory;
import com.higherfrequencytrading.chronicle.tcp.TcpUtil;
import com.higherfrequencytrading.chronicle.tools.IOTools;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InProcessChronicleSource
implements Chronicle {
    static final int IN_SYNC_LEN = -128;
    static final long HEARTBEAT_INTERVAL_MS = 2500L;
    private static final int MAX_MESSAGE = 128;
    @NotNull
    private final Chronicle chronicle;
    private final ServerSocketChannel server;
    @NotNull
    private final String name;
    @NotNull
    private final ExecutorService service;
    private final Logger logger;
    private final Object notifier = new Object();
    private long busyWaitTimeNS = 100000L;
    private volatile boolean closed = false;
    private long lastUnpausedNS = 0L;

    public InProcessChronicleSource(@NotNull Chronicle chronicle, int port) throws IOException {
        this.chronicle = chronicle;
        this.server = ServerSocketChannel.open();
        this.server.socket().setReuseAddress(true);
        this.server.socket().bind(new InetSocketAddress(port));
        this.name = chronicle.name() + "@" + port;
        this.logger = Logger.getLogger(this.getClass().getName() + "." + this.name);
        this.service = Executors.newCachedThreadPool(new NamedThreadFactory(this.name));
        this.service.execute(new Acceptor());
    }

    public void busyWaitTimeNS(long busyWaitTimeNS) {
        this.busyWaitTimeNS = busyWaitTimeNS;
    }

    @Override
    public void multiThreaded(boolean multiThreaded) {
        this.chronicle.multiThreaded(multiThreaded);
    }

    private void pauseReset() {
        this.lastUnpausedNS = System.nanoTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pause() {
        if (this.lastUnpausedNS + this.busyWaitTimeNS > System.nanoTime()) {
            return;
        }
        try {
            Object object = this.notifier;
            synchronized (object) {
                this.notifier.wait(1250L);
            }
        }
        catch (InterruptedException ie) {
            this.logger.warning("Interrupt ignored");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void wakeSessionHandlers() {
        Object object = this.notifier;
        synchronized (object) {
            this.notifier.notifyAll();
        }
    }

    @Override
    @NotNull
    public String name() {
        return this.chronicle.name();
    }

    @Override
    @NotNull
    public Excerpt createExcerpt() {
        return new SourceExcerpt();
    }

    @Override
    public long size() {
        return this.chronicle.size();
    }

    @Override
    public long sizeInBytes() {
        return this.chronicle.sizeInBytes();
    }

    @Override
    public ByteOrder byteOrder() {
        return this.chronicle.byteOrder();
    }

    @Override
    public void close() {
        this.closed = true;
        this.chronicle.close();
        try {
            this.server.close();
        }
        catch (IOException e) {
            this.logger.warning("Error closing server port " + e);
        }
    }

    @Override
    public <E> void setEnumeratedMarshaller(@NotNull EnumeratedMarshaller<E> marshaller) {
        this.chronicle.setEnumeratedMarshaller(marshaller);
    }

    @Override
    @Nullable
    public <E> EnumeratedMarshaller<E> getMarshaller(@NotNull Class<E> eClass) {
        return this.chronicle.getMarshaller(eClass);
    }

    private class SourceExcerpt
    extends WrappedExcerpt {
        public SourceExcerpt() {
            super(InProcessChronicleSource.this.chronicle.createExcerpt());
        }

        @Override
        public void finish() {
            super.finish();
            InProcessChronicleSource.this.wakeSessionHandlers();
        }
    }

    class Handler
    implements Runnable {
        @NotNull
        private final SocketChannel socket;

        public Handler(SocketChannel socket) throws SocketException {
            this.socket = socket;
            socket.socket().setSendBufferSize(262144);
            socket.socket().setTcpNoDelay(true);
        }

        @Override
        public void run() {
            block13: {
                try {
                    long index = this.readIndex(this.socket);
                    Excerpt excerpt = InProcessChronicleSource.this.chronicle.createExcerpt();
                    ByteBuffer bb = TcpUtil.createBuffer(1, InProcessChronicleSource.this.chronicle.byteOrder());
                    long sendInSync = 0L;
                    boolean first = true;
                    while (!InProcessChronicleSource.this.closed) {
                        int remaining;
                        while (!excerpt.index(index)) {
                            long now = System.currentTimeMillis();
                            if (sendInSync <= now && !first) {
                                bb.clear();
                                bb.putInt(-128);
                                bb.flip();
                                IOTools.writeAll(this.socket, bb);
                                sendInSync = now + 2500L;
                            }
                            InProcessChronicleSource.this.pause();
                            if (!InProcessChronicleSource.this.closed) continue;
                            break block13;
                        }
                        InProcessChronicleSource.this.pauseReset();
                        int size = excerpt.capacity();
                        bb.clear();
                        if (first) {
                            bb.putLong(index);
                            first = false;
                            remaining = size + 12;
                        } else {
                            remaining = size + 4;
                        }
                        bb.putInt(size);
                        if (size > bb.capacity() / 2) {
                            while (remaining > 0) {
                                int size2 = Math.min(remaining, bb.capacity());
                                bb.limit(size2);
                                excerpt.read(bb);
                                bb.flip();
                                remaining -= bb.remaining();
                                IOTools.writeAll(this.socket, bb);
                            }
                        } else {
                            bb.limit(remaining);
                            excerpt.read(bb);
                            int count = 1;
                            while (excerpt.index(index + 1L) && count++ < 128 && excerpt.remaining() + 4 < bb.capacity() - bb.position()) {
                                int size2 = excerpt.capacity();
                                bb.limit(bb.position() + size2 + 4);
                                bb.putInt(size2);
                                excerpt.read(bb);
                                ++index;
                            }
                            bb.flip();
                            IOTools.writeAll(this.socket, bb);
                        }
                        if (bb.remaining() > 0) {
                            throw new EOFException("Failed to send index=" + index);
                        }
                        ++index;
                        sendInSync = 0L;
                    }
                }
                catch (Exception e) {
                    if (InProcessChronicleSource.this.closed) break block13;
                    String msg = e.getMessage();
                    if (msg != null && (msg.contains("reset by peer") || msg.contains("Broken pipe") || msg.contains("was aborted by"))) {
                        InProcessChronicleSource.this.logger.log(Level.INFO, "Connect " + this.socket + " closed from the other end " + e);
                    }
                    InProcessChronicleSource.this.logger.log(Level.INFO, "Connect " + this.socket + " died", e);
                }
            }
        }

        private long readIndex(SocketChannel socket) throws IOException {
            ByteBuffer bb = ByteBuffer.allocate(8);
            IOTools.readFullyOrEOF(socket, bb);
            return bb.getLong(0);
        }
    }

    private class Acceptor
    implements Runnable {
        private Acceptor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Thread.currentThread().setName(InProcessChronicleSource.this.name + "-acceptor");
            try {
                while (!InProcessChronicleSource.this.closed) {
                    SocketChannel socket = InProcessChronicleSource.this.server.accept();
                    InProcessChronicleSource.this.service.execute(new Handler(socket));
                }
            }
            catch (IOException e) {
                if (!InProcessChronicleSource.this.closed) {
                    InProcessChronicleSource.this.logger.log(Level.SEVERE, "Acceptor dying", e);
                }
            }
            finally {
                InProcessChronicleSource.this.service.shutdown();
            }
        }
    }
}

