/*
 * Decompiled with CFR 0.152.
 */
package com.higherfrequencytrading.chronicle.tools;

import com.higherfrequencytrading.chronicle.Excerpt;
import com.higherfrequencytrading.chronicle.impl.IndexedChronicle;
import java.io.IOException;
import java.nio.ByteOrder;

public enum ChronicleReader {


    public static void main(String ... args) throws IOException, InterruptedException {
        if (args.length < 1) {
            System.err.println("Usage: java " + ChronicleReader.class.getName() + " {chronicle-base-path} [from-index]");
            System.exit(-1);
        }
        int dataBitsHintSize = Integer.getInteger("dataBitsHintSize", 27);
        String def = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN ? "Big" : "Little";
        ByteOrder byteOrder = System.getProperty("byteOrder", def).equalsIgnoreCase("Big") ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        String basePath = args[0];
        long index = args.length > 1 ? Long.parseLong(args[1]) : 0L;
        IndexedChronicle ic = new IndexedChronicle(basePath, dataBitsHintSize, byteOrder);
        Excerpt excerpt = ic.createExcerpt();
        while (true) {
            if (!excerpt.index(index)) {
                Thread.sleep(50L);
                continue;
            }
            System.out.print(index + ": ");
            int nullCount = 0;
            while (excerpt.remaining() > 0) {
                char ch = (char)excerpt.readUnsignedByte();
                if (ch == '\u0000') {
                    ++nullCount;
                    continue;
                }
                if (nullCount > 0) {
                    System.out.print(" " + nullCount + "*\\0");
                }
                nullCount = 0;
                if (ch < ' ') {
                    System.out.print("^" + (char)(ch + 64));
                    continue;
                }
                if (ch > '~') {
                    System.out.print("\\x" + Integer.toHexString(ch));
                    continue;
                }
                System.out.print(ch);
            }
            if (nullCount > 0) {
                System.out.print(" " + nullCount + "*\\0");
            }
            System.out.println();
            ++index;
        }
    }
}

