/*
 * Decompiled with CFR 0.152.
 */
package com.higherfrequencytrading.chronicle.tools;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum IOTools {

    public static final Charset UTF_8 = Charset.forName("UTF-8");

    public static InputStream asStream(@NotNull String name) throws IOException {
        return IOTools.asStream(name, null);
    }

    public static InputStream asStream(@NotNull String name, @Nullable ClassLoader classLoader) throws IOException {
        InputStream in;
        String name2;
        block5: {
            name2 = IOTools.normalisePath(name);
            if (name2.startsWith("=")) {
                return new ByteArrayInputStream(name2.getBytes(UTF_8));
            }
            try {
                in = new FileInputStream(name2);
            }
            catch (FileNotFoundException e) {
                if (classLoader == null) {
                    classLoader = Thread.currentThread().getContextClassLoader();
                }
                if ((in = classLoader.getResourceAsStream(name2)) != null) break block5;
                throw e;
            }
        }
        if (name2.endsWith(".gz") || name2.endsWith(".GZ")) {
            in = new GZIPInputStream(in);
        }
        in = new BufferedInputStream(in);
        return in;
    }

    public static String normalisePath(@NotNull String pathName) {
        if (pathName.startsWith("'") || pathName.endsWith("'")) {
            return new SimpleDateFormat(pathName).format(new Date());
        }
        return pathName;
    }

    @NotNull
    public static Properties loadProperties(@NotNull String path) throws IOException {
        BufferedReader br = IOTools.asReader(path);
        Properties prop = new Properties();
        prop.load(br);
        br.close();
        return prop;
    }

    @NotNull
    public static BufferedReader asReader(@NotNull String name) throws IOException {
        return new BufferedReader(new InputStreamReader(IOTools.asStream(name, null), UTF_8));
    }

    public static void writeAllOrEOF(@NotNull SocketChannel sc, @NotNull ByteBuffer bb) throws IOException {
        IOTools.writeAll(sc, bb);
        if (bb.remaining() > 0) {
            throw new EOFException();
        }
    }

    public static void writeAll(@NotNull SocketChannel sc, @NotNull ByteBuffer bb) throws IOException {
        while (bb.remaining() > 0 && sc.write(bb) >= 0) {
        }
    }

    public static void readFullyOrEOF(@NotNull SocketChannel socket, @NotNull ByteBuffer bb) throws IOException {
        IOTools.readAvailable(socket, bb);
        if (bb.remaining() > 0) {
            throw new EOFException();
        }
    }

    public static void readAvailable(@NotNull SocketChannel socket, @NotNull ByteBuffer bb) throws IOException {
        while (bb.remaining() > 0 && socket.read(bb) >= 0) {
        }
    }
}

