/*
 * Decompiled with CFR 0.152.
 */
package com.holdenkarau.spark.testing;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.holdenkarau.spark.testing.SharedMiniCluster;
import com.holdenkarau.spark.testing.Utils$;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.MiniYARNCluster;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.sys.SystemProperties;
import scala.sys.package$;

public abstract class SharedMiniCluster$class {
    public static SparkContext sc(SharedMiniCluster $this) {
        return $this.com$holdenkarau$spark$testing$SharedMiniCluster$$_sc();
    }

    public static Seq extraClassPath(SharedMiniCluster $this) {
        return (Seq)((TraversableLike)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{new File("target/scala-2.10/classes"), new File("target/scala-2.10/test-classes"), new File("target/classes"), new File("target/test-classes")})).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(File x$1) {
                return x$1.getAbsolutePath();
            }
        }, List$.MODULE$.canBuildFrom())).filter((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$2) {
                return x$2 != null;
            }
        });
    }

    public static Seq classPathFromCurrentClassLoader(SharedMiniCluster $this) {
        URLClassLoader uRLClassLoader;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URLClassLoader uRLClassLoader2 = classLoader instanceof URLClassLoader ? (uRLClassLoader = (URLClassLoader)classLoader) : (URLClassLoader)classLoader.getParent();
        URLClassLoader urlClassLoader = uRLClassLoader2;
        return (Seq)Predef$.MODULE$.refArrayOps((Object[])urlClassLoader.getURLs()).toSeq().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(URL u) {
                return new File(u.toURI()).getAbsolutePath();
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    /*
     * WARNING - void declaration
     */
    public static String generateClassPath(SharedMiniCluster $this) {
        void var2_2;
        List clList = (List)((List)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{$this.com$holdenkarau$spark$testing$SharedMiniCluster$$logConfDir().getAbsolutePath(), (String)package$.MODULE$.props().apply((Object)"java.class.path")})).$plus$plus($this.classPathFromCurrentClassLoader(), List$.MODULE$.canBuildFrom())).$plus$plus($this.extraClassPath(), List$.MODULE$.canBuildFrom());
        String clPath = clList.mkString(File.pathSeparator);
        return var2_2;
    }

    public static void beforeAll(SharedMiniCluster $this) {
        try {
            $this.setup();
            $this.com$holdenkarau$spark$testing$SharedMiniCluster$$super$beforeAll();
            return;
        }
        catch (Exception exception) {
            $this.shutdown();
            throw exception;
        }
    }

    public static void setup(SharedMiniCluster $this) {
        $this.com$holdenkarau$spark$testing$SharedMiniCluster$$tempDir_$eq(Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1()));
        $this.com$holdenkarau$spark$testing$SharedMiniCluster$$logConfDir_$eq(new File($this.com$holdenkarau$spark$testing$SharedMiniCluster$$tempDir(), "log4j"));
        $this.com$holdenkarau$spark$testing$SharedMiniCluster$$logConfDir().mkdir();
        System.setProperty("SPARK_YARN_MODE", "true");
        File logConfFile = new File($this.com$holdenkarau$spark$testing$SharedMiniCluster$$logConfDir(), "log4j.properties");
        Files.write((CharSequence)$this.com$holdenkarau$spark$testing$SharedMiniCluster$$LOG4J_CONF(), (File)logConfFile, (Charset)Charsets.UTF_8);
        YarnConfiguration yarnConf = new YarnConfiguration();
        $this.com$holdenkarau$spark$testing$SharedMiniCluster$$yarnCluster_$eq(new MiniYARNCluster($this.getClass().getName(), 1, 1, 1));
        $this.com$holdenkarau$spark$testing$SharedMiniCluster$$yarnCluster().init((Configuration)yarnConf);
        $this.com$holdenkarau$spark$testing$SharedMiniCluster$$yarnCluster().start();
        Configuration config = $this.com$holdenkarau$spark$testing$SharedMiniCluster$$yarnCluster().getConfig();
        long deadline = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(10L);
        while (true) {
            String string = config.get("yarn.resourcemanager.address").split(":")[1];
            String string2 = "0";
            if (string != null ? !string.equals(string2) : string2 != null) break;
            if (System.currentTimeMillis() > deadline) {
                throw new IllegalStateException("Timed out waiting for RM to come up.");
            }
            TimeUnit.MILLISECONDS.sleep(100L);
        }
        String sparkAssemblyDir = new StringBuilder().append((Object)((String)package$.MODULE$.env().apply((Object)"SPARK_HOME"))).append((Object)"/assembly/target/scala-2.10/").toString();
        String sparkLibDir = new StringBuilder().append((Object)((String)package$.MODULE$.env().apply((Object)"SPARK_HOME"))).append((Object)"/lib/").toString();
        List candidates = (List)((TraversableLike)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[][]{new File(sparkAssemblyDir).listFiles(), new File(sparkLibDir).listFiles()})).filter((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File[] x$3) {
                return x$3 != null;
            }
        })).flatMap((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Seq<File> apply(File[] x$4) {
                return Predef$.MODULE$.refArrayOps((Object[])x$4).toSeq();
            }
        }, List$.MODULE$.canBuildFrom());
        String sparkAssemblyJar = ((File)candidates.find((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File f) {
                String name = f.getName();
                return name.endsWith(".jar") && name.startsWith("spark-assembly");
            }
        }).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new Exception("Failed to find spark assembly jar, make sure SPARK_HOME is set correctly");
            }
        })).getAbsolutePath();
        package$.MODULE$.props().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"spark.yarn.jar"), (Object)new StringBuilder().append((Object)"local:").append((Object)sparkAssemblyJar).toString()));
        package$.MODULE$.props().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"spark.executor.instances"), (Object)"1"));
        String childClasspath = $this.generateClassPath();
        package$.MODULE$.props().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"spark.driver.extraClassPath"), (Object)childClasspath));
        package$.MODULE$.props().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"spark.executor.extraClassPath"), (Object)childClasspath));
        File configurationFile = new File($this.com$holdenkarau$spark$testing$SharedMiniCluster$$configurationFilePath());
        Object object = configurationFile.exists() ? BoxesRunTime.boxToBoolean((boolean)configurationFile.delete()) : BoxedUnit.UNIT;
        Configuration configuration = $this.com$holdenkarau$spark$testing$SharedMiniCluster$$yarnCluster().getConfig();
        JavaConversions$.MODULE$.iterableAsScalaIterable((Iterable)configuration).foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final SystemProperties apply(Map.Entry<String, String> e) {
                return package$.MODULE$.props().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new StringBuilder().append((Object)"spark.hadoop.").append((Object)e.getKey()).toString()), (Object)e.getValue()));
            }
        });
        configuration.writeXml((OutputStream)new FileOutputStream(configurationFile));
        Properties props = new Properties();
        package$.MODULE$.props().foreach((Function1)new Serializable($this, props){
            public static final long serialVersionUID = 0L;
            private final Properties props$1;

            public final Object apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    BoxedUnit boxedUnit = k.startsWith("spark.") ? this.props$1.setProperty(k, v) : BoxedUnit.UNIT;
                    return boxedUnit;
                }
                throw new MatchError(tuple2);
            }
            {
                this.props$1 = props$1;
            }
        });
        File propsFile = File.createTempFile("spark", ".properties", $this.com$holdenkarau$spark$testing$SharedMiniCluster$$tempDir());
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(propsFile), Charsets.UTF_8);
        props.store(writer, "Spark properties.");
        writer.close();
        HdfsConfiguration hdfsConf = new HdfsConfiguration((Configuration)yarnConf);
        $this.miniDFSCluster_$eq(new MiniDFSCluster.Builder((Configuration)hdfsConf).nameNodePort(9020).format(true).build());
        $this.miniDFSCluster().waitClusterUp();
        Configuration r = $this.miniDFSCluster().getConfiguration(0);
        $this.miniDFSCluster().getFileSystem().mkdir(new Path("/tmp"), new FsPermission((short)777));
        SparkConf sparkConf = new SparkConf().setMaster($this.master()).setAppName("test");
        $this.com$holdenkarau$spark$testing$SharedMiniCluster$$_sc_$eq(new SparkContext(sparkConf));
    }

    public static void shutdown(SharedMiniCluster $this) {
        if ($this.com$holdenkarau$spark$testing$SharedMiniCluster$$yarnCluster() != null) {
            $this.com$holdenkarau$spark$testing$SharedMiniCluster$$yarnCluster().stop();
        }
        if ($this.com$holdenkarau$spark$testing$SharedMiniCluster$$_sc() != null) {
            $this.com$holdenkarau$spark$testing$SharedMiniCluster$$_sc().stop();
        }
        System.clearProperty("SPARK_YARN_MODE");
        $this.com$holdenkarau$spark$testing$SharedMiniCluster$$_sc_$eq(null);
        $this.com$holdenkarau$spark$testing$SharedMiniCluster$$yarnCluster_$eq(null);
    }

    public static void afterAll(SharedMiniCluster $this) {
        $this.shutdown();
        $this.com$holdenkarau$spark$testing$SharedMiniCluster$$super$afterAll();
    }

    public static void $init$(SharedMiniCluster $this) {
        $this.com$holdenkarau$spark$testing$SharedMiniCluster$_setter_$com$holdenkarau$spark$testing$SharedMiniCluster$$LOG4J_CONF_$eq(new StringOps(Predef$.MODULE$.augmentString("\n    |log4j.rootCategory=DEBUG, console\n    |log4j.appender.console=org.apache.log4j.ConsoleAppender\n    |log4j.appender.console.target=System.err\n    |log4j.appender.console.layout=org.apache.log4j.PatternLayout\n    |log4j.appender.console.layout.ConversionPattern=%d{yy/MM/dd HH:mm:ss} %p %c{1}: %m%n\n    ")).stripMargin());
        $this.com$holdenkarau$spark$testing$SharedMiniCluster$_setter_$com$holdenkarau$spark$testing$SharedMiniCluster$$configurationFilePath_$eq(new StringBuilder().append((Object)new File($this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath()).getParentFile().getAbsolutePath()).append((Object)"/hadoop-site.xml").toString());
        $this.com$holdenkarau$spark$testing$SharedMiniCluster$$yarnCluster_$eq(null);
        $this.miniDFSCluster_$eq(null);
        $this.com$holdenkarau$spark$testing$SharedMiniCluster$_setter_$master_$eq("yarn-client");
    }
}

