/*
 * Decompiled with CFR 0.152.
 */
package com.holdenkarau.spark.testing;

import com.holdenkarau.spark.testing.StreamingSuiteCommon;
import com.holdenkarau.spark.testing.StreamingSuiteCommon$;
import com.holdenkarau.spark.testing.TestInputStream;
import com.holdenkarau.spark.testing.TestOutputStream;
import com.holdenkarau.spark.testing.Utils$;
import java.io.File;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.Seconds$;
import org.apache.spark.streaming.TestStreamingContext;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.util.TestManualClock;
import org.scalatest.concurrent.Eventually$;
import org.scalatest.time.Span$;
import org.scalatest.time.Units;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeqLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.BufferLike;
import scala.collection.mutable.ResizableArray;
import scala.collection.mutable.StringBuilder;
import scala.collection.mutable.SynchronizedBuffer;
import scala.collection.script.Message;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public abstract class StreamingSuiteCommon$class {
    public static TestInputStream createTestInputStream(StreamingSuiteCommon $this, SparkContext sc, TestStreamingContext ssc_, Seq input, ClassTag evidence$2) {
        return new TestInputStream(sc, ssc_, input, $this.numInputPartitions(), evidence$2);
    }

    public static Duration batchDuration(StreamingSuiteCommon $this) {
        return Seconds$.MODULE$.apply(1L);
    }

    public static String framework(StreamingSuiteCommon $this) {
        return $this.getClass().getSimpleName();
    }

    public static int numInputPartitions(StreamingSuiteCommon $this) {
        return 2;
    }

    public static int maxWaitTimeMillis(StreamingSuiteCommon $this) {
        return 10000;
    }

    public static boolean useManualClock(StreamingSuiteCommon $this) {
        return true;
    }

    public static boolean actuallyWait(StreamingSuiteCommon $this) {
        return false;
    }

    public static String master(StreamingSuiteCommon $this) {
        return "local[4]";
    }

    public static String checkpointDir(StreamingSuiteCommon $this) {
        File dir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1());
        $this.logDebug((Function0)new Serializable($this, dir){
            public static final long serialVersionUID = 0L;
            private final File dir$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"checkpointDir: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dir$1}));
            }
            {
                this.dir$1 = dir$1;
            }
        });
        return dir.toString();
    }

    public static SparkConf conf(StreamingSuiteCommon $this) {
        return new SparkConf().setMaster($this.master()).setAppName($this.framework()).set("spark.streaming.clock", "org.apache.spark.streaming.util.TestManualClock");
    }

    public static void withOutputAndStreamingContext(StreamingSuiteCommon $this, Tuple2 outputStreamSSC, Function2 block) {
        TestOutputStream outputStream = (TestOutputStream)outputStreamSSC._1();
        TestStreamingContext ssc = (TestStreamingContext)((Object)outputStreamSSC._2());
        try {
            ssc.start();
            block.apply((Object)outputStream, (Object)ssc);
        }
        catch (Throwable throwable) {
            try {
                ssc.stop(false);
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                $this.logError((Function0)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Error stopping StreamingContext";
                    }
                }, exception);
            }
            throw throwable;
        }
        try {
            ssc.stop(false);
            Thread.sleep(200L);
        }
        catch (Exception exception) {
            $this.logError((Function0)new /* invalid duplicate definition of identical inner class */, exception);
        }
    }

    public static Tuple2 setupStreams(StreamingSuiteCommon $this, Seq input, Function1 operation, ClassTag evidence$3, ClassTag evidence$4) {
        TestStreamingContext ssc = new TestStreamingContext($this.sc(), $this.batchDuration());
        if ($this.checkpointDir() != null) {
            ssc.checkpoint($this.checkpointDir());
        }
        TestInputStream inputStream = $this.createTestInputStream($this.sc(), ssc, input, evidence$3);
        DStream operatedStream = (DStream)operation.apply(inputStream);
        TestOutputStream outputStream = new TestOutputStream(operatedStream, new SynchronizedBuffer<Seq<V>>($this){

            public int scala$collection$mutable$SynchronizedBuffer$$super$length() {
                return ResizableArray.class.length((ResizableArray)this);
            }

            public Iterator scala$collection$mutable$SynchronizedBuffer$$super$iterator() {
                return IndexedSeqLike.class.iterator((IndexedSeqLike)this);
            }

            public Object scala$collection$mutable$SynchronizedBuffer$$super$apply(int n) {
                return ResizableArray.class.apply((ResizableArray)this, (int)n);
            }

            public SynchronizedBuffer scala$collection$mutable$SynchronizedBuffer$$super$$plus$eq(Object elem) {
                return (SynchronizedBuffer)super.$plus$eq(elem);
            }

            public Buffer scala$collection$mutable$SynchronizedBuffer$$super$$plus$plus(GenTraversableOnce xs) {
                return BufferLike.class.$plus$plus((Buffer)this, (GenTraversableOnce)xs);
            }

            public SynchronizedBuffer scala$collection$mutable$SynchronizedBuffer$$super$$plus$plus$eq(TraversableOnce xs) {
                return (SynchronizedBuffer)super.$plus$plus$eq(xs);
            }

            public void scala$collection$mutable$SynchronizedBuffer$$super$appendAll(TraversableOnce xs) {
                BufferLike.class.appendAll((Buffer)this, (TraversableOnce)xs);
            }

            public SynchronizedBuffer scala$collection$mutable$SynchronizedBuffer$$super$$plus$eq$colon(Object elem) {
                return (SynchronizedBuffer)super.$plus$eq$colon(elem);
            }

            public SynchronizedBuffer scala$collection$mutable$SynchronizedBuffer$$super$$plus$plus$eq$colon(TraversableOnce xs) {
                return (SynchronizedBuffer)super.$plus$plus$eq$colon(xs);
            }

            public void scala$collection$mutable$SynchronizedBuffer$$super$prependAll(TraversableOnce xs) {
                BufferLike.class.prependAll((Buffer)this, (TraversableOnce)xs);
            }

            public void scala$collection$mutable$SynchronizedBuffer$$super$insertAll(int n, Traversable elems) {
                super.insertAll(n, elems);
            }

            public void scala$collection$mutable$SynchronizedBuffer$$super$update(int n, Object newelem) {
                ResizableArray.class.update((ResizableArray)this, (int)n, (Object)newelem);
            }

            public Object scala$collection$mutable$SynchronizedBuffer$$super$remove(int n) {
                return super.remove(n);
            }

            public void scala$collection$mutable$SynchronizedBuffer$$super$clear() {
                super.clear();
            }

            public void scala$collection$mutable$SynchronizedBuffer$$super$$less$less(Message cmd) {
                BufferLike.class.$less$less((Buffer)this, (Message)cmd);
            }

            public Buffer scala$collection$mutable$SynchronizedBuffer$$super$clone() {
                return BufferLike.class.clone((Buffer)this);
            }

            public int scala$collection$mutable$SynchronizedBuffer$$super$hashCode() {
                return IndexedSeqLike.class.hashCode((IndexedSeqLike)this);
            }

            public int length() {
                return SynchronizedBuffer.class.length((SynchronizedBuffer)this);
            }

            public Iterator<Seq<V>> iterator() {
                return SynchronizedBuffer.class.iterator((SynchronizedBuffer)this);
            }

            public Seq<V> apply(int n) {
                return SynchronizedBuffer.class.apply((SynchronizedBuffer)this, (int)n);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public SynchronizedBuffer $plus$eq(Object elem) {
                return SynchronizedBuffer.class.$plus$eq((SynchronizedBuffer)this, (Object)elem);
            }

            public Buffer<Seq<V>> $plus$plus(GenTraversableOnce<Seq<V>> xs) {
                return SynchronizedBuffer.class.$plus$plus((SynchronizedBuffer)this, xs);
            }

            public SynchronizedBuffer<Seq<V>> $plus$plus$eq(TraversableOnce<Seq<V>> xs) {
                return SynchronizedBuffer.class.$plus$plus$eq((SynchronizedBuffer)this, xs);
            }

            public void append(Seq<Seq<V>> elems) {
                SynchronizedBuffer.class.append((SynchronizedBuffer)this, elems);
            }

            public void appendAll(TraversableOnce<Seq<V>> xs) {
                SynchronizedBuffer.class.appendAll((SynchronizedBuffer)this, xs);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public SynchronizedBuffer $plus$eq$colon(Object elem) {
                return SynchronizedBuffer.class.$plus$eq$colon((SynchronizedBuffer)this, (Object)elem);
            }

            public SynchronizedBuffer<Seq<V>> $plus$plus$eq$colon(TraversableOnce<Seq<V>> xs) {
                return SynchronizedBuffer.class.$plus$plus$eq$colon((SynchronizedBuffer)this, xs);
            }

            public void prepend(Seq<Seq<V>> elems) {
                SynchronizedBuffer.class.prepend((SynchronizedBuffer)this, elems);
            }

            public void prependAll(TraversableOnce<Seq<V>> xs) {
                SynchronizedBuffer.class.prependAll((SynchronizedBuffer)this, xs);
            }

            public void insert(int n, Seq<Seq<V>> elems) {
                SynchronizedBuffer.class.insert((SynchronizedBuffer)this, (int)n, elems);
            }

            public void insertAll(int n, Traversable<Seq<V>> xs) {
                SynchronizedBuffer.class.insertAll((SynchronizedBuffer)this, (int)n, xs);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public void update(int n, Object newelem) {
                SynchronizedBuffer.class.update((SynchronizedBuffer)this, (int)n, (Object)newelem);
            }

            public Seq<V> remove(int n) {
                return SynchronizedBuffer.class.remove((SynchronizedBuffer)this, (int)n);
            }

            public void clear() {
                SynchronizedBuffer.class.clear((SynchronizedBuffer)this);
            }

            public void $less$less(Message<Seq<V>> cmd) {
                SynchronizedBuffer.class.$less$less((SynchronizedBuffer)this, cmd);
            }

            public Buffer<Seq<V>> clone() {
                return SynchronizedBuffer.class.clone((SynchronizedBuffer)this);
            }

            public int hashCode() {
                return SynchronizedBuffer.class.hashCode((SynchronizedBuffer)this);
            }
            {
                SynchronizedBuffer.class.$init$((SynchronizedBuffer)this);
            }
        }, evidence$4);
        return new Tuple2(outputStream, (Object)ssc);
    }

    public static Tuple2 setupStreams(StreamingSuiteCommon $this, Seq input1, Seq input2, Function2 operation, ClassTag evidence$5, ClassTag evidence$6, ClassTag evidence$7) {
        TestStreamingContext ssc = new TestStreamingContext($this.sc(), $this.batchDuration());
        if ($this.checkpointDir() != null) {
            ssc.checkpoint($this.checkpointDir());
        }
        TestInputStream inputStream1 = $this.createTestInputStream($this.sc(), ssc, input1, evidence$5);
        TestInputStream inputStream2 = $this.createTestInputStream($this.sc(), ssc, input2, evidence$6);
        DStream operatedStream = (DStream)operation.apply(inputStream1, inputStream2);
        TestOutputStream outputStream = new TestOutputStream(operatedStream, new SynchronizedBuffer<Seq<W>>($this){

            public int scala$collection$mutable$SynchronizedBuffer$$super$length() {
                return ResizableArray.class.length((ResizableArray)this);
            }

            public Iterator scala$collection$mutable$SynchronizedBuffer$$super$iterator() {
                return IndexedSeqLike.class.iterator((IndexedSeqLike)this);
            }

            public Object scala$collection$mutable$SynchronizedBuffer$$super$apply(int n) {
                return ResizableArray.class.apply((ResizableArray)this, (int)n);
            }

            public SynchronizedBuffer scala$collection$mutable$SynchronizedBuffer$$super$$plus$eq(Object elem) {
                return (SynchronizedBuffer)super.$plus$eq(elem);
            }

            public Buffer scala$collection$mutable$SynchronizedBuffer$$super$$plus$plus(GenTraversableOnce xs) {
                return BufferLike.class.$plus$plus((Buffer)this, (GenTraversableOnce)xs);
            }

            public SynchronizedBuffer scala$collection$mutable$SynchronizedBuffer$$super$$plus$plus$eq(TraversableOnce xs) {
                return (SynchronizedBuffer)super.$plus$plus$eq(xs);
            }

            public void scala$collection$mutable$SynchronizedBuffer$$super$appendAll(TraversableOnce xs) {
                BufferLike.class.appendAll((Buffer)this, (TraversableOnce)xs);
            }

            public SynchronizedBuffer scala$collection$mutable$SynchronizedBuffer$$super$$plus$eq$colon(Object elem) {
                return (SynchronizedBuffer)super.$plus$eq$colon(elem);
            }

            public SynchronizedBuffer scala$collection$mutable$SynchronizedBuffer$$super$$plus$plus$eq$colon(TraversableOnce xs) {
                return (SynchronizedBuffer)super.$plus$plus$eq$colon(xs);
            }

            public void scala$collection$mutable$SynchronizedBuffer$$super$prependAll(TraversableOnce xs) {
                BufferLike.class.prependAll((Buffer)this, (TraversableOnce)xs);
            }

            public void scala$collection$mutable$SynchronizedBuffer$$super$insertAll(int n, Traversable elems) {
                super.insertAll(n, elems);
            }

            public void scala$collection$mutable$SynchronizedBuffer$$super$update(int n, Object newelem) {
                ResizableArray.class.update((ResizableArray)this, (int)n, (Object)newelem);
            }

            public Object scala$collection$mutable$SynchronizedBuffer$$super$remove(int n) {
                return super.remove(n);
            }

            public void scala$collection$mutable$SynchronizedBuffer$$super$clear() {
                super.clear();
            }

            public void scala$collection$mutable$SynchronizedBuffer$$super$$less$less(Message cmd) {
                BufferLike.class.$less$less((Buffer)this, (Message)cmd);
            }

            public Buffer scala$collection$mutable$SynchronizedBuffer$$super$clone() {
                return BufferLike.class.clone((Buffer)this);
            }

            public int scala$collection$mutable$SynchronizedBuffer$$super$hashCode() {
                return IndexedSeqLike.class.hashCode((IndexedSeqLike)this);
            }

            public int length() {
                return SynchronizedBuffer.class.length((SynchronizedBuffer)this);
            }

            public Iterator<Seq<W>> iterator() {
                return SynchronizedBuffer.class.iterator((SynchronizedBuffer)this);
            }

            public Seq<W> apply(int n) {
                return SynchronizedBuffer.class.apply((SynchronizedBuffer)this, (int)n);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public SynchronizedBuffer $plus$eq(Object elem) {
                return SynchronizedBuffer.class.$plus$eq((SynchronizedBuffer)this, (Object)elem);
            }

            public Buffer<Seq<W>> $plus$plus(GenTraversableOnce<Seq<W>> xs) {
                return SynchronizedBuffer.class.$plus$plus((SynchronizedBuffer)this, xs);
            }

            public SynchronizedBuffer<Seq<W>> $plus$plus$eq(TraversableOnce<Seq<W>> xs) {
                return SynchronizedBuffer.class.$plus$plus$eq((SynchronizedBuffer)this, xs);
            }

            public void append(Seq<Seq<W>> elems) {
                SynchronizedBuffer.class.append((SynchronizedBuffer)this, elems);
            }

            public void appendAll(TraversableOnce<Seq<W>> xs) {
                SynchronizedBuffer.class.appendAll((SynchronizedBuffer)this, xs);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public SynchronizedBuffer $plus$eq$colon(Object elem) {
                return SynchronizedBuffer.class.$plus$eq$colon((SynchronizedBuffer)this, (Object)elem);
            }

            public SynchronizedBuffer<Seq<W>> $plus$plus$eq$colon(TraversableOnce<Seq<W>> xs) {
                return SynchronizedBuffer.class.$plus$plus$eq$colon((SynchronizedBuffer)this, xs);
            }

            public void prepend(Seq<Seq<W>> elems) {
                SynchronizedBuffer.class.prepend((SynchronizedBuffer)this, elems);
            }

            public void prependAll(TraversableOnce<Seq<W>> xs) {
                SynchronizedBuffer.class.prependAll((SynchronizedBuffer)this, xs);
            }

            public void insert(int n, Seq<Seq<W>> elems) {
                SynchronizedBuffer.class.insert((SynchronizedBuffer)this, (int)n, elems);
            }

            public void insertAll(int n, Traversable<Seq<W>> xs) {
                SynchronizedBuffer.class.insertAll((SynchronizedBuffer)this, (int)n, xs);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public void update(int n, Object newelem) {
                SynchronizedBuffer.class.update((SynchronizedBuffer)this, (int)n, (Object)newelem);
            }

            public Seq<W> remove(int n) {
                return SynchronizedBuffer.class.remove((SynchronizedBuffer)this, (int)n);
            }

            public void clear() {
                SynchronizedBuffer.class.clear((SynchronizedBuffer)this);
            }

            public void $less$less(Message<Seq<W>> cmd) {
                SynchronizedBuffer.class.$less$less((SynchronizedBuffer)this, cmd);
            }

            public Buffer<Seq<W>> clone() {
                return SynchronizedBuffer.class.clone((SynchronizedBuffer)this);
            }

            public int hashCode() {
                return SynchronizedBuffer.class.hashCode((SynchronizedBuffer)this);
            }
            {
                SynchronizedBuffer.class.$init$((SynchronizedBuffer)this);
            }
        }, evidence$7);
        return new Tuple2(outputStream, (Object)ssc);
    }

    public static Seq runStreams(StreamingSuiteCommon $this, TestOutputStream outputStream, TestStreamingContext ssc, int numBatches, int numExpectedOutput, ClassTag evidence$8) {
        Predef$.MODULE$.assert(numBatches > 0, (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Number of batches to run stream computation is zero";
            }
        });
        Predef$.MODULE$.assert(numExpectedOutput > 0, (Function0)new Serializable($this, numBatches){
            public static final long serialVersionUID = 0L;
            private final int numBatches$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Number of expected outputs after ").append((Object)BoxesRunTime.boxToInteger((int)this.numBatches$1)).append((Object)" is zero").toString();
            }
            {
                this.numBatches$1 = numBatches$1;
            }
        });
        $this.logInfo((Function0)new Serializable($this, numBatches, numExpectedOutput){
            public static final long serialVersionUID = 0L;
            private final int numBatches$1;
            private final int numExpectedOutput$1;

            public final String apply() {
                return new StringBuilder().append((Object)"numBatches = ").append((Object)BoxesRunTime.boxToInteger((int)this.numBatches$1)).append((Object)", numExpectedOutput = ").append((Object)BoxesRunTime.boxToInteger((int)this.numExpectedOutput$1)).toString();
            }
            {
                this.numBatches$1 = numBatches$1;
                this.numExpectedOutput$1 = numExpectedOutput$1;
            }
        });
        ArrayBuffer output = outputStream.output();
        TestManualClock clock = (TestManualClock)ssc.getScheduler().clock();
        $this.logInfo((Function0)new Serializable($this, clock){
            public static final long serialVersionUID = 0L;
            private final TestManualClock clock$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Manual clock before advancing = ").append((Object)BoxesRunTime.boxToLong((long)this.clock$1.currentTime())).toString();
            }
            {
                this.clock$1 = clock$1;
            }
        });
        if ($this.actuallyWait()) {
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numBatches).foreach$mVc$sp((Function1)new Serializable($this, clock){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ StreamingSuiteCommon $outer;
                private final TestManualClock clock$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    this.$outer.logInfo((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ StreamingSuiteCommon$.anonfun.runStreams.1 $outer;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Actually waiting for ").append((Object)this.$outer.com$holdenkarau$spark$testing$StreamingSuiteCommon$$anonfun$$$outer().batchDuration()).toString();
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                    this.clock$1.addToTime(this.$outer.batchDuration().milliseconds());
                    Thread.sleep(this.$outer.batchDuration().milliseconds());
                }

                public /* synthetic */ StreamingSuiteCommon com$holdenkarau$spark$testing$StreamingSuiteCommon$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.clock$1 = clock$1;
                }
            });
        } else {
            clock.addToTime((long)numBatches * $this.batchDuration().milliseconds());
        }
        $this.logInfo((Function0)new Serializable($this, clock){
            public static final long serialVersionUID = 0L;
            private final TestManualClock clock$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Manual clock after advancing = ").append((Object)BoxesRunTime.boxToLong((long)this.clock$1.currentTime())).toString();
            }
            {
                this.clock$1 = clock$1;
            }
        });
        long startTime = System.currentTimeMillis();
        while (output.size() < numExpectedOutput && System.currentTimeMillis() - startTime < (long)$this.maxWaitTimeMillis()) {
            $this.logInfo((Function0)new Serializable($this, output, numExpectedOutput){
                public static final long serialVersionUID = 0L;
                private final ArrayBuffer output$1;
                private final int numExpectedOutput$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"output.size = ").append((Object)BoxesRunTime.boxToInteger((int)this.output$1.size())).append((Object)", numExpectedOutput = ").append((Object)BoxesRunTime.boxToInteger((int)this.numExpectedOutput$1)).toString();
                }
                {
                    this.output$1 = output$1;
                    this.numExpectedOutput$1 = numExpectedOutput$1;
                }
            });
            ssc.awaitTerminationOrTimeout(50L);
        }
        long timeTaken = System.currentTimeMillis() - startTime;
        $this.logInfo((Function0)new Serializable($this, timeTaken){
            public static final long serialVersionUID = 0L;
            private final long timeTaken$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Output generated in ").append((Object)BoxesRunTime.boxToLong((long)this.timeTaken$1)).append((Object)" milliseconds").toString();
            }
            {
                this.timeTaken$1 = timeTaken$1;
            }
        });
        output.foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StreamingSuiteCommon $outer;

            public final void apply(Seq<V> x) {
                this.$outer.logInfo((Function0)new Serializable(this, x){
                    public static final long serialVersionUID = 0L;
                    private final Seq x$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"[").append((Object)this.x$1.mkString(",")).append((Object)"]").toString();
                    }
                    {
                        this.x$1 = x$1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        Predef$.MODULE$.assert(timeTaken < (long)$this.maxWaitTimeMillis(), (Function0)new Serializable($this, timeTaken){
            public static final long serialVersionUID = 0L;
            private final long timeTaken$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Operation timed out after ").append((Object)BoxesRunTime.boxToLong((long)this.timeTaken$1)).append((Object)" ms").toString();
            }
            {
                this.timeTaken$1 = timeTaken$1;
            }
        });
        Thread.sleep(200L);
        return output.toSeq();
    }

    public static SparkConf setupClock(StreamingSuiteCommon $this) {
        SparkConf sparkConf;
        if ($this.useManualClock()) {
            $this.logInfo((Function0)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Using manual clock";
                }
            });
            sparkConf = $this.conf().set("spark.streaming.clock", "org.apache.spark.streaming.util.TestManualClock");
        } else {
            $this.logInfo((Function0)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Using real clock";
                }
            });
            sparkConf = $this.conf().set("spark.streaming.clock", "org.apache.spark.streaming.util.SystemClock");
        }
        return sparkConf;
    }

    public static void $init$(StreamingSuiteCommon $this) {
        $this.com$holdenkarau$spark$testing$StreamingSuiteCommon$_setter_$eventuallyTimeout_$eq(Eventually$.MODULE$.timeout(Span$.MODULE$.apply(10L, (Units)org.scalatest.time.Seconds$.MODULE$)));
    }
}

