/*
 * Decompiled with CFR 0.152.
 */
package com.homeofthewizard.maven.plugins.vault;

import com.bettercloud.vault.VaultException;
import com.homeofthewizard.maven.plugins.vault.Vaults;
import com.homeofthewizard.maven.plugins.vault.config.AuthenticationMethodFactory;
import com.homeofthewizard.maven.plugins.vault.config.AuthenticationMethodProvider;
import com.homeofthewizard.maven.plugins.vault.config.Server;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

abstract class VaultMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(required=true)
    protected List<Server> servers;
    @Parameter(property="skipExecution", defaultValue="false")
    protected boolean skipExecution;
    private final AuthenticationMethodProvider authenticationMethodProvider = new AuthenticationMethodFactory();

    VaultMojo() {
    }

    public void execute() throws MojoExecutionException {
        this.executeVaultAuthentication();
        this.executeVaultOperation();
    }

    private void executeVaultAuthentication() throws MojoExecutionException {
        try {
            Vaults.authenticateIfNecessary(this.servers, this.authenticationMethodProvider);
        }
        catch (VaultException e) {
            throw new MojoExecutionException("Exception thrown authenticating.", (Exception)((Object)e));
        }
    }

    abstract void executeVaultOperation() throws MojoExecutionException;
}

