/*
 * Decompiled with CFR 0.152.
 */
package com.homeofthewizard.maven.plugins.vault;

import com.bettercloud.vault.SslConfig;
import com.bettercloud.vault.Vault;
import com.bettercloud.vault.VaultConfig;
import com.bettercloud.vault.VaultException;
import com.google.common.base.Strings;
import com.homeofthewizard.maven.plugins.vault.config.AuthenticationMethodFactory;
import com.homeofthewizard.maven.plugins.vault.config.AuthenticationMethodProvider;
import com.homeofthewizard.maven.plugins.vault.config.Mapping;
import com.homeofthewizard.maven.plugins.vault.config.Path;
import com.homeofthewizard.maven.plugins.vault.config.Server;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Properties;

public final class Vaults {
    private static final int OPEN_TIMEOUT = 5;
    private static final int READ_TIMEOUT = 30;

    private Vaults() {
    }

    public static void pull(List<Server> servers, Properties properties) throws VaultException {
        for (Server server : servers) {
            if (server.isSkipExecution()) continue;
            Vault vault = Vaults.vault(server.getUrl(), server.getToken(), server.getNamespace(), server.getSslVerify(), server.getSslCertificate(), server.getEngineVersion());
            for (Path path : server.getPaths()) {
                Map<String, String> secrets = Vaults.get(vault, path.getName());
                for (Mapping mapping : path.getMappings()) {
                    if (!secrets.containsKey(mapping.getKey())) {
                        String message = String.format("No value found in path %s for key %s", path.getName(), mapping.getKey());
                        throw new NoSuchElementException(message);
                    }
                    properties.setProperty(mapping.getProperty(), secrets.get(mapping.getKey()));
                }
            }
        }
    }

    public static void push(List<Server> servers, Properties properties) throws VaultException {
        for (Server server : servers) {
            if (server.isSkipExecution()) continue;
            Vault vault = Vaults.vault(server.getUrl(), server.getToken(), server.getNamespace(), server.getSslVerify(), server.getSslCertificate(), server.getEngineVersion());
            for (Path path : server.getPaths()) {
                HashMap<String, String> secrets = Vaults.exists(vault, path.getName()) ? Vaults.get(vault, path.getName()) : new HashMap();
                for (Mapping mapping : path.getMappings()) {
                    if (!properties.containsKey(mapping.getProperty())) {
                        String message = String.format("No value found for property %s", mapping.getProperty());
                        throw new NoSuchElementException(message);
                    }
                    secrets.put(mapping.getKey(), properties.getProperty(mapping.getProperty()));
                }
                Vaults.set(vault, path.getName(), secrets);
            }
        }
    }

    public static void authenticateIfNecessary(List<Server> servers, AuthenticationMethodProvider factory) throws VaultException {
        for (Server s : servers) {
            if (!Strings.isNullOrEmpty((String)s.getToken())) {
                return;
            }
            if (!Objects.isNull(s.getAuthentication())) {
                factory.fromServer(s).login();
                continue;
            }
            throw new VaultException("Either a Token of Authentication method must be provided !!\nPut in your server configuration in the pom.xml:\n<token>YOUR_VAULT_TOKEN</token>\nor\n<authentication>\n  <AUTH_METHOD>__AUTH_CREDENTIALS__</AUTH_METHOD>\n</authentication>\navailable authentication methods are: " + AuthenticationMethodFactory.methods + "\n");
        }
    }

    private static boolean exists(Vault vault, String path) throws VaultException {
        return !vault.logical().list(path).getData().isEmpty();
    }

    private static Map<String, String> get(Vault vault, String path) throws VaultException {
        return vault.logical().read(path).getData();
    }

    private static void set(Vault vault, String path, Map<String, String> secrets) throws VaultException {
        Map<String, String> nameValuePairs = secrets;
        vault.logical().write(path, nameValuePairs);
    }

    private static Vault vault(String server, String token, String namespace, boolean sslVerify, File sslCertificate, Integer engineVersion) throws VaultException {
        return new Vault(Vaults.vaultConfig(server, token, namespace, sslVerify, sslCertificate, engineVersion));
    }

    public static VaultConfig vaultConfig(String server, String token, String namespace, boolean sslVerify, File sslCertificate, Integer engineVersion) throws VaultException {
        SslConfig sslConfig = new SslConfig().verify(Boolean.valueOf(sslVerify));
        if (sslCertificate != null) {
            sslConfig.pemFile(sslCertificate);
        }
        VaultConfig vaultConfig = new VaultConfig().address(server).openTimeout(Integer.valueOf(5)).readTimeout(Integer.valueOf(30)).sslConfig(sslConfig).token(token).engineVersion(engineVersion);
        if (!Strings.isNullOrEmpty((String)namespace)) {
            vaultConfig.nameSpace(namespace);
        }
        return vaultConfig;
    }
}

