/*
 * Decompiled with CFR 0.152.
 */
package com.homeofthewizard.maven.plugins.vault.config;

import com.bettercloud.vault.VaultConfig;
import com.bettercloud.vault.VaultException;
import com.bettercloud.vault.api.Auth;
import com.homeofthewizard.maven.plugins.vault.AuthenticationMethod;
import com.homeofthewizard.maven.plugins.vault.GithubToken;
import com.homeofthewizard.maven.plugins.vault.Vaults;
import com.homeofthewizard.maven.plugins.vault.config.AuthenticationMethodProvider;
import com.homeofthewizard.maven.plugins.vault.config.Server;
import java.util.List;

public final class AuthenticationMethodFactory
implements AuthenticationMethodProvider {
    public static final String GITHUB_TOKEN_TAG = "githubToken";
    public static final List<String> methods = List.of("githubToken");

    @Override
    public AuthenticationMethod fromServer(Server server) throws VaultException {
        String method = (String)server.getAuthentication().keySet().stream().findFirst().orElseThrow(() -> new VaultException("cannot login to vault server without authentication info"));
        return this.fromMethodName(method, server);
    }

    private AuthenticationMethod fromMethodName(String method, Server server) throws VaultException {
        VaultConfig vaultConfig = Vaults.vaultConfig(server.getUrl(), server.getToken(), server.getNamespace(), server.getSslVerify(), server.getSslCertificate(), server.getEngineVersion());
        Auth auth = new Auth(vaultConfig);
        if (method.equals(GITHUB_TOKEN_TAG)) {
            return new GithubToken(auth, server);
        }
        throw new VaultException("available authentication methods are: " + methods);
    }
}

