/*
 * Decompiled with CFR 0.152.
 */
package com.homeofthewizard.maven.plugins.vault.client;

import com.google.common.base.Strings;
import com.homeofthewizard.maven.plugins.vault.client.VaultBackendProvider;
import com.homeofthewizard.maven.plugins.vault.client.VaultClient;
import com.homeofthewizard.maven.plugins.vault.config.Mapping;
import com.homeofthewizard.maven.plugins.vault.config.OutputMethod;
import com.homeofthewizard.maven.plugins.vault.config.Path;
import com.homeofthewizard.maven.plugins.vault.config.Server;
import com.homeofthewizard.maven.plugins.vault.config.authentication.AuthenticationMethodFactory;
import com.homeofthewizard.maven.plugins.vault.config.authentication.AuthenticationMethodProvider;
import com.homeofthewizard.maven.plugins.vault.config.authentication.AuthenticationSysProperties;
import io.github.jopenlibs.vault.Vault;
import io.github.jopenlibs.vault.VaultException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Properties;

final class JOpenLibsVaultClient
implements VaultClient {
    private final VaultBackendProvider vaultBackendProvider;

    JOpenLibsVaultClient(VaultBackendProvider vaultBackendProvider) {
        this.vaultBackendProvider = vaultBackendProvider;
    }

    @Override
    public void pull(List<Server> servers, Properties properties, OutputMethod outputMethod) throws VaultException {
        for (Server server : servers) {
            if (server.isSkipExecution()) continue;
            Vault vault = this.vaultBackendProvider.vault(server.getUrl(), server.getToken(), server.getNamespace(), server.getSslVerify(), server.getSslCertificate(), server.getEngineVersion());
            for (Path path : server.getPaths()) {
                Map<String, String> secrets = JOpenLibsVaultClient.get(vault, path.getName());
                for (Mapping mapping : path.getMappings()) {
                    if (!secrets.containsKey(mapping.getKey())) {
                        String message = String.format("No value found in path %s for key %s", path.getName(), mapping.getKey());
                        throw new NoSuchElementException(message);
                    }
                    outputMethod.flush(properties, secrets, mapping);
                }
            }
        }
    }

    @Override
    public void push(List<Server> servers, Properties properties) throws VaultException {
        for (Server server : servers) {
            if (server.isSkipExecution()) continue;
            Vault vault = this.vaultBackendProvider.vault(server.getUrl(), server.getToken(), server.getNamespace(), server.getSslVerify(), server.getSslCertificate(), server.getEngineVersion());
            for (Path path : server.getPaths()) {
                HashMap<String, String> secrets = JOpenLibsVaultClient.exists(vault, path.getName()) ? JOpenLibsVaultClient.get(vault, path.getName()) : new HashMap();
                for (Mapping mapping : path.getMappings()) {
                    if (!properties.containsKey(mapping.getProperty())) {
                        String message = String.format("No value found for property %s", mapping.getProperty());
                        throw new NoSuchElementException(message);
                    }
                    secrets.put(mapping.getKey(), properties.getProperty(mapping.getProperty()));
                }
                JOpenLibsVaultClient.set(vault, path.getName(), secrets);
            }
        }
    }

    @Override
    public void authenticateIfNecessary(List<Server> servers, AuthenticationSysProperties authSystemProps, AuthenticationMethodProvider factory) throws VaultException {
        int counter = 0;
        for (Server s : servers) {
            if (!Strings.isNullOrEmpty((String)s.getToken())) {
                return;
            }
            if (!authSystemProps.getAuthMethods().isEmpty() && !Objects.isNull(authSystemProps.getAuthMethods().get(counter))) {
                factory.fromSystemProperties(s, authSystemProps, counter).login();
            } else if (!Objects.isNull(s.getAuthentication())) {
                factory.fromServer(s).login();
            } else {
                throw new VaultException("Either a Token or Authentication method must be provided !!\nPut in your server configuration in the pom.xml:\n<token>YOUR_VAULT_TOKEN</token>\nor\n<authentication>\n  <AUTH_METHOD>__AUTH_CREDENTIALS__</AUTH_METHOD>\n</authentication>\n\nYou can also give the credentials as command line arguments:\n-D\"vault.github.pat=<yourPat>\" or -D\"vault.appRole.roleId=<yourRoleId>\"\n\nAvailable authentication methods are: " + AuthenticationMethodFactory.methods + "\n");
            }
            ++counter;
        }
    }

    private static boolean exists(Vault vault, String path) throws VaultException {
        return !vault.logical().list(path).getData().isEmpty();
    }

    private static Map<String, String> get(Vault vault, String path) throws VaultException {
        return vault.logical().read(path).getData();
    }

    private static void set(Vault vault, String path, Map<String, String> secrets) throws VaultException {
        Map<String, String> nameValuePairs = secrets;
        vault.logical().write(path, nameValuePairs);
    }
}

