/*
 * Decompiled with CFR 0.152.
 */
package com.homeofthewizard.maven.plugins.vault.client;

import com.google.common.base.Strings;
import io.github.jopenlibs.vault.SslConfig;
import io.github.jopenlibs.vault.Vault;
import io.github.jopenlibs.vault.VaultConfig;
import io.github.jopenlibs.vault.VaultException;
import java.io.File;

public class VaultBackendProvider {
    private static final int OPEN_TIMEOUT = 5;
    private static final int READ_TIMEOUT = 30;

    public Vault vault(String server, String token, String namespace, boolean sslVerify, File sslCertificate, Integer engineVersion) throws VaultException {
        return Vault.create((VaultConfig)this.vaultConfig(server, token, namespace, sslVerify, sslCertificate, engineVersion));
    }

    public VaultConfig vaultConfig(String server, String token, String namespace, boolean sslVerify, File sslCertificate, Integer engineVersion) throws VaultException {
        SslConfig sslConfig = new SslConfig().verify(Boolean.valueOf(sslVerify));
        if (sslCertificate != null) {
            sslConfig.pemFile(sslCertificate);
        }
        VaultConfig vaultConfig = new VaultConfig().address(server).openTimeout(Integer.valueOf(5)).readTimeout(Integer.valueOf(30)).sslConfig(sslConfig).token(token).engineVersion(engineVersion);
        if (!Strings.isNullOrEmpty((String)namespace)) {
            vaultConfig.nameSpace(namespace);
        }
        return vaultConfig;
    }
}

