/*
 * Decompiled with CFR 0.152.
 */
package com.homeofthewizard.maven.plugins.vault.config.authentication.approle;

import com.homeofthewizard.maven.plugins.vault.config.Server;
import com.homeofthewizard.maven.plugins.vault.config.authentication.AuthenticationMethod;
import com.homeofthewizard.maven.plugins.vault.config.authentication.approle.AppRoleCredentials;
import io.github.jopenlibs.vault.VaultException;
import io.github.jopenlibs.vault.api.Auth;

public class AppRoleAuthMethod
extends AuthenticationMethod<AppRoleCredentials> {
    private Server server;
    private String roleId;
    private String secretId;

    public AppRoleAuthMethod(Auth auth, Server server) {
        super(auth, AppRoleCredentials.class);
        this.server = server;
    }

    public AppRoleAuthMethod(Auth auth, String roleId, String secretId, Server server) {
        super(auth, AppRoleCredentials.class);
        this.roleId = roleId;
        this.secretId = secretId;
        this.server = server;
    }

    @Override
    public void login() throws VaultException {
        AppRoleCredentials appRoleCredentials = this.roleId != null && this.secretId != null ? new AppRoleCredentials(this.roleId, this.secretId) : (AppRoleCredentials)this.getAuthCredentials(this.server.getAuthentication().get("appRole"));
        String token = this.auth.loginByAppRole(appRoleCredentials.getRoleId(), appRoleCredentials.getSecretId()).getAuthClientToken();
        this.server.setToken(token);
    }
}

