/*
 * Decompiled with CFR 0.152.
 */
package com.homeofthewizard.maven.plugins.vault;

import com.homeofthewizard.maven.plugins.vault.client.VaultBackendProvider;
import com.homeofthewizard.maven.plugins.vault.client.VaultClient;
import com.homeofthewizard.maven.plugins.vault.config.OutputMethod;
import com.homeofthewizard.maven.plugins.vault.config.Server;
import com.homeofthewizard.maven.plugins.vault.config.authentication.AuthenticationMethodFactory;
import com.homeofthewizard.maven.plugins.vault.config.authentication.AuthenticationMethodProvider;
import com.homeofthewizard.maven.plugins.vault.config.authentication.AuthenticationSysProperties;
import io.github.jopenlibs.vault.VaultException;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

abstract class VaultMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(required=true)
    protected List<Server> servers;
    @Parameter(property="vault.appRole.roleId")
    protected List<String> roleIds;
    @Parameter(property="vault.appRole.secretId")
    protected List<String> secretIds;
    @Parameter(property="vault.github.pat")
    protected List<String> pats;
    @Parameter(property="vault.authenticationMethod")
    protected List<String> authMethods;
    @Parameter(defaultValue="MavenProperties", property="vault.outputMethod")
    protected OutputMethod outputMethod;
    @Parameter(defaultValue="false", property="vault.skipExecution")
    protected boolean skipExecution;
    private final AuthenticationMethodProvider authenticationMethodProvider;
    protected final VaultClient vaultClient;

    VaultMojo() {
        this.authenticationMethodProvider = new AuthenticationMethodFactory();
        VaultBackendProvider vaultBackendProvider = new VaultBackendProvider();
        this.vaultClient = VaultClient.createForBackend(vaultBackendProvider);
    }

    VaultMojo(AuthenticationMethodProvider authenticationMethodProvider, VaultClient vaultClient) {
        this.authenticationMethodProvider = authenticationMethodProvider;
        this.vaultClient = vaultClient;
    }

    public void execute() throws MojoExecutionException {
        if (this.skipExecution) {
            return;
        }
        this.executeVaultAuthentication();
        this.executeVaultOperation();
    }

    private void executeVaultAuthentication() throws MojoExecutionException {
        try {
            AuthenticationSysProperties authSystemArgs = new AuthenticationSysProperties(this.authMethods, this.pats, this.roleIds, this.secretIds);
            this.vaultClient.authenticateIfNecessary(this.servers, authSystemArgs, this.authenticationMethodProvider);
        }
        catch (VaultException e) {
            throw new MojoExecutionException("Exception thrown authenticating.", (Exception)((Object)e));
        }
    }

    abstract void executeVaultOperation() throws MojoExecutionException;
}

