/*
 * Decompiled with CFR 0.152.
 */
package com.homeofthewizard.maven.plugins.vault.config;

import com.homeofthewizard.maven.plugins.vault.config.Mapping;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Properties;

public enum OutputMethod {
    MavenProperties{

        @Override
        public void flush(Properties properties, Map<String, String> secrets, Mapping mapping) {
            OutputMethod.setMavenProperties(properties, secrets, mapping);
        }
    }
    ,
    SystemProperties{

        @Override
        public void flush(Properties properties, Map<String, String> secrets, Mapping mapping) {
            OutputMethod.setSystemProperties(secrets, mapping);
        }
    }
    ,
    EnvFile{

        @Override
        public void flush(Properties properties, Map<String, String> secrets, Mapping mapping) {
            OutputMethod.createEnvFile(secrets, mapping);
        }
    };


    public abstract void flush(Properties var1, Map<String, String> var2, Mapping var3);

    private static void createEnvFile(Map<String, String> secrets, Mapping mapping) {
        try (FileWriter fileWriter = new FileWriter(".env", true);){
            BufferedWriter buffer = new BufferedWriter(fileWriter);
            PrintWriter printer = new PrintWriter(buffer);
            printer.format("%s=%s\n", mapping.getProperty(), secrets.get(mapping.getKey()));
            printer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void setSystemProperties(Map<String, String> secrets, Mapping mapping) {
        System.setProperty(mapping.getProperty(), secrets.get(mapping.getKey()));
    }

    private static void setMavenProperties(Properties properties, Map<String, String> secrets, Mapping mapping) {
        properties.setProperty(mapping.getProperty(), secrets.get(mapping.getKey()));
    }
}

