/*
 * Decompiled with CFR 0.152.
 */
package com.homeofthewizard.maven.plugins.vault.config.authentication;

import com.homeofthewizard.maven.plugins.vault.client.VaultBackendProvider;
import com.homeofthewizard.maven.plugins.vault.config.Server;
import com.homeofthewizard.maven.plugins.vault.config.authentication.AuthenticationMethod;
import com.homeofthewizard.maven.plugins.vault.config.authentication.AuthenticationMethodProvider;
import com.homeofthewizard.maven.plugins.vault.config.authentication.AuthenticationSysProperties;
import com.homeofthewizard.maven.plugins.vault.config.authentication.approle.AppRoleAuthMethod;
import com.homeofthewizard.maven.plugins.vault.config.authentication.github.GithubTokenAuthMethod;
import io.github.jopenlibs.vault.VaultConfig;
import io.github.jopenlibs.vault.VaultException;
import io.github.jopenlibs.vault.api.Auth;
import java.util.List;

public final class AuthenticationMethodFactory
implements AuthenticationMethodProvider {
    public static final String GITHUB_TOKEN_TAG = "githubToken";
    public static final String APP_ROLE_TAG = "appRole";
    public static final List<String> methods = List.of("githubToken", "appRole");
    private final VaultBackendProvider vaultBackendProvider = new VaultBackendProvider();

    @Override
    public AuthenticationMethod fromServer(Server server) throws VaultException {
        String method = (String)server.getAuthentication().keySet().stream().findFirst().orElseThrow(() -> new VaultException("cannot login to vault server without authentication info"));
        return this.fromMethodName(method, server);
    }

    @Override
    public AuthenticationMethod fromSystemProperties(Server server, AuthenticationSysProperties systemProperties, int counter) throws VaultException {
        VaultConfig vaultConfig = this.vaultBackendProvider.vaultConfig(server.getUrl(), server.getToken(), server.getNamespace(), server.getSslVerify(), server.getSslCertificate(), server.getEngineVersion());
        Auth auth = new Auth(vaultConfig);
        switch (systemProperties.getAuthMethods().get(counter)) {
            case "githubToken": {
                return new GithubTokenAuthMethod(auth, systemProperties.getPats().get(counter), server);
            }
            case "appRole": {
                return new AppRoleAuthMethod(auth, systemProperties.getRoleIds().get(counter), systemProperties.getSecretIds().get(counter), server);
            }
        }
        throw new VaultException("available authentication methods are: " + methods);
    }

    private AuthenticationMethod fromMethodName(String method, Server server) throws VaultException {
        VaultConfig vaultConfig = this.vaultBackendProvider.vaultConfig(server.getUrl(), server.getToken(), server.getNamespace(), server.getSslVerify(), server.getSslCertificate(), server.getEngineVersion());
        Auth auth = new Auth(vaultConfig);
        switch (method) {
            case "githubToken": {
                return new GithubTokenAuthMethod(auth, server);
            }
            case "appRole": {
                return new AppRoleAuthMethod(auth, server);
            }
        }
        throw new VaultException("available authentication methods are: " + methods);
    }
}

