/*
 * Decompiled with CFR 0.152.
 */
package com.homeofthewizard.maven.plugins.vault.config.authentication.github;

import com.homeofthewizard.maven.plugins.vault.config.Server;
import com.homeofthewizard.maven.plugins.vault.config.authentication.AuthenticationMethod;
import com.homeofthewizard.maven.plugins.vault.config.authentication.github.GithubToken;
import io.github.jopenlibs.vault.VaultException;
import io.github.jopenlibs.vault.api.Auth;

public class GithubTokenAuthMethod
extends AuthenticationMethod<GithubToken> {
    private Server server;
    private String cliPat;

    public GithubTokenAuthMethod(Auth auth, String cliPat, Server server) {
        super(auth, GithubToken.class);
        this.cliPat = cliPat;
        this.server = server;
    }

    public GithubTokenAuthMethod(Auth auth, Server server) {
        super(auth, GithubToken.class);
        this.server = server;
    }

    @Override
    public void login() throws VaultException {
        String githubPat = this.cliPat != null ? this.cliPat : ((GithubToken)this.getAuthCredentials(this.server.getAuthentication().get("githubToken"))).getPat();
        String token = this.auth.loginByGithub(githubPat).getAuthClientToken();
        this.server.setToken(token);
    }
}

