/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.core.http;

import com.huaweicloud.sdk.core.auth.SigningAlgorithm;
import com.huaweicloud.sdk.core.exception.SdkException;
import com.huaweicloud.sdk.core.http.FormDataPart;
import com.huaweicloud.sdk.core.http.HttpMethod;
import com.huaweicloud.sdk.core.progress.ProgressListener;
import com.huaweicloud.sdk.core.utils.SignUtils;
import com.huaweicloud.sdk.core.utils.StringUtils;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface HttpRequest {
    public static HttpRequestBuilder newBuilder() {
        return new HttpRequestBuilder();
    }

    public HttpRequestBuilder builder();

    public String getEndpoint();

    public String getPath();

    public HttpMethod getMethod();

    public Map<String, List<String>> getQueryParams();

    public Map<String, List<String>> getHeaders();

    public Boolean haveHeader(String var1);

    public String getHeader(String var1);

    public String getContentType();

    public String getBodyAsString();

    public String getQueryParamsString();

    public String getPathParamsString();

    public URL getUrl();

    public InputStream getBody();

    public Map<String, FormDataPart<?>> getFormData();

    public SigningAlgorithm getSigningAlgorithm();

    public ProgressListener getProgressListener();

    public long getProgressInterval();

    public static class Impl
    implements HttpRequest,
    Cloneable {
        private static final Logger LOG = LoggerFactory.getLogger(Impl.class);
        private String endpoint;
        private String path;
        private HttpMethod method = HttpMethod.GET;
        private Map<String, List<String>> queryParams = new LinkedHashMap<String, List<String>>();
        private Map<String, List<String>> headers = new HashMap<String, List<String>>();
        private Map<String, Object> pathParams = new LinkedHashMap<String, Object>();
        private Map<String, Object> autoFilledPathParams = new LinkedHashMap<String, Object>();
        private String contentType = "application/json";
        private String bodyAsString;
        private String queryParamsString;
        private String pathParamsString;
        private URL url;
        private InputStream body;
        private Map<String, FormDataPart<?>> formData = new TreeMap();
        private SigningAlgorithm signingAlgorithm = SigningAlgorithm.getDefault();
        private ProgressListener progressListener;
        private long progressInterval;

        @Override
        public HttpRequestBuilder builder() {
            try {
                return new HttpRequestBuilder(this.clone());
            }
            catch (CloneNotSupportedException e) {
                throw new SdkException("Can not create a new builder", e);
            }
        }

        @Override
        public String getEndpoint() {
            return this.endpoint;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public HttpMethod getMethod() {
            return this.method;
        }

        @Override
        public Map<String, List<String>> getQueryParams() {
            return this.queryParams;
        }

        @Override
        public Map<String, List<String>> getHeaders() {
            return this.headers;
        }

        @Override
        public Boolean haveHeader(String name) {
            if (Objects.isNull(this.headers)) {
                return false;
            }
            return this.headers.containsKey(name);
        }

        @Override
        public String getHeader(String name) {
            if (Objects.isNull(this.headers)) {
                return null;
            }
            List<String> values = this.headers.get(name);
            return Objects.isNull(values) || values.isEmpty() ? null : values.get(0);
        }

        @Override
        public String getContentType() {
            return this.contentType;
        }

        @Override
        public String getBodyAsString() {
            return this.bodyAsString;
        }

        @Override
        public String getQueryParamsString() {
            return this.queryParamsString;
        }

        @Override
        public String getPathParamsString() {
            return this.pathParamsString;
        }

        @Override
        public URL getUrl() {
            return this.url;
        }

        @Override
        public InputStream getBody() {
            return this.body;
        }

        @Override
        public Map<String, FormDataPart<?>> getFormData() {
            return this.formData;
        }

        @Override
        public SigningAlgorithm getSigningAlgorithm() {
            return this.signingAlgorithm;
        }

        @Override
        public ProgressListener getProgressListener() {
            return this.progressListener;
        }

        @Override
        public long getProgressInterval() {
            return this.progressInterval;
        }

        public Impl clone() throws CloneNotSupportedException {
            Impl impl = (Impl)super.clone();
            impl.method = this.method;
            impl.bodyAsString = this.bodyAsString;
            impl.contentType = this.contentType;
            impl.endpoint = this.endpoint;
            impl.path = this.path;
            impl.pathParams = new HashMap<String, Object>(this.pathParams);
            impl.autoFilledPathParams = new HashMap<String, Object>(this.autoFilledPathParams);
            impl.queryParams = new HashMap<String, List<String>>(this.queryParams);
            impl.headers = new HashMap<String, List<String>>(this.headers);
            impl.signingAlgorithm = this.signingAlgorithm;
            impl.progressListener = this.progressListener;
            impl.progressInterval = this.progressInterval;
            return impl.buildPathParamsString().buildQueryParamsString().buildUrl();
        }

        private Impl buildPathParamsString() {
            this.pathParamsString = Objects.isNull(this.path) ? "" : this.path;
            this.pathParams.forEach((key, value) -> {
                this.pathParamsString = this.pathParamsString.replace(String.format("{%s}", key), value.toString());
            });
            this.autoFilledPathParams.forEach((key, value) -> {
                this.pathParamsString = this.pathParamsString.replace(String.format("{%s}", key), value.toString());
            });
            return this;
        }

        private Impl buildQueryParamsString() {
            StringBuilder sb = new StringBuilder();
            this.queryParams.forEach((key, values) -> {
                if (values.size() == 0) {
                    sb.append(String.format("%s=&", key));
                }
                values.forEach(value -> {
                    if (value.isEmpty()) {
                        sb.append(String.format("%s=&", key));
                    } else {
                        sb.append(String.format("%s=%s&", key, SignUtils.urlEncode(value, false)));
                    }
                });
            });
            this.queryParamsString = sb.length() > 0 ? sb.deleteCharAt(sb.length() - 1).toString() : sb.toString();
            return this;
        }

        private Impl buildUrl() {
            try {
                this.url = !StringUtils.isEmpty(this.queryParamsString) ? new URL(this.endpoint + this.pathParamsString + "?" + this.queryParamsString) : new URL(this.endpoint + this.pathParamsString);
            }
            catch (MalformedURLException e) {
                LOG.error("region endpoint can not be found");
                throw new SdkException(e);
            }
            return this;
        }
    }

    public static class HttpRequestBuilder {
        private Impl httpRequest;

        private HttpRequestBuilder() {
            this.httpRequest = new Impl();
        }

        private HttpRequestBuilder(Impl httpRequest) {
            this.httpRequest = httpRequest;
        }

        public HttpRequestBuilder withEndpoint(String endpoint) {
            this.httpRequest.endpoint = endpoint;
            return this;
        }

        public HttpRequestBuilder withPath(String path) {
            this.httpRequest.path = path;
            return this;
        }

        public HttpRequestBuilder withContentType(String contentType) {
            this.httpRequest.contentType = contentType;
            if (Objects.nonNull(contentType)) {
                this.addHeader("Content-Type", contentType);
            }
            return this;
        }

        public HttpRequestBuilder withMethod(HttpMethod method) {
            this.httpRequest.method = method;
            return this;
        }

        public HttpRequestBuilder withBodyAsString(String bodyAsString) {
            this.httpRequest.bodyAsString = bodyAsString;
            return this;
        }

        public HttpRequestBuilder withBody(InputStream body) {
            this.httpRequest.body = body;
            return this;
        }

        public HttpRequestBuilder addHeader(String key, final String value) {
            if (!this.httpRequest.headers.containsKey(key)) {
                this.httpRequest.headers.put(key, new ArrayList<String>(){
                    private static final long serialVersionUID = 1L;
                    {
                        this.add(value);
                    }
                });
            } else {
                ArrayList<String> values = (ArrayList<String>)this.httpRequest.headers.get(key);
                if (Objects.isNull(values)) {
                    values = new ArrayList<String>();
                }
                if (!values.contains(value)) {
                    values.add(value);
                }
            }
            return this;
        }

        public HttpRequestBuilder addHeaders(Map<String, String> headers) {
            headers.forEach(this::addHeader);
            return this;
        }

        public HttpRequestBuilder addQueryParam(String key, List<String> value) {
            this.httpRequest.queryParams.putIfAbsent(key, value);
            return this;
        }

        public HttpRequestBuilder addPathParam(String key, Object value) {
            this.httpRequest.pathParams.putIfAbsent(key, value);
            return this;
        }

        public HttpRequestBuilder addPathParam(Map<String, Object> pathParam) {
            this.httpRequest.pathParams.putAll(pathParam);
            return this;
        }

        public HttpRequestBuilder addAutoFilledPathParam(String key, String value) {
            this.httpRequest.autoFilledPathParams.putIfAbsent(key, value);
            return this;
        }

        public HttpRequestBuilder addAutoFilledPathParam(Map<String, Object> pathParam) {
            this.httpRequest.autoFilledPathParams.putAll(pathParam);
            return this;
        }

        public HttpRequestBuilder addFormDataPart(String name, FormDataPart<?> formDataPart) {
            this.httpRequest.formData.put(name, formDataPart);
            return this;
        }

        public HttpRequestBuilder withFormDataPart(Map<String, FormDataPart<?>> fromData) {
            this.httpRequest.formData = fromData;
            return this;
        }

        public HttpRequestBuilder withSigningAlgorithm(SigningAlgorithm signingAlgorithm) {
            this.httpRequest.signingAlgorithm = signingAlgorithm;
            return this;
        }

        public HttpRequestBuilder withProgressListener(ProgressListener progressListener) {
            this.httpRequest.progressListener = progressListener;
            return this;
        }

        public HttpRequestBuilder withProgressInterval(long progressInterval) {
            this.httpRequest.progressInterval = progressInterval;
            return this;
        }

        public HttpRequest build() {
            return this.httpRequest.buildPathParamsString().buildQueryParamsString().buildUrl();
        }
    }
}

