/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.core.progress;

import com.huaweicloud.sdk.core.progress.ProgressListener;

public abstract class ProgressManager {
    protected final long totalBytes;
    protected long startCheckpoint;
    protected long lastCheckpoint;
    protected final long intervalBytes;
    protected final ProgressListener progressListener;

    public ProgressManager(long totalBytes, ProgressListener progressListener, long intervalBytes) {
        long now;
        this.totalBytes = totalBytes;
        this.progressListener = progressListener;
        this.startCheckpoint = now = System.currentTimeMillis();
        this.lastCheckpoint = now;
        this.intervalBytes = intervalBytes;
    }

    public void progressStart() {
        long now;
        this.startCheckpoint = now = System.currentTimeMillis();
        this.lastCheckpoint = now;
    }

    public final void progressChanged(int bytes) {
        if (this.progressListener == null || bytes <= 0) {
            return;
        }
        this.doProgressChanged(bytes);
    }

    public abstract void progressEnd();

    protected abstract void doProgressChanged(int var1);
}

