/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.core.progress;

import com.huaweicloud.sdk.core.progress.MayRepeatableInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicLong;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepeatableRequestEntity
extends RequestBody
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(RepeatableRequestEntity.class);
    private final String contentType;
    private long contentLength = -1L;
    private final AtomicLong bytesWritten = new AtomicLong(0L);
    private InputStream inputStream;
    private static final int WRITE_BUFFER_SIZE = 4096;

    public RepeatableRequestEntity(InputStream is, String contentType, long contentLength) {
        if (is == null) {
            throw new IllegalArgumentException("InputStream cannot be null");
        }
        this.inputStream = is;
        this.contentLength = contentLength;
        this.contentType = contentType;
        if (!(this.inputStream instanceof MayRepeatableInputStream)) {
            this.inputStream = new MayRepeatableInputStream(is, 8192);
        }
        this.inputStream.mark(0);
    }

    public long contentLength() {
        return this.contentLength;
    }

    public boolean isRepeatable() {
        return this.inputStream == null || this.inputStream.markSupported();
    }

    protected void writeToBIO(BufferedSink out) throws IOException {
        byte[] tmp = new byte[4096];
        if (this.contentLength < 0L) {
            int count = this.inputStream.read(tmp);
            while (count != -1) {
                this.bytesWritten.addAndGet(count);
                out.write(tmp, 0, count);
                count = this.inputStream.read(tmp);
            }
        } else {
            int count;
            for (long remaining = this.contentLength; remaining > 0L && (count = this.inputStream.read(tmp, 0, (int)Math.min(4096L, remaining))) != -1; remaining -= (long)count) {
                out.write(tmp, 0, count);
                this.bytesWritten.addAndGet(count);
            }
        }
    }

    public MediaType contentType() {
        return MediaType.parse((String)(this.contentType == null ? "application/octet-stream" : this.contentType));
    }

    public void writeTo(BufferedSink sink) throws IOException {
        long start = System.currentTimeMillis();
        if (this.bytesWritten.get() > 0L) {
            this.inputStream.reset();
            this.bytesWritten.set(0L);
        }
        this.writeToBIO(sink);
        if (logger.isInfoEnabled()) {
            logger.info("write data end, cost " + (System.currentTimeMillis() - start) + " ms");
        }
    }

    @Override
    public void close() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
        }
    }
}

