/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.functiongraph.v2.region;

import com.huaweicloud.sdk.core.region.Region;
import com.huaweicloud.sdk.core.utils.StringUtils;
import com.huaweicloud.sdk.functiongraph.v2.region.FunctionGraphRegion;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionGraphTenantRegion {
    private static final Logger logger = LoggerFactory.getLogger(FunctionGraphTenantRegion.class);
    private static final Map<String, Region> REGION_AFTER_INIT;
    private static final Object LOCK;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Region valueOf(String regionId) {
        if (StringUtils.isEmpty((CharSequence)regionId)) {
            throw new IllegalArgumentException("Unexpected empty parameter: regionId.");
        }
        Region result = REGION_AFTER_INIT.get(regionId);
        if (Objects.nonNull(result)) {
            return result;
        }
        Region regionOrigin = FunctionGraphRegion.valueOf(regionId);
        Region region = FunctionGraphTenantRegion.phraseTenantRegionUrl(regionOrigin);
        result = REGION_AFTER_INIT.get(regionId);
        if (Objects.nonNull(result)) {
            return result;
        }
        Object object = LOCK;
        synchronized (object) {
            Region regionAfterInit = FunctionGraphTenantRegion.processRegion(region);
            REGION_AFTER_INIT.put(regionId, regionAfterInit);
            return regionAfterInit;
        }
    }

    private static Region phraseTenantRegionUrl(Region regionOrigin) {
        Region region = new Region();
        region.setId(regionOrigin.getId());
        List endpoints = regionOrigin.getEndpoints();
        List tenantEndpoints = endpoints.stream().map(url -> url.replace("functiongraph", "functiongraph-ext")).collect(Collectors.toList());
        region.setEndpoints(tenantEndpoints);
        return region;
    }

    public static Region processRegion(Region region) {
        if (region.getEndpoints() != null && region.getEndpoints().size() > 0) {
            List<String> endpoints = FunctionGraphTenantRegion.parseByDns(region.getEndpoints());
            endpoints.add((String)region.getEndpoints().get(0));
            region.withEndpointsOverride(endpoints);
        }
        return region;
    }

    private static List<String> parseByDns(List<String> domainNames) {
        return domainNames.stream().flatMap(domainName -> FunctionGraphTenantRegion.parseByDns(domainName).stream()).distinct().collect(Collectors.toList());
    }

    private static List<String> parseByDns(String domainName) {
        String domainReplace = domainName.replace("https://", "");
        ArrayList<String> records = new ArrayList<String>();
        try {
            InetAddress[] inetAddress;
            for (InetAddress inetAddressEntry : inetAddress = InetAddress.getAllByName(domainReplace)) {
                records.add("https://" + inetAddressEntry.getHostAddress());
            }
        }
        catch (UnknownHostException e) {
            logger.error("phrase dns failed,unknown domain name: " + domainName);
        }
        return records;
    }

    static {
        System.setProperty("sun.net.spi.nameservice.provider.1", "sun,dns");
        REGION_AFTER_INIT = new HashMap<String, Region>();
        LOCK = new Object();
    }
}

