/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.text;

import org.beetl.core.text.CRFragment;
import org.beetl.core.text.FragmentStatus;
import org.beetl.core.text.HtmlTagEndFragment;
import org.beetl.core.text.HtmlTagStartFragment;
import org.beetl.core.text.PlaceHolderFragment;
import org.beetl.core.text.ScriptBlockFragment;
import org.beetl.core.text.Source;
import org.beetl.core.text.TextFragment;

public abstract class Fragment {
    public static final String RIGHT_END = "~>";
    public static final String PS_START_1 = "<~";
    public static final String PS_START_2 = "<#";
    public static final String TEXT_START = "<^";
    protected Source source;
    protected int startLine;
    protected int endLine;
    private FragmentStatus status = FragmentStatus.normal;

    public Fragment(Source source) {
        this.source = source;
        this.setStartLine();
    }

    public abstract StringBuilder getScript();

    public abstract Fragment consumeAndReturnNext();

    protected Fragment findNext() {
        if (this.source.isEof()) {
            return null;
        }
        if (this.source.isScriptStart()) {
            this.setEndLine();
            return new ScriptBlockFragment(this.source);
        }
        if (this.source.isPlaceHolderStart()) {
            this.setEndLine();
            return new PlaceHolderFragment(this.source);
        }
        if (this.source.isHtmlTagStart()) {
            this.setEndLine();
            return new HtmlTagStartFragment(this.source);
        }
        if (this.source.isHtmlTagEnd()) {
            this.setEndLine();
            return new HtmlTagEndFragment(this.source);
        }
        if (this.source.isCrStart()) {
            return new CRFragment(this.source);
        }
        this.setEndLine();
        return new TextFragment(this.source);
    }

    protected void setStartLine() {
        this.startLine = this.source.curLine;
    }

    protected void setEndLine() {
        this.endLine = this.source.curLine;
    }

    public FragmentStatus getStatus() {
        return this.status;
    }

    public void setStatus(FragmentStatus status) {
        this.status = status;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " from " + this.startLine + " to " + this.endLine;
    }
}

