/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.engine;

import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.DefaultErrorStrategy;
import org.antlr.v4.runtime.RuntimeMetaData;
import org.antlr.v4.runtime.tree.ParseTree;
import org.beetl.core.AntlrProgramBuilder;
import org.beetl.core.Configuration;
import org.beetl.core.GroupTemplate;
import org.beetl.core.Resource;
import org.beetl.core.TemplateEngine;
import org.beetl.core.engine.GrammarCreator;
import org.beetl.core.engine.IGrammarConstants;
import org.beetl.core.fun.ObjectUtil;
import org.beetl.core.parser.BeetlAntlrErrorStrategy;
import org.beetl.core.parser.SyntaxErrorListener;
import org.beetl.core.statement.AjaxStatement;
import org.beetl.core.statement.Program;
import org.beetl.core.statement.ProgramMetaData;

public class DefaultTemplateEngine
implements TemplateEngine,
IGrammarConstants {
    protected BeetlAntlrErrorStrategy antlrErrorStrategy = new BeetlAntlrErrorStrategy();
    protected SyntaxErrorListener syntaxError = new SyntaxErrorListener();
    protected static final String[] STRICT_DISABLE_GRAMMARS = new String[]{"Arth", "ClassNativeCall", "Compare", "Function", "IncDec", "InstanceNativeCall", "VarAssign", "VarRefAssign", "VarRefAssignExp"};
    static Method antlrParserTreeMethod;
    static Object parserBuilder;

    static void ininAntlrRuntime() {
        String version;
        ClassLoader classLoader = DefaultTemplateEngine.class.getClassLoader();
        Field field = null;
        try {
            field = RuntimeMetaData.class.getField("VERSION");
            version = (String)field.get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684antlr\u7248\u672c", e);
        }
        try {
            if (version.startsWith("4.10") || version.startsWith("4.11") || version.startsWith("4.12")) {
                parserBuilder = ObjectUtil.tryInstance("org.beetl.core.engine.BeetlAntlrParser411", classLoader);
            } else if (version.startsWith("4.9") || version.startsWith("4.8") || version.startsWith("4.7")) {
                parserBuilder = ObjectUtil.tryInstance("org.beetl.core.engine.BeetlAntlrParser49", classLoader);
            } else if (version.startsWith("4.5") || version.startsWith("4.6")) {
                parserBuilder = ObjectUtil.tryInstance("org.beetl.core.engine.BeetlAntlrParser45", classLoader);
            }
            if (parserBuilder == null) {
                throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684antlr\u7248\u672c:" + version + "\uff0c\u8054\u7cfbxiandafu@126.con \u5b9a\u5236\uff0c\u6216\u8005\u53c2\u8003\u6e90\u7801antlr4.5-support");
            }
            antlrParserTreeMethod = parserBuilder.getClass().getMethod("execute", Reader.class, DefaultErrorStrategy.class, BaseErrorListener.class);
        }
        catch (NoSuchMethodException | SecurityException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public Program createProgram(Resource resource, Reader reader, Map<Integer, String> textMap, String cr, GroupTemplate gt) {
        ParseTree tree = null;
        try {
            tree = (ParseTree)antlrParserTreeMethod.invoke(parserBuilder, new Object[]{reader, this.antlrErrorStrategy, this.syntaxError});
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e.getTargetException());
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
        Program program = new Program();
        program.res = resource;
        program.metaData = this.getAntlrBuilder(gt).build(tree, resource);
        program.metaData.lineSeparator = cr;
        program.metaData.staticTextArray = new Object[textMap.size()];
        int index = 0;
        Configuration conf = gt.getConf();
        boolean directByteOutput = conf.isDirectByteOutput();
        String charset = conf.getCharset();
        try {
            for (String v : textMap.values()) {
                program.metaData.staticTextArray[index++] = directByteOutput ? (Object[])v.getBytes(charset) : v.toCharArray();
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        if (program.metaData.ajaxs != null) {
            for (AjaxStatement ajax : program.metaData.ajaxs.values()) {
                ProgramMetaData metaData = ajax.getLocalProgramMetaData();
                metaData.staticTextArray = program.metaData.staticTextArray;
                metaData.lineSeparator = cr;
            }
        }
        return program;
    }

    protected void checkProgram(Program program) {
    }

    protected AntlrProgramBuilder getAntlrBuilder(GroupTemplate groupTemplate) {
        GrammarCreator grammarCreator = this.getGrammarCreator(groupTemplate);
        return new AntlrProgramBuilder(groupTemplate, grammarCreator);
    }

    protected GrammarCreator getGrammarCreator(GroupTemplate groupTemplate) {
        GrammarCreator result = new GrammarCreator();
        this.setStrictDisableGrammars(result, groupTemplate);
        return result;
    }

    protected void setStrictDisableGrammars(GrammarCreator grammarCreator, GroupTemplate groupTemplate) {
        if (groupTemplate.getConf().isStrict()) {
            for (String disableGrammar : STRICT_DISABLE_GRAMMARS) {
                grammarCreator.addDisableGrammar(disableGrammar);
            }
        }
    }

    static {
        DefaultTemplateEngine.ininAntlrRuntime();
    }
}

