/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.client.cassandra.dsdriver;

import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.impetus.client.cassandra.CassandraClientBase;
import com.impetus.client.cassandra.datahandler.CassandraDataHandler;
import com.impetus.client.cassandra.query.CassQuery;
import com.impetus.client.cassandra.thrift.CQLTranslator;
import com.impetus.kundera.KunderaException;
import com.impetus.kundera.client.Client;
import com.impetus.kundera.client.EnhanceEntity;
import com.impetus.kundera.client.cassandra.dsdriver.DSClientFactory;
import com.impetus.kundera.client.cassandra.dsdriver.DSClientUtilities;
import com.impetus.kundera.client.cassandra.dsdriver.DSIdGenerator;
import com.impetus.kundera.db.RelationHolder;
import com.impetus.kundera.db.SearchResult;
import com.impetus.kundera.generator.Generator;
import com.impetus.kundera.metadata.KunderaMetadataManager;
import com.impetus.kundera.metadata.model.EntityMetadata;
import com.impetus.kundera.metadata.model.MetamodelImpl;
import com.impetus.kundera.metadata.model.annotation.DefaultEntityAnnotationProcessor;
import com.impetus.kundera.metadata.model.attributes.AbstractAttribute;
import com.impetus.kundera.metadata.model.type.AbstractManagedType;
import com.impetus.kundera.persistence.EntityManagerFactoryImpl;
import com.impetus.kundera.persistence.EntityReader;
import com.impetus.kundera.persistence.api.Batcher;
import com.impetus.kundera.persistence.context.jointable.JoinTableData;
import com.impetus.kundera.property.PropertyAccessor;
import com.impetus.kundera.property.PropertyAccessorFactory;
import com.impetus.kundera.property.PropertyAccessorHelper;
import com.impetus.kundera.utils.KunderaCoreUtils;
import com.impetus.kundera.utils.TimestampGenerator;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.PersistenceException;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EmbeddableType;
import javax.persistence.metamodel.EntityType;
import org.apache.cassandra.thrift.IndexClause;
import org.apache.cassandra.thrift.IndexExpression;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.SuperColumn;
import org.apache.commons.lang.StringUtils;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DSClient
extends CassandraClientBase
implements Client<CassQuery>,
Batcher {
    private static Logger log = LoggerFactory.getLogger(DSClient.class);
    private DSClientFactory factory;
    private EntityReader reader;

    public DSClient(DSClientFactory factory, String persistenceUnit, Map<String, Object> externalProperties, EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata, EntityReader reader, TimestampGenerator generator) {
        super(persistenceUnit, externalProperties, kunderaMetadata, generator);
        this.factory = factory;
        this.reader = reader;
        this.clientMetadata = factory.getClientMetadata();
        this.setCqlVersion("3.0.0");
    }

    protected void onPersist(EntityMetadata entityMetadata, Object entity, Object id, List<RelationHolder> rlHolders) {
        try {
            this.cqlClient.persist(entityMetadata, entity, null, rlHolders, this.getTtlValues().get(entityMetadata.getTableName()));
        }
        catch (InvalidRequestException e) {
            log.error("Error while persisting record, Caused by: .", (Throwable)e);
            throw new KunderaException((Throwable)e);
        }
        catch (TException e) {
            log.error("Error while persisting record, Caused by: .", (Throwable)e);
            throw new KunderaException((Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            log.error("Error while persisting record, Caused by: .", (Throwable)e);
            throw new KunderaException((Throwable)e);
        }
    }

    public Object find(Class entityClass, Object rowId) {
        EntityMetadata metadata = KunderaMetadataManager.getEntityMetadata((EntityManagerFactoryImpl.KunderaMetadata)this.kunderaMetadata, (Class)entityClass);
        StringBuilder builder = this.createSelectQuery(rowId, metadata, metadata.getTableName());
        ResultSet rSet = (ResultSet)this.execute(builder.toString(), null);
        List results = this.iterateAndReturn(rSet, entityClass, metadata);
        return results.isEmpty() ? null : results.get(0);
    }

    private StringBuilder createSelectQuery(Object rowId, EntityMetadata metadata, String tableName) {
        MetamodelImpl metaModel = (MetamodelImpl)this.kunderaMetadata.getApplicationMetadata().getMetamodel(metadata.getPersistenceUnit());
        CQLTranslator translator = new CQLTranslator();
        String select_Query = "SELECT * FROM $COLUMNFAMILY";
        select_Query = StringUtils.replace((String)select_Query, (String)"$COLUMNFAMILY", (String)translator.ensureCase(new StringBuilder(), tableName, false).toString());
        StringBuilder builder = new StringBuilder(select_Query);
        builder.append(" WHERE ");
        this.onWhereClause(metadata, rowId, translator, builder, metaModel, metadata.getIdAttribute());
        builder.delete(builder.lastIndexOf(" AND "), builder.length());
        return builder;
    }

    public final <E> List<E> findAll(Class<E> entityClass, String[] columnsToSelect, Object ... rowIds) {
        ArrayList<Object> results = new ArrayList<Object>();
        if (rowIds != null) {
            for (Object rowId : rowIds) {
                Object result = this.find(entityClass, rowId);
                if (result == null) continue;
                results.add(result);
            }
        }
        return results;
    }

    public <E> List<E> find(Class<E> entityClass, Map<String, String> embeddedColumnMap) {
        throw new UnsupportedOperationException("Support for super columns is not available with DS java driver. Either use Thrift or pelops for the same");
    }

    public void persistJoinTable(JoinTableData joinTableData) {
        String joinTableName = joinTableData.getJoinTableName();
        String invJoinColumnName = joinTableData.getInverseJoinColumnName();
        Map joinTableRecords = joinTableData.getJoinTableRecords();
        EntityMetadata entityMetadata = KunderaMetadataManager.getEntityMetadata((EntityManagerFactoryImpl.KunderaMetadata)this.kunderaMetadata, (Class)joinTableData.getEntityClass());
        CQLTranslator translator = new CQLTranslator();
        String batch_Query = "BEGIN BATCH $STATEMENT ";
        String insert_Query = " INSERT INTO $COLUMNFAMILY($COLUMNS) VALUES($COLUMNVALUES) ";
        StringBuilder builder = new StringBuilder();
        builder.append("key");
        builder.append(", ");
        builder.append((CharSequence)translator.ensureCase(new StringBuilder(), joinTableData.getJoinColumnName(), false));
        builder.append(", ");
        builder.append((CharSequence)translator.ensureCase(new StringBuilder(), joinTableData.getInverseJoinColumnName(), false));
        insert_Query = StringUtils.replace((String)insert_Query, (String)"$COLUMNFAMILY", (String)translator.ensureCase(new StringBuilder(), joinTableName, false).toString());
        insert_Query = StringUtils.replace((String)insert_Query, (String)"$COLUMNS", (String)builder.toString());
        StringBuilder columnValueBuilder = new StringBuilder();
        StringBuilder statements = new StringBuilder();
        for (Object key : joinTableRecords.keySet()) {
            PropertyAccessor accessor = PropertyAccessorFactory.getPropertyAccessor((Field)((Field)entityMetadata.getIdAttribute().getJavaMember()));
            Set values = (Set)joinTableRecords.get(key);
            for (Object value : values) {
                if (value == null) continue;
                String insertQuery = insert_Query;
                columnValueBuilder.append("'");
                columnValueBuilder.append(PropertyAccessorHelper.getString(key) + "\u0001" + PropertyAccessorHelper.getString(value));
                columnValueBuilder.append("'");
                columnValueBuilder.append(", ");
                translator.appendValue(columnValueBuilder, key.getClass(), key, true, false);
                columnValueBuilder.append(", ");
                translator.appendValue(columnValueBuilder, value.getClass(), value, true, false);
                insertQuery = StringUtils.replace((String)insertQuery, (String)"$COLUMNVALUES", (String)columnValueBuilder.toString());
                statements.append(insertQuery);
                statements.append(" ");
            }
        }
        if (!StringUtils.isBlank((String)statements.toString())) {
            batch_Query = StringUtils.replace((String)batch_Query, (String)"$STATEMENT", (String)statements.toString());
            StringBuilder batchBuilder = new StringBuilder();
            batchBuilder.append(batch_Query);
            batchBuilder.append(" APPLY BATCH");
            this.execute(batchBuilder.toString(), null);
        }
    }

    public <E> List<E> getColumnsById(String schemaName, String tableName, String pKeyColumnName, String columnName, Object pKeyColumnValue, Class columnJavaType) {
        ArrayList<Object> results = new ArrayList<Object>();
        CQLTranslator translator = new CQLTranslator();
        String selectQuery = "SELECT $COLUMNS FROM $COLUMNFAMILY";
        selectQuery = StringUtils.replace((String)selectQuery, (String)"$COLUMNFAMILY", (String)translator.ensureCase(new StringBuilder(), tableName, false).toString());
        selectQuery = StringUtils.replace((String)selectQuery, (String)"$COLUMNS", (String)translator.ensureCase(new StringBuilder(), columnName, false).toString());
        StringBuilder selectQueryBuilder = new StringBuilder(selectQuery);
        selectQueryBuilder.append(" WHERE ");
        translator.buildWhereClause(selectQueryBuilder, columnJavaType, pKeyColumnName, pKeyColumnValue, "=", false);
        selectQueryBuilder.delete(selectQueryBuilder.lastIndexOf(" AND "), selectQueryBuilder.length());
        ResultSet rSet = (ResultSet)this.execute(selectQueryBuilder.toString(), null);
        for (Row row : rSet) {
            DataType dataType = row.getColumnDefinitions().getType(columnName);
            Object columnValue = DSClientUtilities.assign(row, null, null, dataType.getName(), null, columnName, null, null);
            results.add(columnValue);
        }
        return results;
    }

    public Object[] findIdsByColumn(String schemaName, String tableName, String pKeyName, String columnName, Object columnValue, Class entityClazz) {
        EntityMetadata metadata = KunderaMetadataManager.getEntityMetadata((EntityManagerFactoryImpl.KunderaMetadata)this.kunderaMetadata, (Class)entityClazz);
        return this.getColumnsById(schemaName, tableName, columnName, ((AbstractAttribute)metadata.getIdAttribute()).getJPAColumnName(), columnValue, metadata.getIdAttribute().getBindableJavaType()).toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteByColumn(String schemaName, String tableName, String columnName, Object columnValue) {
        Session session = this.factory.getConnection();
        String rowKeyName = null;
        CQLTranslator translator = new CQLTranslator();
        List primaryKeys = session.getCluster().getMetadata().getKeyspace("\"" + schemaName + "\"").getTable("\"" + tableName + "\"").getPrimaryKey();
        rowKeyName = ((ColumnMetadata)primaryKeys.get(0)).getName();
        List rowKeys = this.getColumnsById(schemaName, tableName, columnName, rowKeyName, columnValue, columnValue.getClass());
        for (Object rowKey : rowKeys) {
            if (rowKey == null) continue;
            String deleteQuery = "DELETE FROM $COLUMNFAMILY";
            deleteQuery = StringUtils.replace((String)deleteQuery, (String)"$COLUMNFAMILY", (String)translator.ensureCase(new StringBuilder(), tableName, false).toString());
            StringBuilder deleteQueryBuilder = new StringBuilder(deleteQuery);
            deleteQueryBuilder.append(" WHERE ");
            deleteQueryBuilder = translator.ensureCase(deleteQueryBuilder, rowKeyName, false);
            deleteQueryBuilder.append("=");
            translator.appendValue(deleteQueryBuilder, rowKey.getClass(), rowKey, false, false);
            this.execute(deleteQueryBuilder.toString(), null);
        }
    }

    public List<Object> findByRelation(String colName, Object colValue, Class entityClazz) {
        EntityMetadata m = KunderaMetadataManager.getEntityMetadata((EntityManagerFactoryImpl.KunderaMetadata)this.kunderaMetadata, (Class)entityClazz);
        CQLTranslator translator = new CQLTranslator();
        String selectQuery = "SELECT * FROM $COLUMNFAMILY";
        selectQuery = StringUtils.replace((String)selectQuery, (String)"$COLUMNFAMILY", (String)translator.ensureCase(new StringBuilder(), m.getTableName(), false).toString());
        StringBuilder selectQueryBuilder = new StringBuilder(selectQuery);
        selectQueryBuilder.append(" WHERE ");
        translator.buildWhereClause(selectQueryBuilder, colValue.getClass(), colName, colValue, "=", false);
        selectQueryBuilder.delete(selectQueryBuilder.lastIndexOf(" AND "), selectQueryBuilder.length());
        ResultSet rSet = (ResultSet)this.execute(selectQueryBuilder.toString(), null);
        return this.iterateAndReturn(rSet, entityClazz, m);
    }

    public EntityReader getReader() {
        return this.reader;
    }

    public Class<CassQuery> getQueryImplementor() {
        return CassQuery.class;
    }

    public List find(Class entityClass, List<String> relationNames, boolean isWrapReq, EntityMetadata metadata, Object ... rowIds) {
        return this.findAll(entityClass, null, rowIds);
    }

    protected List<SuperColumn> loadSuperColumns(String keyspace, String columnFamily, String rowId, String ... superColumnNames) {
        throw new UnsupportedOperationException("Support for super columns is not available with DS java driver. Either use Thrift or pelops for the same");
    }

    public List executeQuery(Class clazz, List<String> relationalField, boolean isNative, String cqlQuery) {
        ResultSet rSet = (ResultSet)this.execute(cqlQuery, null);
        if (clazz == null) {
            return this.iterateAndReturn(rSet);
        }
        EntityMetadata metadata = KunderaMetadataManager.getEntityMetadata((EntityManagerFactoryImpl.KunderaMetadata)this.kunderaMetadata, (Class)clazz);
        return this.iterateAndReturn(rSet, clazz, metadata);
    }

    private List iterateAndReturn(ResultSet rSet) {
        Iterator rowIter = rSet.iterator();
        ArrayList results = new ArrayList();
        while (rowIter.hasNext()) {
            Row row = (Row)rowIter.next();
            ColumnDefinitions columnDefs = row.getColumnDefinitions();
            Iterator columnDefIter = columnDefs.iterator();
            HashMap<String, Object> rowData = new HashMap<String, Object>();
            while (columnDefIter.hasNext()) {
                ColumnDefinitions.Definition columnDef = (ColumnDefinitions.Definition)columnDefIter.next();
                rowData.put(columnDef.getName(), DSClientUtilities.assign(row, null, null, columnDef.getType().getName(), null, columnDef.getName(), null, null));
            }
            results.add(rowData);
        }
        return results;
    }

    public List find(List<IndexClause> ixClause, EntityMetadata m, boolean isRelation, List<String> relations, int maxResult, List<String> columns) {
        throw new UnsupportedOperationException("Support available only for thrift/pelops.");
    }

    public List findByRange(byte[] muinVal, byte[] maxVal, EntityMetadata m, boolean isWrapReq, List<String> relations, List<String> columns, List<IndexExpression> conditions, int maxResults) throws Exception {
        throw new UnsupportedOperationException("Support available only for thrift/pelops.");
    }

    public List<SearchResult> searchInInvertedIndex(String columnFamilyName, EntityMetadata m, Map<Boolean, List<IndexClause>> indexClauseMap) {
        throw new UnsupportedOperationException("Support available only for thrift/pelops.");
    }

    public List<EnhanceEntity> find(EntityMetadata m, List<String> relationNames, List<IndexClause> conditions, int maxResult, List<String> columns) {
        throw new UnsupportedOperationException("Support available only for thrift/pelops.");
    }

    protected CassandraDataHandler getDataHandler() {
        throw new UnsupportedOperationException("Support available only for thrift/pelops.");
    }

    public void delete(Object entity, Object pKey) {
        EntityMetadata m = KunderaMetadataManager.getEntityMetadata((EntityManagerFactoryImpl.KunderaMetadata)this.kunderaMetadata, entity.getClass());
        MetamodelImpl metaModel = (MetamodelImpl)this.kunderaMetadata.getApplicationMetadata().getMetamodel(m.getPersistenceUnit());
        AbstractManagedType managedType = (AbstractManagedType)metaModel.entity(m.getEntityClazz());
        List secondaryTables = ((DefaultEntityAnnotationProcessor)managedType.getEntityAnnotation()).getSecondaryTablesName();
        secondaryTables.add(m.getTableName());
        for (String tableName : secondaryTables) {
            this.execute(this.onDeleteQuery(m, tableName, metaModel, pKey), null);
        }
    }

    protected Object getConnection() {
        return null;
    }

    protected Object getConnection(Object connection) {
        return null;
    }

    protected void releaseConnection(Object conn) {
    }

    public <T> T execute(String query, Object connection) {
        ResultSet resultSet;
        Session session = this.factory.getConnection();
        try {
            SimpleStatement queryStmt = new SimpleStatement(query);
            KunderaCoreUtils.printQuery((String)query, (boolean)this.showQuery);
            queryStmt.setConsistencyLevel(ConsistencyLevel.valueOf((String)this.consistencyLevel.name()));
            resultSet = session.execute((Statement)queryStmt);
        }
        catch (Exception e) {
            log.error("Error while executing query {}.", (Object)query);
            throw new KunderaException((Throwable)e);
        }
        return (T)resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdateDeleteQuery(String cqlQuery) {
        Session session = null;
        if (log.isInfoEnabled()) {
            log.info("Executing cql query {}.", (Object)cqlQuery);
        }
        session = this.factory.getConnection();
        KunderaCoreUtils.printQuery((String)cqlQuery, (boolean)this.showQuery);
        session.execute(cqlQuery);
        return 0;
    }

    private List iterateAndReturn(ResultSet rSet, Class entityClazz, EntityMetadata metadata) {
        MetamodelImpl metaModel = (MetamodelImpl)this.kunderaMetadata.getApplicationMetadata().getMetamodel(metadata.getPersistenceUnit());
        EntityType entityType = metaModel.entity(metadata.getEntityClazz());
        Iterator rowIter = rSet.iterator();
        ArrayList<Object> results = new ArrayList<Object>();
        HashMap<String, Object> relationalValues = new HashMap<String, Object>();
        while (rowIter.hasNext()) {
            ColumnDefinitions columnDefs;
            Iterator columnDefIter;
            Object entity = null;
            Row row = (Row)rowIter.next();
            if ((entity = this.iteratorColumns(metadata, metaModel, entityType, relationalValues, entity, row, columnDefIter = (columnDefs = row.getColumnDefinitions()).iterator())) != null && entity.getClass().isAssignableFrom(metadata.getEntityClazz())) {
                Object rowKey = PropertyAccessorHelper.getId((Object)entity, (EntityMetadata)metadata);
                this.populateSecondaryTableData(rowKey, entity, metaModel, metadata);
                if (!relationalValues.isEmpty()) {
                    results.add(new EnhanceEntity(entity, rowKey, relationalValues));
                    continue;
                }
                results.add(entity);
                continue;
            }
            if (entity == null) continue;
            results.add(entity);
        }
        return results;
    }

    private void populateSecondaryTableData(Object rowId, Object entity, MetamodelImpl metaModel, EntityMetadata metadata) {
        AbstractManagedType managedType = (AbstractManagedType)metaModel.entity(metadata.getEntityClazz());
        List secondaryTables = ((DefaultEntityAnnotationProcessor)managedType.getEntityAnnotation()).getSecondaryTablesName();
        for (String tableName : secondaryTables) {
            StringBuilder builder = this.createSelectQuery(rowId, metadata, tableName);
            ResultSet rSet = (ResultSet)this.execute(builder.toString(), null);
            Iterator rowIter = rSet.iterator();
            Row row = (Row)rowIter.next();
            ColumnDefinitions columnDefs = row.getColumnDefinitions();
            Iterator columnDefIter = columnDefs.iterator();
            entity = this.iteratorColumns(metadata, metaModel, metaModel.entity(metadata.getEntityClazz()), new HashMap<String, Object>(), entity, row, columnDefIter);
        }
    }

    private Object iteratorColumns(EntityMetadata metadata, MetamodelImpl metamodel, EntityType entityType, Map<String, Object> relationalValues, Object entity, Row row, Iterator<ColumnDefinitions.Definition> columnDefIter) {
        while (columnDefIter.hasNext()) {
            Attribute attribute;
            ColumnDefinitions.Definition columnDef = columnDefIter.next();
            String columnName = columnDef.getName();
            DataType dataType = columnDef.getType();
            if (metadata.getRelationNames() != null && metadata.getRelationNames().contains(columnName) && !columnName.equals(((AbstractAttribute)metadata.getIdAttribute()).getJPAColumnName())) {
                Object relationalValue = DSClientUtilities.assign(row, null, metadata, dataType.getName(), entityType, columnName, null, metamodel);
                relationalValues.put(columnName, relationalValue);
                continue;
            }
            String fieldName = columnName.equals(((AbstractAttribute)metadata.getIdAttribute()).getJPAColumnName()) ? metadata.getIdAttribute().getName() : metadata.getFieldName(columnName);
            Attribute attribute2 = attribute = fieldName != null ? entityType.getAttribute(fieldName) : null;
            if (attribute != null) {
                if (attribute.isAssociation()) continue;
                entity = DSClientUtilities.assign(row, entity, metadata, dataType.getName(), entityType, columnName, null, metamodel);
                continue;
            }
            if (metamodel.isEmbeddable(metadata.getIdAttribute().getBindableJavaType())) {
                entity = this.populateCompositeId(metadata, entity, columnName, row, metamodel, (Attribute)metadata.getIdAttribute(), metadata.getEntityClazz(), dataType);
                continue;
            }
            entity = DSClientUtilities.assign(row, entity, metadata, dataType.getName(), entityType, columnName, null, metamodel);
        }
        return entity;
    }

    public void close() {
        super.close();
    }

    public String getPersistenceUnit() {
        return super.getPersistenceUnit();
    }

    private Object populateCompositeId(EntityMetadata metadata, Object entity, String columnName, Row row, MetamodelImpl metaModel, Attribute attribute, Class<?> entityClazz, DataType dataType) {
        Class javaType = ((AbstractAttribute)attribute).getBindableJavaType();
        if (metaModel.isEmbeddable(javaType)) {
            EmbeddableType compoundKey = metaModel.embeddable(javaType);
            Object compoundKeyObject = null;
            try {
                Set attributes = compoundKey.getAttributes();
                entity = KunderaCoreUtils.initialize(entityClazz, (Object)entity);
                for (Attribute compoundAttribute : attributes) {
                    Object object = compoundKeyObject = compoundKeyObject == null ? this.getCompoundKey(attribute, entity) : compoundKeyObject;
                    if (metaModel.isEmbeddable(((AbstractAttribute)compoundAttribute).getBindableJavaType())) {
                        Object compoundObject = this.populateCompositeId(metadata, compoundKeyObject, columnName, row, metaModel, compoundAttribute, javaType, dataType);
                        PropertyAccessorHelper.set((Object)entity, (Field)((Field)attribute.getJavaMember()), (Object)compoundObject);
                        continue;
                    }
                    if (!((AbstractAttribute)compoundAttribute).getJPAColumnName().equals(columnName)) continue;
                    DSClientUtilities.assign(row, compoundKeyObject, null, dataType.getName(), null, columnName, (Field)compoundAttribute.getJavaMember(), metaModel);
                    PropertyAccessorHelper.set((Object)entity, (Field)((Field)attribute.getJavaMember()), (Object)compoundKeyObject);
                    break;
                }
            }
            catch (IllegalArgumentException iaex) {
            }
            catch (Exception e) {
                log.error("Error while retrieving data, Caused by: .", (Throwable)e);
                throw new PersistenceException((Throwable)e);
            }
        }
        return entity;
    }

    private Object getCompoundKey(Attribute attribute, Object entity) throws InstantiationException, IllegalAccessException {
        Object compoundKeyObject = null;
        if (entity != null && (compoundKeyObject = PropertyAccessorHelper.getObject((Object)entity, (Field)((Field)attribute.getJavaMember()))) == null) {
            compoundKeyObject = ((AbstractAttribute)attribute).getBindableJavaType().newInstance();
        }
        return compoundKeyObject;
    }

    public Generator getIdGenerator() {
        return (Generator)KunderaCoreUtils.createNewInstance(DSIdGenerator.class);
    }
}

