/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.client.cassandra.dsdriver;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.ProtocolOptions;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SocketOptions;
import com.datastax.driver.core.policies.ConstantReconnectionPolicy;
import com.datastax.driver.core.policies.DCAwareRoundRobinPolicy;
import com.datastax.driver.core.policies.DowngradingConsistencyRetryPolicy;
import com.datastax.driver.core.policies.ExponentialReconnectionPolicy;
import com.datastax.driver.core.policies.FallthroughRetryPolicy;
import com.datastax.driver.core.policies.LatencyAwarePolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.LoggingRetryPolicy;
import com.datastax.driver.core.policies.RoundRobinPolicy;
import com.datastax.driver.core.policies.TokenAwarePolicy;
import com.impetus.client.cassandra.common.CassandraClientFactory;
import com.impetus.client.cassandra.config.CassandraPropertyReader;
import com.impetus.client.cassandra.query.CassandraEntityReader;
import com.impetus.client.cassandra.schemamanager.CassandraSchemaManager;
import com.impetus.client.cassandra.service.CassandraHost;
import com.impetus.client.cassandra.service.CassandraHostConfiguration;
import com.impetus.kundera.KunderaException;
import com.impetus.kundera.client.Client;
import com.impetus.kundera.client.cassandra.dsdriver.DSClient;
import com.impetus.kundera.configure.schema.api.SchemaManager;
import com.impetus.kundera.metadata.model.PersistenceUnitMetadata;
import com.impetus.kundera.service.Host;
import com.impetus.kundera.utils.InvalidConfigurationException;
import com.impetus.kundera.utils.KunderaCoreUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DSClientFactory
extends CassandraClientFactory {
    private static final String GET_INSTANCE = "getInstance";
    private static final String CUSTOM_RETRY_POLICY = "customRetryPolicy";
    private static Logger logger = LoggerFactory.getLogger(DSClientFactory.class);
    private CassandraHostConfiguration configuration;
    private String keyspace;
    private Session session;

    public SchemaManager getSchemaManager(Map<String, Object> puProperties) {
        if (this.schemaManager == null) {
            this.initializePropertyReader();
            this.externalProperties.put("cql.version", "3.0.0");
            this.schemaManager = new CassandraSchemaManager(((Object)((Object)this)).getClass().getName(), this.externalProperties, this.kunderaMetadata);
        }
        return this.schemaManager;
    }

    public void destroy() {
        if (this.indexManager != null) {
            this.indexManager.close();
        }
        if (this.schemaManager != null) {
            this.schemaManager.dropSchema();
        }
        this.schemaManager = null;
        this.externalProperties = null;
        this.releaseConnection(this.session);
        ((Cluster)this.getConnectionPoolOrConnection()).closeAsync();
    }

    public boolean addCassandraHost(CassandraHost host) {
        return false;
    }

    public void initialize(Map<String, Object> externalProperty) {
        this.reader = new CassandraEntityReader(this.kunderaMetadata);
        this.initializePropertyReader();
        this.setExternalProperties(externalProperty);
        this.configuration = new CassandraHostConfiguration(this.externalProperties, CassandraPropertyReader.csmd, this.getPersistenceUnit(), this.kunderaMetadata);
        this.initializeTimestampGenerator(externalProperty);
    }

    protected Object createPoolOrConnection() {
        com.datastax.driver.core.policies.RetryPolicy policy;
        String retryPolicy;
        com.datastax.driver.core.policies.ReconnectionPolicy policy2;
        String reconnectionPolicy;
        String compression;
        LoadBalancingPolicy policy3;
        if (logger.isDebugEnabled()) {
            logger.debug("Intiatilzing connection");
        }
        Properties connectionProperties = CassandraPropertyReader.csmd.getConnectionProperties();
        Cluster.Builder connectionBuilder = Cluster.builder();
        for (Host host : this.configuration.getCassandraHosts()) {
            connectionBuilder.addContactPoint(host.getHost()).withPort(host.getPort());
            if (host.getUser() == null) continue;
            connectionBuilder.withCredentials(host.getUser(), host.getPassword());
        }
        String loadBalancingPolicy = connectionProperties.getProperty("loadbalancing.policy");
        if (!StringUtils.isBlank((String)loadBalancingPolicy) && (policy3 = this.getPolicyInstance(BalancingPolicy.getPolicy(loadBalancingPolicy), connectionProperties)) != null) {
            connectionBuilder.withLoadBalancingPolicy(policy3);
        }
        if (!StringUtils.isBlank((String)(compression = connectionProperties.getProperty("compression")))) {
            connectionBuilder.withCompression(ProtocolOptions.Compression.valueOf((String)compression));
        }
        if (!StringUtils.isBlank((String)(reconnectionPolicy = connectionProperties.getProperty("reconnection.policy"))) && (policy2 = this.getPolicy(ReconnectionPolicy.getPolicy(reconnectionPolicy), connectionProperties)) != null) {
            connectionBuilder.withReconnectionPolicy(policy2);
        }
        if (!StringUtils.isBlank((String)(retryPolicy = connectionProperties.getProperty("retry.policy"))) && (policy = this.getPolicy(RetryPolicy.getPolicy(retryPolicy), connectionProperties)) != null) {
            connectionBuilder.withRetryPolicy(policy);
        }
        connectionBuilder.withSocketOptions(this.getSocketOptions(connectionProperties));
        connectionBuilder.withPoolingOptions(this.getPoolingOptions(connectionProperties));
        Cluster cluster = connectionBuilder.build();
        PersistenceUnitMetadata persistenceUnitMetadata = this.kunderaMetadata.getApplicationMetadata().getPersistenceUnitMetadata(this.getPersistenceUnit());
        Properties props = persistenceUnitMetadata.getProperties();
        if (this.externalProperties != null) {
            this.keyspace = (String)this.externalProperties.get("kundera.keyspace");
        }
        if (this.keyspace == null) {
            this.keyspace = (String)props.get("kundera.keyspace");
        }
        this.setSessionObject(cluster);
        return cluster;
    }

    protected Client<?> instantiateClient(String persistenceUnit) {
        return new DSClient(this, persistenceUnit, this.externalProperties, this.kunderaMetadata, this.reader, this.timestampGenerator);
    }

    void setSessionObject(Cluster cluster) {
        this.session = cluster.connect("\"" + this.keyspace + "\"");
    }

    Session getConnection() {
        return this.session != null ? this.session : ((Cluster)this.getConnectionPoolOrConnection()).connect("\"" + this.keyspace + "\"");
    }

    void releaseConnection(Session session) {
        if (session != null) {
            session.closeAsync();
        }
    }

    public boolean isThreadSafe() {
        return false;
    }

    protected void initializeLoadBalancer(String loadBalancingPolicyName) {
        throw new UnsupportedOperationException("Method not supported for datastax java driver");
    }

    private void initializePropertyReader() {
        if (this.propertyReader == null) {
            this.propertyReader = new CassandraPropertyReader(this.externalProperties, this.kunderaMetadata.getApplicationMetadata().getPersistenceUnitMetadata(this.getPersistenceUnit()));
            this.propertyReader.read(this.getPersistenceUnit());
        }
    }

    private LoadBalancingPolicy getPolicyInstance(BalancingPolicy policy, Properties conProperties) {
        RoundRobinPolicy loadBalancingPolicy = null;
        String isTokenAware = (String)conProperties.get("isTokenAware");
        String isLatencyAware = (String)conProperties.get("isLatencyAware");
        switch (policy) {
            case DCAwareRoundRobinPolicy: {
                String usedHostsPerRemoteDc = (String)conProperties.get("usedHostsPerRemoteDc");
                String localdc = (String)conProperties.get("localdc");
                loadBalancingPolicy = new DCAwareRoundRobinPolicy(localdc == null ? "DC1" : localdc, usedHostsPerRemoteDc != null ? Integer.parseInt(usedHostsPerRemoteDc) : 0);
                break;
            }
            default: {
                loadBalancingPolicy = new RoundRobinPolicy();
            }
        }
        if (loadBalancingPolicy != null && Boolean.valueOf(isTokenAware).booleanValue()) {
            loadBalancingPolicy = new TokenAwarePolicy((LoadBalancingPolicy)loadBalancingPolicy);
        } else if (loadBalancingPolicy != null && Boolean.valueOf(isLatencyAware).booleanValue()) {
            loadBalancingPolicy = LatencyAwarePolicy.builder((LoadBalancingPolicy)loadBalancingPolicy).build();
        }
        return loadBalancingPolicy;
    }

    private com.datastax.driver.core.policies.ReconnectionPolicy getPolicy(ReconnectionPolicy policy, Properties props) {
        ConstantReconnectionPolicy reconnectionPolicy = null;
        switch (policy) {
            case ConstantReconnectionPolicy: {
                String property = props.getProperty("constantDelayMs");
                long constantDelayMs = property != null ? new Long(property) : 0L;
                reconnectionPolicy = new ConstantReconnectionPolicy(constantDelayMs);
                break;
            }
            case ExponentialReconnectionPolicy: {
                String baseDelayMsAsStr = props.getProperty("baseDelayMs");
                String maxDelayMsAsStr = props.getProperty("maxDelayMs");
                if (StringUtils.isBlank((String)baseDelayMsAsStr) || StringUtils.isBlank((String)maxDelayMsAsStr)) break;
                long baseDelayMs = new Long(baseDelayMsAsStr);
                long maxDelayMs = new Long(maxDelayMsAsStr);
                reconnectionPolicy = new ExponentialReconnectionPolicy(baseDelayMs, maxDelayMs);
                break;
            }
        }
        return reconnectionPolicy;
    }

    private com.datastax.driver.core.policies.RetryPolicy getPolicy(RetryPolicy policy, Properties props) {
        DowngradingConsistencyRetryPolicy retryPolicy = null;
        String isLoggingRetry = (String)props.get("isLoggingRetry");
        switch (policy) {
            case DowngradingConsistencyRetryPolicy: {
                retryPolicy = DowngradingConsistencyRetryPolicy.INSTANCE;
                break;
            }
            case FallthroughRetryPolicy: {
                retryPolicy = FallthroughRetryPolicy.INSTANCE;
                break;
            }
            case Custom: {
                retryPolicy = this.getCustomRetryPolicy(props);
                break;
            }
        }
        if (retryPolicy != null && Boolean.valueOf(isLoggingRetry).booleanValue()) {
            retryPolicy = new LoggingRetryPolicy((com.datastax.driver.core.policies.RetryPolicy)retryPolicy);
        }
        return retryPolicy;
    }

    private com.datastax.driver.core.policies.RetryPolicy getCustomRetryPolicy(Properties props) {
        String customRetryPolicy = (String)props.get(CUSTOM_RETRY_POLICY);
        Class<?> clazz = null;
        Method getter = null;
        try {
            clazz = Class.forName(customRetryPolicy);
            com.datastax.driver.core.policies.RetryPolicy retryPolicy = (com.datastax.driver.core.policies.RetryPolicy)KunderaCoreUtils.createNewInstance(clazz);
            if (retryPolicy != null) {
                return retryPolicy;
            }
            getter = clazz.getDeclaredMethod(GET_INSTANCE, new Class[0]);
            return (com.datastax.driver.core.policies.RetryPolicy)getter.invoke(null, (Object[])null);
        }
        catch (ClassNotFoundException e) {
            logger.error(e.getMessage());
            throw new KunderaException("Please make sure class " + customRetryPolicy + " set in property file exists in classpath " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            logger.error(e.getMessage());
            throw new KunderaException("Method " + getter.getName() + " must be declared public " + e.getMessage());
        }
        catch (NoSuchMethodException e) {
            logger.error(e.getMessage());
            throw new KunderaException("Please make sure getter method of " + clazz.getSimpleName() + " is named \"getInstance()\"");
        }
        catch (InvocationTargetException e) {
            logger.error(e.getMessage());
            throw new KunderaException("Error while executing \"getInstance()\" method of Class " + clazz.getSimpleName() + ": " + e.getMessage());
        }
    }

    private SocketOptions getSocketOptions(Properties connectionProperties) {
        SocketOptions socketConfig = new SocketOptions();
        String connectTimeoutMillis = connectionProperties.getProperty("socket.timeout");
        String readTimeoutMillis = connectionProperties.getProperty("readTimeoutMillis");
        String keepAlive = connectionProperties.getProperty("keepAlive");
        String reuseAddress = connectionProperties.getProperty("reuseAddress");
        String soLinger = connectionProperties.getProperty("soLinger");
        String tcpNoDelay = connectionProperties.getProperty("tcpNoDelay");
        String receiveBufferSize = connectionProperties.getProperty("receiveBufferSize");
        String sendBufferSize = connectionProperties.getProperty("sendBufferSize");
        if (!StringUtils.isBlank((String)connectTimeoutMillis)) {
            socketConfig.setConnectTimeoutMillis(new Integer(connectTimeoutMillis).intValue());
        }
        if (!StringUtils.isBlank((String)readTimeoutMillis)) {
            socketConfig.setReadTimeoutMillis(new Integer(readTimeoutMillis).intValue());
        }
        if (!StringUtils.isBlank((String)keepAlive)) {
            socketConfig.setKeepAlive(new Boolean(keepAlive).booleanValue());
        }
        if (!StringUtils.isBlank((String)reuseAddress)) {
            socketConfig.setReuseAddress(new Boolean(reuseAddress).booleanValue());
        }
        if (!StringUtils.isBlank((String)soLinger)) {
            socketConfig.setSoLinger(new Integer(soLinger).intValue());
        }
        if (!StringUtils.isBlank((String)tcpNoDelay)) {
            socketConfig.setTcpNoDelay(new Boolean(tcpNoDelay).booleanValue());
        }
        if (!StringUtils.isBlank((String)receiveBufferSize)) {
            socketConfig.setReceiveBufferSize(new Integer(receiveBufferSize).intValue());
        }
        if (!StringUtils.isBlank((String)sendBufferSize)) {
            socketConfig.setSendBufferSize(new Integer(sendBufferSize).intValue());
        }
        return socketConfig;
    }

    private PoolingOptions getPoolingOptions(Properties connectionProperties) {
        PoolingOptions options = new PoolingOptions();
        String hostDistance = connectionProperties.getProperty("hostDistance");
        String minSimultaneousRequests = connectionProperties.getProperty("minSimultaneousRequests");
        String maxSimultaneousRequests = connectionProperties.getProperty("maxSimultaneousRequests");
        String coreConnections = connectionProperties.getProperty("coreConnections");
        String maxConnections = connectionProperties.getProperty("maxConnections");
        if (!StringUtils.isBlank((String)hostDistance)) {
            HostDistance hostDist = HostDistance.valueOf((String)hostDistance.toUpperCase());
            if (!StringUtils.isBlank((String)coreConnections)) {
                options.setCoreConnectionsPerHost(HostDistance.LOCAL, new Integer(coreConnections).intValue());
            }
            if (!StringUtils.isBlank((String)maxConnections)) {
                options.setMaxConnectionsPerHost(hostDist, new Integer(maxConnections).intValue());
            }
            if (!StringUtils.isBlank((String)minSimultaneousRequests)) {
                options.setMinSimultaneousRequestsPerConnectionThreshold(hostDist, new Integer(minSimultaneousRequests).intValue());
            }
            if (!StringUtils.isBlank((String)maxSimultaneousRequests)) {
                options.setMaxSimultaneousRequestsPerConnectionThreshold(hostDist, new Integer(maxSimultaneousRequests).intValue());
            }
        }
        return options;
    }

    static enum RetryPolicy {
        DowngradingConsistencyRetryPolicy,
        FallthroughRetryPolicy,
        Custom;


        static RetryPolicy getPolicy(String name) {
            for (RetryPolicy p : RetryPolicy.values()) {
                if (!p.name().equalsIgnoreCase(name)) continue;
                return p;
            }
            logger.error("Invalid policy name {} provided, supported policies are {}", (Object)name, (Object)RetryPolicy.values());
            throw new InvalidConfigurationException("Invalid policy name " + name + " provided!");
        }
    }

    static enum BalancingPolicy {
        DCAwareRoundRobinPolicy,
        RoundRobinPolicy;


        static BalancingPolicy getPolicy(String name) {
            for (BalancingPolicy p : BalancingPolicy.values()) {
                if (!p.name().equalsIgnoreCase(name)) continue;
                return p;
            }
            logger.error("Invalid policy name {} provided, supported policies are {}", (Object)name, (Object)BalancingPolicy.values());
            throw new InvalidConfigurationException("Invalid policy name " + name + " provided!");
        }
    }

    static enum ReconnectionPolicy {
        ConstantReconnectionPolicy,
        ExponentialReconnectionPolicy;


        static ReconnectionPolicy getPolicy(String name) {
            for (ReconnectionPolicy p : ReconnectionPolicy.values()) {
                if (!p.name().equalsIgnoreCase(name)) continue;
                return p;
            }
            logger.error("Invalid policy name {} provided, supported policies are {}", (Object)name, (Object)ReconnectionPolicy.values());
            throw new InvalidConfigurationException("Invalid policy name " + name + " provided!");
        }
    }
}

