/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.client.cassandra.dsdriver;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.UDTValue;
import com.impetus.client.cassandra.schemamanager.CassandraDataTranslator;
import com.impetus.client.cassandra.schemamanager.CassandraValidationClassMapper;
import com.impetus.kundera.metadata.model.EntityMetadata;
import com.impetus.kundera.metadata.model.MetamodelImpl;
import com.impetus.kundera.metadata.model.attributes.AbstractAttribute;
import com.impetus.kundera.property.PropertyAccessorHelper;
import com.impetus.kundera.property.accessor.CharAccessor;
import com.impetus.kundera.property.accessor.EnumAccessor;
import com.impetus.kundera.utils.KunderaCoreUtils;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Embeddable;
import javax.persistence.metamodel.EmbeddableType;
import javax.persistence.metamodel.EntityType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.utils.ByteBufferUtil;

public final class DSClientUtilities {
    static Object assign(Row row, Object entity, EntityMetadata metadata, DataType.Name dataType, EntityType entityType, String columnName, Field member, MetamodelImpl metamodel) {
        String fieldName = null;
        if (metadata != null) {
            if (columnName.equals(((AbstractAttribute)metadata.getIdAttribute()).getJPAColumnName())) {
                entity = KunderaCoreUtils.initialize((EntityMetadata)metadata, (Object)entity, null);
                fieldName = metadata.getIdAttribute().getName();
                member = (Field)metadata.getIdAttribute().getJavaMember();
            } else if (!(metadata.getRelationNames() != null && metadata.getRelationNames().contains(columnName) || (fieldName = metadata.getFieldName(columnName)) == null || entityType == null)) {
                entity = KunderaCoreUtils.initialize((EntityMetadata)metadata, (Object)entity, null);
                member = (Field)entityType.getAttribute(fieldName).getJavaMember();
            }
        }
        Object retVal = null;
        switch (dataType) {
            case BLOB: 
            case CUSTOM: {
                retVal = row.getBytes(columnName);
                if (member == null || retVal == null || entity == null) break;
                PropertyAccessorHelper.set((Object)entity, (Field)member, (byte[])((ByteBuffer)retVal).array());
                break;
            }
            case BOOLEAN: {
                retVal = row.getBool(columnName);
                DSClientUtilities.setFieldValue(entity, member, retVal);
                break;
            }
            case BIGINT: 
            case COUNTER: {
                retVal = row.getLong(columnName);
                DSClientUtilities.setFieldValue(entity, member, retVal);
                break;
            }
            case DECIMAL: {
                retVal = row.getDecimal(columnName);
                DSClientUtilities.setFieldValue(entity, member, retVal);
                break;
            }
            case DOUBLE: {
                retVal = row.getDouble(columnName);
                DSClientUtilities.setFieldValue(entity, member, retVal);
                break;
            }
            case FLOAT: {
                retVal = Float.valueOf(row.getFloat(columnName));
                DSClientUtilities.setFieldValue(entity, member, retVal);
                break;
            }
            case INET: {
                retVal = row.getInet(columnName);
                DSClientUtilities.setFieldValue(entity, member, retVal);
                break;
            }
            case INT: {
                retVal = row.getInt(columnName);
                retVal = DSClientUtilities.setIntValue(member, retVal);
                DSClientUtilities.setFieldValue(entity, member, retVal);
                break;
            }
            case ASCII: 
            case TEXT: 
            case VARCHAR: {
                retVal = row.getString(columnName);
                retVal = DSClientUtilities.setTextValue(entity, member, retVal);
                DSClientUtilities.setFieldValue(entity, member, retVal);
                break;
            }
            case TIMESTAMP: {
                retVal = row.getDate(columnName);
                if (retVal != null && member != null) {
                    retVal = CassandraDataTranslator.decompose(member.getType(), (Object)ByteBufferUtil.bytes((long)((Date)retVal).getTime()).array(), (boolean)true);
                }
                DSClientUtilities.setFieldValue(entity, member, retVal);
                break;
            }
            case VARINT: {
                retVal = row.getVarint(columnName);
                DSClientUtilities.setFieldValue(entity, member, retVal);
                break;
            }
            case UUID: 
            case TIMEUUID: {
                retVal = row.getUUID(columnName);
                DSClientUtilities.setFieldValue(entity, member, retVal);
                break;
            }
            case LIST: {
                Iterator collectionItems;
                Class<UDTValue> listAttributeTypeClass = PropertyAccessorHelper.getGenericClass((Field)member);
                Class<UDTValue> listClazz = null;
                boolean isElementCollectionList = false;
                if (listAttributeTypeClass.isAssignableFrom(byte[].class)) {
                    listClazz = ByteBuffer.class;
                } else if (listAttributeTypeClass.isAnnotationPresent(Embeddable.class)) {
                    isElementCollectionList = true;
                    listClazz = UDTValue.class;
                } else {
                    listClazz = listAttributeTypeClass;
                }
                retVal = row.getList(columnName, (Class)listClazz);
                ArrayList<Object> resultList = new ArrayList<Object>();
                if (isElementCollectionList) {
                    collectionItems = ((Collection)retVal).iterator();
                    while (collectionItems.hasNext()) {
                        resultList.add(DSClientUtilities.setUDTValue(entity, listAttributeTypeClass, (UDTValue)collectionItems.next(), metamodel));
                    }
                }
                if (retVal != null && !((List)retVal).isEmpty() && !isElementCollectionList) {
                    if (listAttributeTypeClass.isAssignableFrom(byte[].class)) {
                        PropertyAccessorHelper.set((Object)entity, (Field)member, (Object)CassandraDataTranslator.marshalCollection(BytesType.class, (Collection)((Collection)retVal), listAttributeTypeClass, ArrayList.class));
                        break;
                    }
                    collectionItems = ((Collection)retVal).iterator();
                    while (collectionItems.hasNext()) {
                        resultList.add(collectionItems.next());
                    }
                    PropertyAccessorHelper.set((Object)entity, (Field)member, resultList);
                    break;
                }
                if (retVal == null || ((Collection)retVal).isEmpty()) break;
                PropertyAccessorHelper.set((Object)entity, (Field)member, resultList);
                break;
            }
            case SET: {
                Iterator collectionItems;
                Class<UDTValue> setAttributeTypeClass = PropertyAccessorHelper.getGenericClass((Field)member);
                Class<UDTValue> setClazz = null;
                boolean isElementCollectionSet = false;
                if (setAttributeTypeClass.isAssignableFrom(byte[].class)) {
                    setClazz = ByteBuffer.class;
                } else if (setAttributeTypeClass.isAnnotationPresent(Embeddable.class)) {
                    isElementCollectionSet = true;
                    setClazz = UDTValue.class;
                } else {
                    setClazz = setAttributeTypeClass;
                }
                retVal = row.getSet(columnName, (Class)setClazz);
                HashSet<Object> resultSet = new HashSet<Object>();
                if (isElementCollectionSet) {
                    collectionItems = ((Collection)retVal).iterator();
                    while (collectionItems.hasNext()) {
                        resultSet.add(DSClientUtilities.setUDTValue(entity, setAttributeTypeClass, (UDTValue)collectionItems.next(), metamodel));
                    }
                }
                if (retVal != null && !((Set)retVal).isEmpty() && !isElementCollectionSet) {
                    if (setAttributeTypeClass.isAssignableFrom(byte[].class)) {
                        PropertyAccessorHelper.set((Object)entity, (Field)member, (Object)CassandraDataTranslator.marshalCollection(BytesType.class, (Collection)((Collection)retVal), setAttributeTypeClass, HashSet.class));
                        break;
                    }
                    collectionItems = ((Collection)retVal).iterator();
                    while (collectionItems.hasNext()) {
                        resultSet.add(collectionItems.next());
                    }
                    PropertyAccessorHelper.set((Object)entity, (Field)member, resultSet);
                    break;
                }
                if (retVal == null || ((Collection)retVal).isEmpty()) break;
                PropertyAccessorHelper.set((Object)entity, (Field)member, resultSet);
                break;
            }
            case MAP: {
                boolean isByteBuffer;
                List mapGenericClasses = PropertyAccessorHelper.getGenericClasses((Field)member);
                Class keyClass = CassandraValidationClassMapper.getValidationClassInstance((Class)((Class)mapGenericClasses.get(0)), (boolean)true);
                Class valueClass = CassandraValidationClassMapper.getValidationClassInstance((Class)((Class)mapGenericClasses.get(1)), (boolean)true);
                Class mapValueClazz = null;
                boolean isElementCollectionMap = false;
                if (((Class)mapGenericClasses.get(1)).isAssignableFrom(byte[].class)) {
                    mapValueClazz = ByteBuffer.class;
                } else if (((Class)mapGenericClasses.get(1)).isAnnotationPresent(Embeddable.class)) {
                    isElementCollectionMap = true;
                    mapValueClazz = UDTValue.class;
                } else {
                    mapValueClazz = (Class)mapGenericClasses.get(1);
                }
                retVal = row.getMap(columnName, ((Class)mapGenericClasses.get(0)).isAssignableFrom(byte[].class) ? ByteBuffer.class : (Class)mapGenericClasses.get(0), mapValueClazz);
                HashMap resultMap = new HashMap();
                if (isElementCollectionMap) {
                    for (Object keyValue : ((Map)retVal).keySet()) {
                        resultMap.put(keyValue, DSClientUtilities.setUDTValue(entity, (Class)mapGenericClasses.get(1), (UDTValue)((Map)retVal).get(keyValue), metamodel));
                    }
                }
                boolean bl = isByteBuffer = ((Class)mapGenericClasses.get(0)).isAssignableFrom(byte[].class) || ((Class)mapGenericClasses.get(1)).isAssignableFrom(byte[].class);
                if (retVal != null && !((Map)retVal).isEmpty() && !isElementCollectionMap) {
                    if (isByteBuffer) {
                        PropertyAccessorHelper.set((Object)entity, (Field)member, (Object)CassandraDataTranslator.marshalMap((List)mapGenericClasses, (Class)keyClass, (Class)valueClass, (Map)((Map)retVal)));
                        break;
                    }
                    for (Object keyValue : ((Map)retVal).keySet()) {
                        resultMap.put(keyValue, ((Map)retVal).get(keyValue));
                    }
                    PropertyAccessorHelper.set((Object)entity, (Field)member, resultMap);
                    break;
                }
                if (retVal == null || ((Map)retVal).isEmpty()) break;
                PropertyAccessorHelper.set((Object)entity, (Field)member, resultMap);
                break;
            }
            case UDT: {
                retVal = row.getUDTValue(columnName);
                PropertyAccessorHelper.set((Object)entity, (Field)member, (Object)DSClientUtilities.setUDTValue(entity, member.getType(), (UDTValue)retVal, metamodel));
            }
        }
        return entity != null ? entity : retVal;
    }

    private static Object setUDTValue(Object entity, Class embeddedClass, UDTValue udt, MetamodelImpl metaModel) {
        Object embeddedObject = KunderaCoreUtils.createNewInstance((Class)embeddedClass);
        EmbeddableType embeddable = metaModel.embeddable(embeddedClass);
        for (Object subAttribute : embeddable.getAttributes()) {
            Field embeddableColumn = (Field)((AbstractAttribute)subAttribute).getJavaMember();
            if (metaModel.isEmbeddable(embeddableColumn.getType())) {
                UDTValue subUDT = udt.getUDTValue(((AbstractAttribute)subAttribute).getJPAColumnName());
                PropertyAccessorHelper.set((Object)embeddedObject, (Field)embeddableColumn, (Object)DSClientUtilities.setUDTValue(embeddedObject, embeddableColumn.getType(), subUDT, metaModel));
                continue;
            }
            DSClientUtilities.setBasicValue(embeddedObject, embeddableColumn, ((AbstractAttribute)subAttribute).getJPAColumnName(), udt, CassandraDataTranslator.getCassandraDataTypeClass(embeddableColumn.getType()), metaModel);
        }
        return embeddedObject;
    }

    private static void setBasicValue(Object entity, Field member, String columnName, UDTValue row, CassandraDataTranslator.CassandraType dataType, MetamodelImpl metamodel) {
        Object retVal = null;
        switch (dataType) {
            case BYTES: {
                retVal = row.getBytes(columnName);
                if (retVal == null) break;
                PropertyAccessorHelper.set((Object)entity, (Field)member, (byte[])((ByteBuffer)retVal).array());
                break;
            }
            case BOOLEAN: {
                retVal = row.getBool(columnName);
                DSClientUtilities.setFieldValue(entity, member, retVal);
                break;
            }
            case BIGINT: 
            case COUNTER: {
                retVal = row.getLong(columnName);
                DSClientUtilities.setFieldValue(entity, member, retVal);
                break;
            }
            case DECIMAL: {
                retVal = row.getDecimal(columnName);
                DSClientUtilities.setFieldValue(entity, member, retVal);
                break;
            }
            case DOUBLE: {
                retVal = row.getDouble(columnName);
                DSClientUtilities.setFieldValue(entity, member, retVal);
                break;
            }
            case FLOAT: {
                retVal = Float.valueOf(row.getFloat(columnName));
                DSClientUtilities.setFieldValue(entity, member, retVal);
                break;
            }
            case INET: {
                retVal = row.getInet(columnName);
                DSClientUtilities.setFieldValue(entity, member, retVal);
                break;
            }
            case INT: {
                retVal = row.getInt(columnName);
                retVal = DSClientUtilities.setIntValue(member, retVal);
                DSClientUtilities.setFieldValue(entity, member, retVal);
                break;
            }
            case ASCII: 
            case STRING: 
            case CHARACTER: {
                try {
                    row.getBytes(columnName);
                }
                catch (Exception e) {
                    // empty catch block
                }
                retVal = row.getString(columnName);
                retVal = DSClientUtilities.setTextValue(entity, member, retVal);
                DSClientUtilities.setFieldValue(entity, member, retVal);
                break;
            }
            case TIMESTAMP: {
                retVal = row.getDate(columnName);
                if (retVal != null && member != null) {
                    retVal = CassandraDataTranslator.decompose(member.getType(), (Object)ByteBufferUtil.bytes((long)((Date)retVal).getTime()).array(), (boolean)true);
                }
                DSClientUtilities.setFieldValue(entity, member, retVal);
                break;
            }
            case UUID: {
                retVal = row.getUUID(columnName);
                DSClientUtilities.setFieldValue(entity, member, retVal);
                break;
            }
            case LIST: {
                Iterator collectionItems;
                Class<UDTValue> listAttributeTypeClass = PropertyAccessorHelper.getGenericClass((Field)member);
                Class<UDTValue> listClazz = null;
                boolean isElementCollectionList = false;
                if (listAttributeTypeClass.isAssignableFrom(byte[].class)) {
                    listClazz = ByteBuffer.class;
                } else if (listAttributeTypeClass.isAnnotationPresent(Embeddable.class)) {
                    isElementCollectionList = true;
                    listClazz = UDTValue.class;
                } else {
                    listClazz = listAttributeTypeClass;
                }
                retVal = row.getList(columnName, (Class)listClazz);
                ArrayList<Object> resultList = new ArrayList<Object>();
                if (isElementCollectionList) {
                    collectionItems = ((Collection)retVal).iterator();
                    while (collectionItems.hasNext()) {
                        resultList.add(DSClientUtilities.setUDTValue(entity, listAttributeTypeClass, (UDTValue)collectionItems.next(), metamodel));
                    }
                }
                if (retVal != null && !((List)retVal).isEmpty() && !isElementCollectionList) {
                    if (listAttributeTypeClass.isAssignableFrom(byte[].class)) {
                        PropertyAccessorHelper.set((Object)entity, (Field)member, (Object)CassandraDataTranslator.marshalCollection(BytesType.class, (Collection)((Collection)retVal), listAttributeTypeClass, ArrayList.class));
                        break;
                    }
                    collectionItems = ((Collection)retVal).iterator();
                    while (collectionItems.hasNext()) {
                        resultList.add(collectionItems.next());
                    }
                    PropertyAccessorHelper.set((Object)entity, (Field)member, resultList);
                    break;
                }
                if (retVal == null || ((Collection)retVal).isEmpty()) break;
                PropertyAccessorHelper.set((Object)entity, (Field)member, resultList);
                break;
            }
            case SET: {
                Iterator collectionItems;
                Class<UDTValue> setAttributeTypeClass = PropertyAccessorHelper.getGenericClass((Field)member);
                Class<UDTValue> setClazz = null;
                boolean isElementCollectionSet = false;
                if (setAttributeTypeClass.isAssignableFrom(byte[].class)) {
                    setClazz = ByteBuffer.class;
                } else if (setAttributeTypeClass.isAnnotationPresent(Embeddable.class)) {
                    isElementCollectionSet = true;
                    setClazz = UDTValue.class;
                } else {
                    setClazz = setAttributeTypeClass;
                }
                retVal = row.getSet(columnName, (Class)setClazz);
                HashSet<Object> resultSet = new HashSet<Object>();
                if (isElementCollectionSet) {
                    collectionItems = ((Collection)retVal).iterator();
                    while (collectionItems.hasNext()) {
                        resultSet.add(DSClientUtilities.setUDTValue(entity, setAttributeTypeClass, (UDTValue)collectionItems.next(), metamodel));
                    }
                }
                if (retVal != null && !((Set)retVal).isEmpty() && !isElementCollectionSet) {
                    if (setAttributeTypeClass.isAssignableFrom(byte[].class)) {
                        PropertyAccessorHelper.set((Object)entity, (Field)member, (Object)CassandraDataTranslator.marshalCollection(BytesType.class, (Collection)((Collection)retVal), setAttributeTypeClass, HashSet.class));
                        break;
                    }
                    collectionItems = ((Collection)retVal).iterator();
                    while (collectionItems.hasNext()) {
                        resultSet.add(collectionItems.next());
                    }
                    PropertyAccessorHelper.set((Object)entity, (Field)member, resultSet);
                    break;
                }
                if (retVal == null || ((Collection)retVal).isEmpty()) break;
                PropertyAccessorHelper.set((Object)entity, (Field)member, resultSet);
                break;
            }
            case MAP: {
                boolean isByteBuffer;
                List mapGenericClasses = PropertyAccessorHelper.getGenericClasses((Field)member);
                Class keyClass = CassandraValidationClassMapper.getValidationClassInstance((Class)((Class)mapGenericClasses.get(0)), (boolean)true);
                Class valueClass = CassandraValidationClassMapper.getValidationClassInstance((Class)((Class)mapGenericClasses.get(1)), (boolean)true);
                Class mapValueClazz = null;
                boolean isElementCollectionMap = false;
                if (((Class)mapGenericClasses.get(1)).isAssignableFrom(byte[].class)) {
                    mapValueClazz = ByteBuffer.class;
                } else if (((Class)mapGenericClasses.get(1)).isAnnotationPresent(Embeddable.class)) {
                    isElementCollectionMap = true;
                    mapValueClazz = UDTValue.class;
                } else {
                    mapValueClazz = (Class)mapGenericClasses.get(1);
                }
                retVal = row.getMap(columnName, ((Class)mapGenericClasses.get(0)).isAssignableFrom(byte[].class) ? ByteBuffer.class : (Class)mapGenericClasses.get(0), mapValueClazz);
                HashMap resultMap = new HashMap();
                if (isElementCollectionMap) {
                    for (Object keyValue : ((Map)retVal).keySet()) {
                        resultMap.put(keyValue, DSClientUtilities.setUDTValue(entity, (Class)mapGenericClasses.get(1), (UDTValue)((Map)retVal).get(keyValue), metamodel));
                    }
                }
                boolean bl = isByteBuffer = ((Class)mapGenericClasses.get(0)).isAssignableFrom(byte[].class) || ((Class)mapGenericClasses.get(1)).isAssignableFrom(byte[].class);
                if (retVal != null && !((Map)retVal).isEmpty() && !isElementCollectionMap) {
                    if (isByteBuffer) {
                        PropertyAccessorHelper.set((Object)entity, (Field)member, (Object)CassandraDataTranslator.marshalMap((List)mapGenericClasses, (Class)keyClass, (Class)valueClass, (Map)((Map)retVal)));
                        break;
                    }
                    for (Object keyValue : ((Map)retVal).keySet()) {
                        resultMap.put(keyValue, ((Map)retVal).get(keyValue));
                    }
                    PropertyAccessorHelper.set((Object)entity, (Field)member, resultMap);
                    break;
                }
                if (retVal == null || ((Map)retVal).isEmpty()) break;
                PropertyAccessorHelper.set((Object)entity, (Field)member, resultMap);
            }
        }
    }

    private static Object setIntValue(Field member, Object retVal) {
        if (member != null) {
            if (member.getType().isAssignableFrom(Byte.TYPE)) {
                retVal = ((Integer)retVal).byteValue();
            } else if (member.getType().isAssignableFrom(Short.TYPE)) {
                retVal = ((Integer)retVal).shortValue();
            }
        }
        return retVal;
    }

    private static Object setTextValue(Object entity, Field member, Object retVal) {
        if (member != null && member.getType().isEnum()) {
            EnumAccessor accessor = new EnumAccessor();
            if (member != null) {
                retVal = accessor.fromString(member.getType(), (String)retVal);
            }
        } else if (member != null && (member.getType().isAssignableFrom(Character.TYPE) || member.getType().isAssignableFrom(Character.class))) {
            retVal = new CharAccessor().fromString(member.getType(), (String)retVal);
        }
        return retVal;
    }

    private static void setFieldValue(Object entity, Field member, Object retVal) {
        if (member != null && retVal != null && entity != null) {
            PropertyAccessorHelper.set((Object)entity, (Field)member, (Object)retVal);
        }
    }
}

