/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.cache;

import com.impetus.kundera.cache.CacheException;
import com.impetus.kundera.utils.DeepEquals;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElementCollectionCacheManager {
    private static Logger log = LoggerFactory.getLogger(ElementCollectionCacheManager.class);
    private static ElementCollectionCacheManager instance;
    private static Map<Object, Map<Object, String>> elementCollectionCache;

    private ElementCollectionCacheManager() {
    }

    public static synchronized ElementCollectionCacheManager getInstance() {
        if (instance == null) {
            instance = new ElementCollectionCacheManager();
        }
        return instance;
    }

    public Map<Object, Map<Object, String>> getElementCollectionCache() {
        if (elementCollectionCache == null) {
            elementCollectionCache = new HashMap<Object, Map<Object, String>>();
        }
        return elementCollectionCache;
    }

    public boolean isCacheEmpty() {
        return elementCollectionCache == null || elementCollectionCache.isEmpty();
    }

    public void addElementCollectionCacheMapping(Object rowKey, Object elementCollectionObject, String elementCollObjectName) {
        HashMap<Object, String> embeddedObjectMap = new HashMap<Object, String>();
        if (this.getElementCollectionCache().get(rowKey) == null) {
            embeddedObjectMap.put(elementCollectionObject, elementCollObjectName);
            this.getElementCollectionCache().put(rowKey, embeddedObjectMap);
        } else {
            this.getElementCollectionCache().get(rowKey).put(elementCollectionObject, elementCollObjectName);
        }
    }

    public String getElementCollectionObjectName(Object rowKey, Object elementCollectionObject) {
        if (this.getElementCollectionCache().isEmpty() || this.getElementCollectionCache().get(rowKey) == null) {
            log.debug("No element collection object map found in cache for Row key " + rowKey);
            return null;
        }
        Map<Object, String> elementCollectionObjectMap = this.getElementCollectionCache().get(rowKey);
        String elementCollectionObjectName = elementCollectionObjectMap.get(elementCollectionObject);
        if (elementCollectionObjectName == null) {
            for (Object obj : elementCollectionObjectMap.keySet()) {
                if (!DeepEquals.deepEquals(elementCollectionObject, obj)) continue;
                elementCollectionObjectName = elementCollectionObjectMap.get(obj);
                break;
            }
        }
        if (elementCollectionObjectName == null) {
            log.debug("No element collection object name found in cache for object:" + elementCollectionObject);
            return null;
        }
        return elementCollectionObjectName;
    }

    public int getLastElementCollectionObjectCount(Object rowKey) {
        if (this.getElementCollectionCache().get(rowKey) == null) {
            log.debug("No element collection object map found in cache for Row key " + rowKey);
            return -1;
        }
        Map<Object, String> elementCollectionMap = this.getElementCollectionCache().get(rowKey);
        Collection<String> elementCollectionObjectNames = elementCollectionMap.values();
        int max = 0;
        for (String s : elementCollectionObjectNames) {
            String elementCollectionCountStr = s.substring(s.indexOf("#") + 1);
            int elementCollectionCount = 0;
            try {
                elementCollectionCount = Integer.parseInt(elementCollectionCountStr);
            }
            catch (NumberFormatException e) {
                log.error("Invalid element collection Object name " + s);
                throw new CacheException("Invalid element collection Object name " + s, e);
            }
            if (elementCollectionCount <= max) continue;
            max = elementCollectionCount;
        }
        return max;
    }

    public void clearCache() {
        elementCollectionCache = null;
        try {
            this.finalize();
        }
        catch (Throwable e) {
            log.warn("Unable to reclaim memory while clearing ElementCollection cache. Nothing to worry, will be taken care of by GC");
        }
    }
}

