/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.classreading;

import com.impetus.kundera.classreading.Filter;
import com.impetus.kundera.classreading.ResourceIterator;
import com.impetus.kundera.classreading.ResourceReadingException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class ClassFileIterator
implements ResourceIterator {
    private List<File> files = new ArrayList<File>();
    private int index = 0;

    public ClassFileIterator(File file, Filter filter) {
        ClassFileIterator.init(this.files, file, filter);
    }

    public ClassFileIterator(File fileToAdd) {
        this.files.add(fileToAdd);
    }

    private static void init(List<File> list, File dir, Filter filter) {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                ClassFileIterator.init(list, files[i], filter);
                continue;
            }
            if (filter != null && !filter.accepts(files[i].getAbsolutePath())) continue;
            list.add(files[i]);
        }
    }

    @Override
    public final InputStream next() {
        if (this.index >= this.files.size()) {
            return null;
        }
        File fp = this.files.get(this.index++);
        try {
            return new FileInputStream(fp);
        }
        catch (FileNotFoundException e) {
            throw new ResourceReadingException("Couldn't read file " + fp, e);
        }
    }

    @Override
    public void close() {
    }
}

