/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.classreading;

import com.impetus.kundera.classreading.Filter;
import com.impetus.kundera.classreading.FilterImpl;
import com.impetus.kundera.classreading.Reader;
import com.impetus.kundera.classreading.ResourceIterator;
import com.impetus.kundera.classreading.ResourceReadingException;
import com.impetus.kundera.loader.PersistenceXMLLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathReader
extends Reader {
    private static Logger logger = LoggerFactory.getLogger(ClasspathReader.class);
    private Filter filter = new FilterImpl();
    private List<String> classesToScan;

    public ClasspathReader() {
    }

    public ClasspathReader(List<String> classesToScan) {
        this();
        this.classesToScan = classesToScan;
    }

    @Override
    public final void read() {
        URL[] resources;
        for (URL resource : resources = this.findResources()) {
            try {
                ResourceIterator itr = this.getResourceIterator(resource, this.getFilter());
                InputStream is = null;
                while ((is = itr.next()) != null) {
                    this.scanClass(is);
                }
            }
            catch (IOException e) {
                logger.error("Error during reading via classpath, Caused by:" + e.getMessage());
                throw new ResourceReadingException(e);
            }
        }
    }

    @Override
    public final URL[] findResourcesByClasspath() {
        ArrayList<URL> list = new ArrayList<URL>();
        String classpath = System.getProperty("java.class.path");
        StringTokenizer tokenizer = new StringTokenizer(classpath, File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            String path = tokenizer.nextToken();
            File fp = new File(path);
            if (!fp.exists()) {
                throw new ResourceReadingException("File in java.class.path does not exist: " + fp);
            }
            try {
                list.add(fp.toURL());
            }
            catch (MalformedURLException e) {
                throw new ResourceReadingException(e);
            }
        }
        return list.toArray(new URL[list.size()]);
    }

    private URL[] findResourcesInUrls(String classRelativePath, URL[] urls) {
        ArrayList<URL> list = new ArrayList<URL>();
        for (URL url : urls) {
            File file;
            if (PersistenceXMLLoader.AllowedProtocol.isValidProtocol(url.getProtocol().toUpperCase()) && url.getPath().endsWith(".jar")) {
                try {
                    JarEntry present;
                    String classPath;
                    JarFile jarFile = new JarFile(URLDecoder.decode(url.getFile(), "UTF-8"));
                    Manifest manifest = jarFile.getManifest();
                    if (manifest != null && !StringUtils.isEmpty((String)(classPath = manifest.getMainAttributes().getValue("Class-Path")))) {
                        ArrayList<URL> subList = new ArrayList<URL>();
                        for (String cpEntry : classPath.split(" ")) {
                            try {
                                subList.add(new URL(cpEntry));
                            }
                            catch (MalformedURLException e) {
                                URL subResources = ClasspathReader.class.getClassLoader().getResource(cpEntry);
                                if (subResources == null) continue;
                                subList.add(subResources);
                            }
                        }
                        list.addAll(Arrays.asList(this.findResourcesInUrls(classRelativePath, subList.toArray(new URL[subList.size()]))));
                    }
                    if ((present = jarFile.getJarEntry(classRelativePath + ".class")) == null) continue;
                    list.add(url);
                }
                catch (IOException e) {
                    logger.warn("Error during loading from context , Caused by:" + e.getMessage());
                }
                continue;
            }
            if (!url.getPath().endsWith("/") || !(file = new File(url.getPath() + classRelativePath + ".class")).exists()) continue;
            try {
                list.add(file.toURL());
            }
            catch (MalformedURLException e) {
                throw new ResourceReadingException(e);
            }
        }
        return list.toArray(new URL[list.size()]);
    }

    private final URL[] findResourcesByContextLoader() {
        ArrayList<URL> list = new ArrayList<URL>();
        ClassLoader classLoader = this.getClass().getClassLoader();
        assert (classLoader != null);
        URL[] urls = ((URLClassLoader)classLoader).getURLs();
        for (String fullyQualifiedClassName : this.classesToScan) {
            String classRelativePath = fullyQualifiedClassName.replace(".", "/");
            list.addAll(Arrays.asList(this.findResourcesInUrls(classRelativePath, urls)));
        }
        return list.toArray(new URL[list.size()]);
    }

    @Override
    public URL[] findResources() {
        URL[] result = null;
        if (this.classesToScan != null && !this.classesToScan.isEmpty()) {
            result = this.findResourcesByContextLoader();
        }
        return result;
    }

    @Override
    public final Filter getFilter() {
        return this.filter;
    }

    public final void setFilter(Filter filter) {
        this.filter = filter;
    }

    @Override
    public InputStream[] findResourcesAsStream() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        assert (classLoader != null);
        InputStream[] iStreams = null;
        int counter = 0;
        if (this.classesToScan != null) {
            for (String fullyQualifiedClassName : this.classesToScan) {
                if (iStreams == null) {
                    iStreams = new InputStream[this.classesToScan.size()];
                }
                String classRelativePath = fullyQualifiedClassName.replace(".", "/");
                InputStream is = this.getClass().getClassLoader().getResourceAsStream(classRelativePath + ".class");
                iStreams[counter++] = is;
            }
        }
        return iStreams;
    }
}

