/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.classreading;

import com.impetus.kundera.classreading.Filter;
import com.impetus.kundera.classreading.ResourceIterator;
import com.impetus.kundera.classreading.ResourceReadingException;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public final class JarFileIterator
implements ResourceIterator {
    private JarInputStream jar;
    private JarEntry next;
    private Filter filter;
    private boolean initial = true;
    private boolean closed = false;

    public JarFileIterator(InputStream is, Filter filter) {
        this.filter = filter;
        try {
            this.jar = new JarInputStream(is);
        }
        catch (IOException e) {
            throw new ResourceReadingException(e);
        }
    }

    private void setNext() {
        this.initial = true;
        try {
            if (this.next != null) {
                this.jar.closeEntry();
            }
            this.next = null;
            do {
                this.next = this.jar.getNextJarEntry();
            } while (this.next != null && (this.next.isDirectory() || this.filter == null || !this.filter.accepts(this.next.getName())));
            if (this.next == null) {
                this.close();
            }
        }
        catch (IOException e) {
            throw new ResourceReadingException("Failed to browse jar:", e);
        }
    }

    @Override
    public InputStream next() {
        if (this.closed || this.next == null && !this.initial) {
            return null;
        }
        this.setNext();
        if (this.next == null) {
            return null;
        }
        return new InputStreamWrapper(this.jar);
    }

    @Override
    public void close() {
        try {
            this.closed = true;
            this.jar.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    class InputStreamWrapper
    extends InputStream {
        private InputStream delegate;

        public InputStreamWrapper(InputStream delegate) {
            this.delegate = delegate;
        }

        @Override
        public int read() throws IOException {
            return this.delegate.read();
        }

        @Override
        public int read(byte[] bytes) throws IOException {
            return this.delegate.read(bytes);
        }

        @Override
        public int read(byte[] bytes, int i, int i1) throws IOException {
            return this.delegate.read(bytes, i, i1);
        }

        @Override
        public long skip(long l) throws IOException {
            return this.delegate.skip(l);
        }

        @Override
        public int available() throws IOException {
            return this.delegate.available();
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void mark(int i) {
            this.delegate.mark(i);
        }

        @Override
        public void reset() throws IOException {
            this.delegate.reset();
        }

        @Override
        public boolean markSupported() {
            return this.delegate.markSupported();
        }
    }
}

