/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.configure;

import com.impetus.kundera.configure.ClientProperties;
import com.impetus.kundera.metadata.model.PersistenceUnitMetadata;
import com.impetus.kundera.utils.KunderaCoreUtils;
import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPropertyReader {
    private static final Logger log = LoggerFactory.getLogger(AbstractPropertyReader.class);
    private XStream xStream;
    protected PersistenceUnitMetadata puMetadata;
    protected Map externalProperties;

    public AbstractPropertyReader(Map externalProperties, PersistenceUnitMetadata puMetadata) {
        this.externalProperties = externalProperties;
        this.puMetadata = puMetadata;
    }

    public void read(String pu) {
        String propertyFileName;
        String string = propertyFileName = this.externalProperties != null ? (String)this.externalProperties.get("kundera.client.property") : null;
        if (propertyFileName == null) {
            String string2 = propertyFileName = this.puMetadata != null ? this.puMetadata.getProperty("kundera.client.property") : null;
        }
        if (propertyFileName != null && PropertyType.value(propertyFileName) != null && PropertyType.value(propertyFileName).equals((Object)PropertyType.xml)) {
            this.onXml(this.onParseXML(propertyFileName, this.puMetadata));
        }
    }

    private ClientProperties onParseXML(String propertyFileName, PersistenceUnitMetadata puMetadata) {
        InputStream inStream = puMetadata.getClassLoader().getResourceAsStream(propertyFileName);
        if (inStream == null) {
            propertyFileName = KunderaCoreUtils.resolvePath(propertyFileName);
            try {
                inStream = new FileInputStream(new File(propertyFileName));
            }
            catch (FileNotFoundException e) {
                log.warn("File {} not found, Caused by ", (Object)propertyFileName);
                return null;
            }
        }
        if (inStream != null) {
            this.xStream = this.getXStreamObject();
            Object o = this.xStream.fromXML(inStream);
            return (ClientProperties)o;
        }
        return null;
    }

    private XStream getXStreamObject() {
        if (this.xStream == null) {
            XStream stream = new XStream();
            stream.alias("clientProperties", ClientProperties.class);
            stream.alias("dataStore", ClientProperties.DataStore.class);
            stream.alias("schema", ClientProperties.DataStore.Schema.class);
            stream.alias("table", ClientProperties.DataStore.Schema.Table.class);
            stream.alias("dataCenter", ClientProperties.DataStore.Schema.DataCenter.class);
            stream.alias("connection", ClientProperties.DataStore.Connection.class);
            stream.alias("server", ClientProperties.DataStore.Connection.Server.class);
            return stream;
        }
        return this.xStream;
    }

    protected abstract void onXml(ClientProperties var1);

    protected class AbstractSchemaMetadata {
        private ClientProperties clientProperties;

        protected AbstractSchemaMetadata() {
        }

        public void setClientProperties(ClientProperties clientProperties) {
            this.clientProperties = clientProperties;
        }

        public ClientProperties getClientProperties() {
            return this.clientProperties;
        }

        protected ClientProperties.DataStore getDataStore(String dataStoreName) {
            if (this.getClientProperties() != null) {
                if (this.getClientProperties().getDatastores() != null) {
                    for (ClientProperties.DataStore dataStore : this.getClientProperties().getDatastores()) {
                        if (dataStore.getName() == null || !dataStore.getName().trim().equalsIgnoreCase(dataStoreName)) continue;
                        return dataStore;
                    }
                }
                if (log.isWarnEnabled()) {
                    log.warn("No data store configuration found, returning null.");
                }
            }
            return null;
        }
    }

    protected static enum PropertyType {
        xml,
        properties;

        private static final String DELIMETER = ".";

        public static PropertyType value(String propertyFileName) {
            PropertyType type = null;
            if (PropertyType.isValid(propertyFileName, xml)) {
                type = xml;
            } else if (PropertyType.isValid(propertyFileName, properties)) {
                if (log.isWarnEnabled()) {
                    log.warn("Support for .properties have been deprecated and no longer supported by Kundera");
                }
                type = properties;
            } else {
                log.warn("Invalid file format {} provided, returning null", (Object)propertyFileName);
            }
            return type;
        }

        private static boolean isValid(String propertyFileName, PropertyType type) {
            return propertyFileName.endsWith(DELIMETER + (Object)((Object)type));
        }
    }
}

