/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.configure;

import com.impetus.kundera.client.ClientResolver;
import com.impetus.kundera.configure.SchemaConfiguration;
import com.impetus.kundera.loader.ClientFactory;
import com.impetus.kundera.persistence.EntityManagerFactoryImpl;
import com.impetus.kundera.utils.KunderaCoreUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientMetadataBuilder {
    private static Logger log = LoggerFactory.getLogger(ClientMetadataBuilder.class);
    private String[] persistenceUnits;
    private Map mapExternalProperties;
    private SchemaConfiguration schemaConfiguration;

    public ClientMetadataBuilder(Map mapOfPuProperties, EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata, String ... persistenceUnits) {
        this.persistenceUnits = persistenceUnits;
        this.mapExternalProperties = mapOfPuProperties;
        this.schemaConfiguration = new SchemaConfiguration(mapOfPuProperties, kunderaMetadata, persistenceUnits);
    }

    public void buildClientFactoryMetadata(Map<String, ClientFactory> clientFactories, EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata) {
        Map<String, Object> puProperty;
        for (String pu : this.persistenceUnits) {
            log.info("Loading client factory for persistence unit " + pu);
            puProperty = KunderaCoreUtils.getExternalProperties(pu, this.mapExternalProperties, this.persistenceUnits);
            ClientFactory clientFactory = ClientResolver.getClientFactory(pu, puProperty, kunderaMetadata);
            clientFactories.put(pu, clientFactory);
        }
        this.schemaConfiguration.configure();
        for (String pu : this.persistenceUnits) {
            puProperty = KunderaCoreUtils.getExternalProperties(pu, this.mapExternalProperties, this.persistenceUnits);
            clientFactories.get(pu).load(pu, puProperty);
        }
    }
}

