/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.configure;

import com.impetus.kundera.KunderaPersistence;
import com.impetus.kundera.configure.AbstractSchemaConfiguration;
import com.impetus.kundera.configure.Configuration;
import com.impetus.kundera.configure.PersistenceUnitConfigurationException;
import com.impetus.kundera.loader.PersistenceLoaderException;
import com.impetus.kundera.loader.PersistenceXMLLoader;
import com.impetus.kundera.metadata.model.ApplicationMetadata;
import com.impetus.kundera.metadata.model.PersistenceUnitMetadata;
import com.impetus.kundera.persistence.EntityManagerFactoryImpl;
import com.impetus.kundera.utils.InvalidConfigurationException;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceUnitConfiguration
extends AbstractSchemaConfiguration
implements Configuration {
    private static Logger log = LoggerFactory.getLogger(PersistenceUnitConfiguration.class);
    private static final String PROVIDER_IMPLEMENTATION_NAME = KunderaPersistence.class.getName();

    public PersistenceUnitConfiguration(Map properties, EntityManagerFactoryImpl.KunderaMetadata metadata, String ... persistenceUnits) {
        super(persistenceUnits, properties, metadata);
    }

    @Override
    public void configure() {
        log.info("Loading Metadata from persistence.xml ...");
        ApplicationMetadata appMetadata = this.kunderaMetadata.getApplicationMetadata();
        try {
            Map<String, PersistenceUnitMetadata> metadatas = this.findPersistenceMetadatas();
            for (String persistenceUnit : this.persistenceUnits) {
                if (metadatas.containsKey(persistenceUnit)) continue;
                log.error("Unconfigured persistence unit: " + persistenceUnit + " please validate with persistence.xml");
                throw new PersistenceUnitConfigurationException("Invalid persistence unit: " + persistenceUnit + " provided");
            }
            log.info("Finishing persistence unit metadata configuration ...");
            appMetadata.addPersistenceUnitMetadata(metadatas);
        }
        catch (InvalidConfigurationException icex) {
            log.error("Error occurred during persistence unit configuration, Caused by: .", (Throwable)icex);
            throw new PersistenceLoaderException(icex);
        }
    }

    public void configure(PersistenceUnitInfo puInfo) {
        log.info("Loading Metadata from persistence.xml ...");
        ApplicationMetadata appMetadata = this.kunderaMetadata.getApplicationMetadata();
        HashMap metadatas = new HashMap();
        this.configure();
        for (String persistenceUnit : this.persistenceUnits) {
            this.mergeProperties(puInfo, appMetadata, persistenceUnit);
        }
    }

    private Map<String, PersistenceUnitMetadata> findPersistenceMetadatas() throws InvalidConfigurationException {
        String puLocation = this.externalPropertyMap != null && this.externalPropertyMap.get("persistenceunit.location") != null ? this.externalPropertyMap.get("persistenceunit.location") : "META-INF/persistence.xml";
        Enumeration<URL> xmls = null;
        try {
            xmls = this.getClass().getClassLoader().getResources(puLocation);
        }
        catch (IOException ioex) {
            log.warn("Error while loading persistence.xml, Caused by: {}.", (Throwable)ioex);
        }
        if (xmls == null || !xmls.hasMoreElements()) {
            log.error("Could not find any META-INF/persistence.xml file in the classpath");
            throw new InvalidConfigurationException("Could not find any META-INF/persistence.xml file in the classpath");
        }
        HashSet<String> persistenceUnitNames = new HashSet<String>();
        HashMap<String, PersistenceUnitMetadata> persistenceUnitMap = new HashMap<String, PersistenceUnitMetadata>();
        while (xmls.hasMoreElements()) {
            URL url = xmls.nextElement();
            log.trace("Analysing persistence.xml: " + url);
            List<PersistenceUnitMetadata> metadataFiles = PersistenceXMLLoader.findPersistenceUnits(url, this.persistenceUnits, PersistenceUnitTransactionType.RESOURCE_LOCAL);
            for (PersistenceUnitMetadata metadata : metadataFiles) {
                if (persistenceUnitNames.contains(metadata.getPersistenceUnitName()) && log.isWarnEnabled()) {
                    log.warn("Duplicate persistence-units for name: " + metadata.getPersistenceUnitName() + ". verify your persistence.xml file");
                }
                if (metadata.getPersistenceProviderClassName() == null || PROVIDER_IMPLEMENTATION_NAME.equalsIgnoreCase(metadata.getPersistenceProviderClassName())) {
                    persistenceUnitMap.put(metadata.getPersistenceUnitName(), metadata);
                }
                persistenceUnitNames.add(metadata.getPersistenceUnitName());
            }
        }
        return persistenceUnitMap;
    }

    private void mergeProperties(PersistenceUnitInfo puInfo, ApplicationMetadata appMetadata, String persistenceUnit) {
        PersistenceUnitMetadata metadata = appMetadata.getPersistenceUnitMetadata(persistenceUnit);
        metadata.setTransactionType(puInfo.getTransactionType());
        metadata.getClasses().addAll(puInfo.getManagedClassNames());
        metadata.setExcludeUnlistedClasses(puInfo.excludeUnlistedClasses());
        metadata.getProperties().putAll((Map<?, ?>)puInfo.getProperties());
        if (puInfo.getPersistenceProviderClassName() != null && !PROVIDER_IMPLEMENTATION_NAME.equalsIgnoreCase(puInfo.getPersistenceProviderClassName())) {
            throw new PersistenceUnitConfigurationException("Invalid persistence provider : " + puInfo.getPersistenceProviderClassName() + ", persistence provider must be " + PROVIDER_IMPLEMENTATION_NAME + ".");
        }
        metadata.setProvider(puInfo.getPersistenceProviderClassName());
        metadata.getPackages().addAll(puInfo.getMappingFileNames());
        for (URL url : puInfo.getJarFileUrls()) {
            metadata.addJarFile(url.getPath());
        }
    }
}

