/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.graph;

import com.impetus.kundera.KunderaException;
import com.impetus.kundera.client.Client;
import com.impetus.kundera.graph.NodeLink;
import com.impetus.kundera.lifecycle.NodeStateContext;
import com.impetus.kundera.lifecycle.states.NodeState;
import com.impetus.kundera.lifecycle.states.RemovedState;
import com.impetus.kundera.lifecycle.states.TransientState;
import com.impetus.kundera.metadata.KunderaMetadataManager;
import com.impetus.kundera.metadata.model.EntityMetadata;
import com.impetus.kundera.metadata.model.Relation;
import com.impetus.kundera.persistence.PersistenceDelegator;
import com.impetus.kundera.persistence.context.PersistenceCache;
import com.impetus.kundera.persistence.event.EntityEventDispatcher;
import com.impetus.kundera.utils.ObjectUtils;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class Node
implements NodeStateContext {
    private String nodeId;
    private Object entityId;
    private Object data;
    private NodeState currentNodeState;
    private Class<?> dataClass;
    private Map<NodeLink, Node> parents;
    private Map<NodeLink, Node> children;
    private boolean traversed;
    private boolean dirty;
    private boolean isUpdate;
    private Client client;
    private PersistenceCache persistenceCache;
    private boolean isGraphCompleted;
    private PersistenceDelegator pd;
    private Node originalNode;
    private boolean isProcessed;
    private EntityEventDispatcher eventDispatcher = new EntityEventDispatcher();

    private Node(String nodeId, Object data, PersistenceCache pc, Object primaryKey, PersistenceDelegator pd) {
        this.initializeNode(nodeId, data, primaryKey, pd);
        this.setPersistenceCache(pc);
        this.currentNodeState = new TransientState();
    }

    Node(String nodeId, Object data, NodeState initialNodeState, PersistenceCache pc, Object primaryKey, PersistenceDelegator pd) {
        this.initializeNode(nodeId, data, primaryKey, pd);
        this.setPersistenceCache(pc);
        this.currentNodeState = initialNodeState == null ? new TransientState() : initialNodeState;
    }

    public Node(String nodeId, Class<?> nodeDataClass, NodeState initialNodeState, PersistenceCache pc, Object primaryKey, PersistenceDelegator pd) {
        this.nodeId = nodeId;
        this.dataClass = nodeDataClass;
        this.entityId = primaryKey;
        this.pd = pd;
        this.setPersistenceCache(pc);
        this.currentNodeState = initialNodeState == null ? new TransientState() : initialNodeState;
    }

    private void initializeNode(String nodeId, Object data, Object primaryKey, PersistenceDelegator pd) {
        this.pd = pd;
        this.nodeId = nodeId;
        this.data = data;
        this.dataClass = data != null ? data.getClass() : null;
        this.dirty = true;
        this.entityId = primaryKey;
    }

    @Override
    public String getNodeId() {
        return this.nodeId;
    }

    @Override
    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    @Override
    public Object getData() {
        return this.data;
    }

    @Override
    public void setData(Object data) {
        this.data = data;
    }

    @Override
    public Class getDataClass() {
        return this.dataClass;
    }

    @Override
    public void setDataClass(Class dataClass) {
        this.dataClass = dataClass;
    }

    @Override
    public NodeState getCurrentNodeState() {
        return this.currentNodeState;
    }

    @Override
    public void setCurrentNodeState(NodeState currentNodeState) {
        this.currentNodeState = currentNodeState;
    }

    @Override
    public Map<NodeLink, Node> getParents() {
        return this.parents;
    }

    @Override
    public void setParents(Map<NodeLink, Node> parents) {
        this.parents = parents;
    }

    @Override
    public Map<NodeLink, Node> getChildren() {
        return this.children;
    }

    @Override
    public void setChildren(Map<NodeLink, Node> children) {
        this.children = children;
    }

    @Override
    public boolean isHeadNode() {
        return this != null && this.parents == null;
    }

    @Override
    public Node getParentNode(String parentNodeId) {
        NodeLink link = new NodeLink(parentNodeId, this.getNodeId());
        if (this.parents == null) {
            return null;
        }
        return this.parents.get(link);
    }

    @Override
    public Node getChildNode(String childNodeId) {
        NodeLink link = new NodeLink(this.getNodeId(), childNodeId);
        if (this.children == null) {
            return null;
        }
        return this.children.get(link);
    }

    @Override
    public void addParentNode(NodeLink nodeLink, Node node) {
        if (this.parents == null || this.parents.isEmpty()) {
            this.parents = new HashMap<NodeLink, Node>();
        }
        this.parents.put(nodeLink, node);
    }

    @Override
    public void addChildNode(NodeLink nodeLink, Node node) {
        if (this.children == null || this.children.isEmpty()) {
            this.children = new HashMap<NodeLink, Node>();
        }
        this.children.put(nodeLink, node);
    }

    @Override
    public boolean isTraversed() {
        return this.traversed;
    }

    @Override
    public void setTraversed(boolean traversed) {
        this.traversed = traversed;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    @Override
    public Client getClient() {
        return this.client;
    }

    @Override
    public void setClient(Client client) {
        this.client = client;
    }

    @Override
    public PersistenceDelegator getPersistenceDelegator() {
        return this.pd;
    }

    @Override
    public void setPersistenceDelegator(PersistenceDelegator pd) {
        this.pd = pd;
        this.setPersistenceCache(pd.getPersistenceCache());
    }

    public String toString() {
        return "[" + this.nodeId + "]" + this.nodeId;
    }

    public boolean equals(Object otherNode) {
        if (otherNode == null) {
            return false;
        }
        if (!(otherNode instanceof Node)) {
            return false;
        }
        return this.nodeId.equals(((Node)otherNode).getNodeId());
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this.nodeId);
    }

    @Override
    public void persist() {
        this.getCurrentNodeState().handlePersist(this);
    }

    @Override
    public void remove() {
        this.getCurrentNodeState().handleRemove(this);
    }

    @Override
    public void refresh() {
        this.getCurrentNodeState().handleRefresh(this);
        EntityMetadata metadata = KunderaMetadataManager.getEntityMetadata(this.pd.getKunderaMetadata(), this.getDataClass());
        this.onPostEvent(metadata, EntityEvent.FIND);
    }

    @Override
    public void merge() {
        this.getCurrentNodeState().handleMerge(this);
    }

    @Override
    public void detach() {
        this.getCurrentNodeState().handleDetach(this);
    }

    @Override
    public void close() {
        this.getCurrentNodeState().handleClose(this);
    }

    @Override
    public void lock() {
        this.getCurrentNodeState().handleLock(this);
    }

    @Override
    public void commit() {
        this.getCurrentNodeState().handleCommit(this);
    }

    @Override
    public void rollback() {
        this.getCurrentNodeState().handleRollback(this);
    }

    @Override
    public void find() {
        this.getCurrentNodeState().handleFind(this);
        EntityMetadata metadata = KunderaMetadataManager.getEntityMetadata(this.pd.getKunderaMetadata(), this.getDataClass());
        this.onPostEvent(metadata, EntityEvent.FIND);
    }

    @Override
    public void getReference() {
        this.getCurrentNodeState().handleGetReference(this);
    }

    @Override
    public void contains() {
        this.getCurrentNodeState().handleContains(this);
    }

    @Override
    public void clear() {
        this.getCurrentNodeState().handleClear(this);
    }

    @Override
    public void flush() {
        if (this.isDirty()) {
            this.handlePreEvent();
            this.getCurrentNodeState().handleFlush(this);
            this.handlePostEvent();
            this.isProcessed = true;
        }
        Map<NodeLink, Node> parents = this.getParents();
        Map<NodeLink, Node> children = this.getChildren();
        if (parents != null && !parents.isEmpty()) {
            for (NodeLink parentNodeLink : parents.keySet()) {
                if (parentNodeLink.getMultiplicity().equals((Object)Relation.ForeignKey.MANY_TO_MANY)) continue;
                parentNodeLink.addLinkProperty(NodeLink.LinkProperty.LINK_VALUE, this.getEntityId());
            }
        }
        if (children != null && !children.isEmpty()) {
            for (NodeLink childNodeLink : children.keySet()) {
                if (childNodeLink.getMultiplicity().equals((Object)Relation.ForeignKey.MANY_TO_MANY)) continue;
                childNodeLink.addLinkProperty(NodeLink.LinkProperty.LINK_VALUE, this.getEntityId());
            }
        }
    }

    @Override
    public boolean isInState(Class<?> stateClass) {
        return this.getCurrentNodeState().getClass().equals(stateClass);
    }

    @Override
    public PersistenceCache getPersistenceCache() {
        return this.persistenceCache;
    }

    @Override
    public void setPersistenceCache(PersistenceCache persistenceCache) {
        this.persistenceCache = persistenceCache;
    }

    boolean isGraphCompleted() {
        return this.isGraphCompleted;
    }

    void setGraphCompleted(boolean isGraphCompleted) {
        this.isGraphCompleted = isGraphCompleted;
    }

    public Node getOriginalNode() {
        return this.originalNode;
    }

    public void setOriginalNode(Node originalNode) {
        this.originalNode = originalNode;
    }

    public boolean isProcessed() {
        return this.isProcessed;
    }

    public boolean isUpdate() {
        return this.isUpdate;
    }

    public void setUpdate(boolean isUpdate) {
        this.isUpdate = isUpdate;
    }

    public Node clone() {
        Node cloneCopy = new Node(this.nodeId, ObjectUtils.deepCopy(this.getData(), this.pd.getKunderaMetadata()), this.persistenceCache, this.entityId, this.pd);
        cloneCopy.setChildren(this.children);
        cloneCopy.setParents(this.parents);
        cloneCopy.setDataClass(this.dataClass);
        cloneCopy.setTraversed(this.traversed);
        return cloneCopy;
    }

    @Override
    public Object getEntityId() {
        return this.entityId;
    }

    public void setEntityId(Object id) {
        this.entityId = id;
    }

    public void handlePreEvent() {
        EntityMetadata metadata = KunderaMetadataManager.getEntityMetadata(this.pd.getKunderaMetadata(), this.getDataClass());
        if (this.isUpdate) {
            this.onPreEvent(metadata, EntityEvent.UPDATE);
        } else if (this.isInState(RemovedState.class)) {
            this.onPreEvent(metadata, EntityEvent.REMOVE);
        } else {
            this.onPreEvent(metadata, EntityEvent.PERSIST);
        }
    }

    public void handlePostEvent() {
        EntityMetadata metadata = KunderaMetadataManager.getEntityMetadata(this.pd.getKunderaMetadata(), this.getDataClass());
        if (this.isUpdate) {
            this.onPostEvent(metadata, EntityEvent.UPDATE);
        } else if (this.isInState(RemovedState.class)) {
            this.onPostEvent(metadata, EntityEvent.REMOVE);
        } else {
            this.onPostEvent(metadata, EntityEvent.PERSIST);
        }
    }

    private void onPreEvent(EntityMetadata metadata, EntityEvent event) {
        try {
            this.eventDispatcher.fireEventListeners(metadata, this.data, EntityEvent.getPreEvent(event));
        }
        catch (Exception es) {
            throw new KunderaException(es);
        }
    }

    private void onPostEvent(EntityMetadata metadata, EntityEvent event) {
        try {
            this.eventDispatcher.fireEventListeners(metadata, this.data, EntityEvent.getPostEvent(event));
        }
        catch (Exception es) {
            throw new KunderaException(es);
        }
    }

    private static enum EntityEvent {
        UPDATE,
        PERSIST,
        REMOVE,
        FIND;


        private static final Class getPreEvent(EntityEvent event) {
            Class<PrePersist> clazz = null;
            switch (event) {
                case PERSIST: {
                    clazz = PrePersist.class;
                    break;
                }
                case UPDATE: {
                    clazz = PreUpdate.class;
                    break;
                }
                case REMOVE: {
                    clazz = PreRemove.class;
                    break;
                }
            }
            return clazz;
        }

        private static final Class getPostEvent(EntityEvent event) {
            Class<PostPersist> clazz = null;
            switch (event) {
                case PERSIST: {
                    clazz = PostPersist.class;
                    break;
                }
                case UPDATE: {
                    clazz = PostUpdate.class;
                    break;
                }
                case REMOVE: {
                    clazz = PostRemove.class;
                    break;
                }
                case FIND: {
                    clazz = PostLoad.class;
                    break;
                }
            }
            return clazz;
        }
    }
}

