/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.graph;

import com.impetus.kundera.utils.NumericUtils;
import java.lang.reflect.Field;
import javax.persistence.GeneratedValue;
import org.apache.commons.lang.StringUtils;

public class ObjectGraphUtils {
    public static String getNodeId(Object pk, Class<?> objectClass) {
        StringBuffer strBuffer = new StringBuffer(objectClass.getName());
        strBuffer.append("$");
        strBuffer.append(pk);
        return strBuffer.toString();
    }

    public static Object getEntityId(String nodeId) {
        return nodeId.substring(nodeId.indexOf("$") + 1, nodeId.length());
    }

    public static boolean onAutoGenerateId(Field idField, Object idValue) {
        if (idField.isAnnotationPresent(GeneratedValue.class)) {
            return !ObjectGraphUtils.isIdSet(idValue, idField);
        }
        return false;
    }

    private static boolean isIdSet(Object id, Field idField) {
        if (id != null) {
            return !NumericUtils.checkIfZero(id.toString(), idField.getType()) && (!StringUtils.isNumeric((String)id.toString()) || !StringUtils.isBlank((String)id.toString()));
        }
        return false;
    }
}

