/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.index;

import com.impetus.kundera.index.Indexer;
import com.impetus.kundera.index.IndexingException;
import com.impetus.kundera.index.LuceneQueryUtils;
import com.impetus.kundera.metadata.KunderaMetadataManager;
import com.impetus.kundera.metadata.MetadataUtils;
import com.impetus.kundera.metadata.model.EntityMetadata;
import com.impetus.kundera.metadata.model.MetamodelImpl;
import com.impetus.kundera.metadata.model.PropertyIndex;
import com.impetus.kundera.metadata.model.attributes.AbstractAttribute;
import com.impetus.kundera.persistence.EntityManagerFactoryImpl;
import com.impetus.kundera.persistence.PersistenceDelegator;
import com.impetus.kundera.property.PropertyAccessException;
import com.impetus.kundera.property.PropertyAccessorHelper;
import com.impetus.kundera.query.KunderaQuery;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EmbeddableType;
import javax.persistence.metamodel.EntityType;

public class IndexManager {
    private final Indexer indexer;
    private final EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata;

    public IndexManager(Indexer indexer, EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata) {
        this.indexer = indexer;
        this.kunderaMetadata = kunderaMetadata;
    }

    public Indexer getIndexer() {
        return this.indexer;
    }

    public final void remove(EntityMetadata metadata, Object entity, Object key) {
        if (this.indexer != null) {
            if (this.indexer.getClass().getName().equals("com.impetus.kundera.index.LuceneIndexer")) {
                ((com.impetus.kundera.index.lucene.Indexer)this.indexer).unindex(metadata, key, this.kunderaMetadata, null);
            } else {
                this.indexer.unIndex(metadata.getEntityClazz(), entity, metadata, (MetamodelImpl)this.kunderaMetadata.getApplicationMetadata().getMetamodel(metadata.getPersistenceUnit()));
            }
        }
    }

    public final void update(EntityMetadata metadata, Object entity, Object parentId, Class<?> clazz) {
        try {
            if (this.indexer != null) {
                if (this.indexer.getClass().getName().equals("com.impetus.kundera.index.LuceneIndexer")) {
                    boolean isEmbeddedId;
                    MetamodelImpl metamodel = (MetamodelImpl)this.kunderaMetadata.getApplicationMetadata().getMetamodel(metadata.getPersistenceUnit());
                    Object id = PropertyAccessorHelper.getId(entity, metadata);
                    boolean documentExistsInIndex = ((com.impetus.kundera.index.lucene.Indexer)this.indexer).documentExistsInIndex(metadata, id, this.kunderaMetadata, isEmbeddedId = metamodel.isEmbeddable(metadata.getIdAttribute().getBindableJavaType()), clazz);
                    if (documentExistsInIndex) {
                        ((com.impetus.kundera.index.lucene.Indexer)this.indexer).update(metadata, metamodel, entity, id, parentId != null ? parentId.toString() : null);
                    } else {
                        boolean documentExists = ((com.impetus.kundera.index.lucene.Indexer)this.indexer).entityExistsInIndex(entity.getClass(), this.kunderaMetadata, metadata);
                        if (documentExists) {
                            ((com.impetus.kundera.index.lucene.Indexer)this.indexer).unindex(metadata, id, this.kunderaMetadata, clazz);
                            ((com.impetus.kundera.index.lucene.Indexer)this.indexer).flush();
                        }
                        ((com.impetus.kundera.index.lucene.Indexer)this.indexer).index(metadata, metamodel, entity, parentId != null ? parentId.toString() : null, clazz);
                    }
                } else {
                    MetamodelImpl metaModel = (MetamodelImpl)this.kunderaMetadata.getApplicationMetadata().getMetamodel(metadata.getPersistenceUnit());
                    Map<String, PropertyIndex> indexProperties = metadata.getIndexProperties();
                    HashMap<String, Object> indexCollection = new HashMap<String, Object>();
                    Object id = PropertyAccessorHelper.getId(entity, metadata);
                    for (String columnName : indexProperties.keySet()) {
                        PropertyIndex index = indexProperties.get(columnName);
                        Field property = index.getProperty();
                        Object obj = PropertyAccessorHelper.getObject(entity, property);
                        indexCollection.put(columnName, obj);
                    }
                    indexCollection.put(((AbstractAttribute)metadata.getIdAttribute()).getJPAColumnName(), id);
                    EntityMetadata parentMetadata = KunderaMetadataManager.getEntityMetadata(this.kunderaMetadata, clazz);
                    if (parentId != null) {
                        indexCollection.put(((AbstractAttribute)parentMetadata.getIdAttribute()).getJPAColumnName(), parentId);
                    }
                    this.onEmbeddable(entity, metadata.getEntityClazz(), metaModel, indexCollection);
                    this.indexer.index(metadata.getEntityClazz(), metadata, indexCollection, parentId, clazz);
                }
            }
        }
        catch (PropertyAccessException e) {
            throw new IndexingException("Can't access ID from entity class " + metadata.getEntityClazz(), e);
        }
    }

    private void onEmbeddable(Object entity, Class<?> clazz, MetamodelImpl metaModel, Map<String, Object> indexCollection) {
        Map<String, EmbeddableType> embeddables = metaModel.getEmbeddables(clazz);
        EntityType<?> entityType = metaModel.entity(clazz);
        for (String embeddedFieldName : embeddables.keySet()) {
            Object embeddedObject;
            EmbeddableType embeddedColumn = embeddables.get(embeddedFieldName);
            Field embeddedField = (Field)entityType.getAttribute(embeddedFieldName).getJavaMember();
            if (!MetadataUtils.isEmbeddedAtributeIndexable(embeddedField) || (embeddedObject = PropertyAccessorHelper.getObject(entity, (Field)entityType.getAttribute(embeddedFieldName).getJavaMember())) == null || embeddedObject instanceof Collection) continue;
            for (Object column : embeddedColumn.getAttributes()) {
                Attribute columnAttribute = (Attribute)column;
                String columnName = columnAttribute.getName();
                Class columnClass = ((AbstractAttribute)columnAttribute).getBindableJavaType();
                if (!MetadataUtils.isColumnInEmbeddableIndexable(embeddedField, columnName)) continue;
                indexCollection.put(embeddedField.getName() + "." + columnName, PropertyAccessorHelper.getObject(embeddedObject, (Field)columnAttribute.getJavaMember()));
            }
        }
    }

    public final void write(EntityMetadata metadata, Object entity) {
        if (this.indexer != null) {
            MetamodelImpl metamodel = (MetamodelImpl)this.kunderaMetadata.getApplicationMetadata().getMetamodel(metadata.getPersistenceUnit());
            ((com.impetus.kundera.index.lucene.Indexer)this.indexer).index(metadata, metamodel, entity);
        }
    }

    public final void write(EntityMetadata metadata, Object entity, String parentId, Class<?> clazz) {
        if (this.indexer != null) {
            MetamodelImpl metamodel = (MetamodelImpl)this.kunderaMetadata.getApplicationMetadata().getMetamodel(metadata.getPersistenceUnit());
            ((com.impetus.kundera.index.lucene.Indexer)this.indexer).index(metadata, metamodel, entity, parentId, clazz);
        }
    }

    @Deprecated
    public final Map<String, Object> search(Class<?> clazz, String query) {
        return this.search(clazz, query, -1, -1, false);
    }

    public final Map<String, Object> search(Class<?> parentClass, Class<?> childClass, Object entityId) {
        if (this.indexer == null) {
            return null;
        }
        if (this.indexer != null && this.indexer.getClass().getName().equals("com.impetus.kundera.index.LuceneIndexer")) {
            String query = LuceneQueryUtils.getQuery("6077004083174677888.parent.class", parentClass.getCanonicalName().toLowerCase(), "6077004083174677888.parent.id", entityId, childClass.getCanonicalName().toLowerCase());
            return ((com.impetus.kundera.index.lucene.Indexer)this.indexer).search(query, -1, -1, false, this.kunderaMetadata, KunderaMetadataManager.getEntityMetadata(this.kunderaMetadata, parentClass));
        }
        String query = LuceneQueryUtils.getQuery("6077004083174677888.parent.class", parentClass.getCanonicalName().toLowerCase(), "6077004083174677888.parent.id", entityId, childClass.getCanonicalName().toLowerCase());
        return this.indexer.search(query, parentClass, KunderaMetadataManager.getEntityMetadata(this.kunderaMetadata, parentClass), childClass, KunderaMetadataManager.getEntityMetadata(this.kunderaMetadata, childClass), entityId, -1, -1);
    }

    public final Map<String, Object> fetchRelation(Class<?> clazz, String query) {
        return this.search(clazz, query, -1, -1, true);
    }

    public final Map<String, Object> search(Class<?> clazz, String query, int count) {
        return this.search(clazz, query, -1, count, false);
    }

    public final Map<String, Object> search(Class<?> clazz, String query, int start, int count) {
        if (this.indexer != null) {
            if (this.indexer != null && this.indexer.getClass().getName().equals("com.impetus.kundera.index.LuceneIndexer")) {
                return this.indexer != null ? ((com.impetus.kundera.index.lucene.Indexer)this.indexer).search(query, start, count, false, this.kunderaMetadata, KunderaMetadataManager.getEntityMetadata(this.kunderaMetadata, clazz)) : null;
            }
            return this.indexer.search(clazz, KunderaMetadataManager.getEntityMetadata(this.kunderaMetadata, clazz), query, start, count);
        }
        return new HashMap<String, Object>();
    }

    public final Map<String, Object> search(EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata, KunderaQuery kunderaQuery, PersistenceDelegator persistenceDelegator, EntityMetadata m, int maxResults) {
        return this.indexer.search(kunderaMetadata, kunderaQuery, persistenceDelegator, m, maxResults);
    }

    public final Map<String, Object> search(Class<?> clazz, String query, int start, int count, boolean fetchRelation) {
        if (this.indexer != null) {
            if (this.indexer.getClass().getName().equals("com.impetus.kundera.index.LuceneIndexer")) {
                return this.indexer != null ? ((com.impetus.kundera.index.lucene.Indexer)this.indexer).search(query, start, count, fetchRelation, this.kunderaMetadata, KunderaMetadataManager.getEntityMetadata(this.kunderaMetadata, clazz)) : null;
            }
            return this.indexer.search(clazz, KunderaMetadataManager.getEntityMetadata(this.kunderaMetadata, clazz), query, start, count);
        }
        return new HashMap<String, Object>();
    }

    public void flush() throws IndexingException {
        if (this.indexer != null) {
            // empty if block
        }
    }

    public void close() throws IndexingException {
        if (this.indexer != null) {
            this.indexer.close();
        }
    }
}

