/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.lifecycle.states;

import com.impetus.kundera.client.Client;
import com.impetus.kundera.graph.Node;
import com.impetus.kundera.lifecycle.NodeStateContext;
import com.impetus.kundera.lifecycle.states.DetachedState;
import com.impetus.kundera.lifecycle.states.ManagedState;
import com.impetus.kundera.lifecycle.states.NodeState;
import com.impetus.kundera.lifecycle.states.TransientState;
import javax.persistence.PersistenceContextType;

public class RemovedState
extends NodeState {
    @Override
    public void initialize(NodeStateContext nodeStateContext) {
    }

    @Override
    public void handlePersist(NodeStateContext nodeStateContext) {
        this.moveNodeToNextState(nodeStateContext, new ManagedState());
    }

    @Override
    public void handleRemove(NodeStateContext nodeStateContext) {
    }

    @Override
    public void handleRefresh(NodeStateContext nodeStateContext) {
        throw new IllegalArgumentException("Refresh operation not allowed in Removed state");
    }

    @Override
    public void handleMerge(NodeStateContext nodeStateContext) {
        throw new IllegalArgumentException("Merge operation not allowed in Removed state");
    }

    @Override
    public void handleFind(NodeStateContext nodeStateContext) {
    }

    @Override
    public void handleClose(NodeStateContext nodeStateContext) {
    }

    @Override
    public void handleClear(NodeStateContext nodeStateContext) {
    }

    @Override
    public void handleFlush(NodeStateContext nodeStateContext) {
        Client client = nodeStateContext.getClient();
        Node node = (Node)nodeStateContext;
        Object entityId = node.getEntityId();
        client.remove(node.getData(), entityId);
        nodeStateContext.setDirty(false);
        nodeStateContext.getPersistenceCache().getMainCache().removeNodeFromCache(node);
    }

    @Override
    public void handleLock(NodeStateContext nodeStateContext) {
    }

    @Override
    public void handleDetach(NodeStateContext nodeStateContext) {
        this.moveNodeToNextState(nodeStateContext, new DetachedState());
        this.recursivelyPerformOperation(nodeStateContext, NodeState.OPERATION.DETACH);
    }

    @Override
    public void handleCommit(NodeStateContext nodeStateContext) {
        nodeStateContext.setCurrentNodeState(new TransientState());
    }

    @Override
    public void handleRollback(NodeStateContext nodeStateContext) {
        if (PersistenceContextType.EXTENDED.equals((Object)nodeStateContext.getPersistenceCache().getPersistenceContextType())) {
            this.moveNodeToNextState(nodeStateContext, new ManagedState());
        } else if (PersistenceContextType.TRANSACTION.equals((Object)nodeStateContext.getPersistenceCache().getPersistenceContextType())) {
            nodeStateContext.detach();
        }
    }

    @Override
    public void handleGetReference(NodeStateContext nodeStateContext) {
    }

    @Override
    public void handleContains(NodeStateContext nodeStateContext) {
    }
}

