/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.loader;

import com.impetus.kundera.KunderaException;
import com.impetus.kundera.client.Client;
import com.impetus.kundera.configure.PropertyReader;
import com.impetus.kundera.configure.schema.api.SchemaManager;
import com.impetus.kundera.index.IndexManager;
import com.impetus.kundera.index.Indexer;
import com.impetus.kundera.loader.ClientFactory;
import com.impetus.kundera.loader.ClientLifeCycleManager;
import com.impetus.kundera.metadata.model.ClientMetadata;
import com.impetus.kundera.persistence.EntityManagerFactoryImpl;
import com.impetus.kundera.persistence.EntityReader;
import com.impetus.kundera.service.Host;
import com.impetus.kundera.service.policy.LoadBalancingPolicy;
import com.impetus.kundera.service.policy.RetryService;
import com.impetus.kundera.service.policy.RoundRobinBalancingPolicy;
import com.impetus.kundera.utils.InvalidConfigurationException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GenericClientFactory
implements ClientFactory,
ClientLifeCycleManager {
    private static Logger logger = LoggerFactory.getLogger(GenericClientFactory.class);
    private Client client;
    private String persistenceUnit;
    private Object connectionPoolOrConnection;
    protected EntityReader reader;
    protected SchemaManager schemaManager;
    protected PropertyReader propertyReader;
    protected Map<String, Object> externalProperties = new HashMap<String, Object>();
    protected LoadBalancingPolicy loadBalancingPolicy = new RoundRobinBalancingPolicy();
    protected RetryService hostRetryService;
    protected ConcurrentMap<Host, Object> hostPools = new ConcurrentHashMap<Host, Object>();
    protected ClientMetadata clientMetadata;
    protected EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata;
    protected IndexManager indexManager = new IndexManager(null, this.kunderaMetadata);

    @Override
    public void load(String persistenceUnit, Map<String, Object> puProperties) {
        this.setPersistenceUnit(persistenceUnit);
        logger.info("Loading client metadata for persistence unit : " + persistenceUnit);
        this.loadClientMetadata(puProperties);
        logger.info("Initializing client for persistence unit : " + persistenceUnit);
        this.initialize(puProperties);
        logger.info("Constructing pool for persistence unit : " + persistenceUnit);
        this.connectionPoolOrConnection = this.createPoolOrConnection();
    }

    protected void loadClientMetadata(Map<String, Object> puProperties) {
        String indexerClass;
        this.clientMetadata = new ClientMetadata();
        String luceneDirectoryPath = puProperties != null ? (String)puProperties.get("index.home.dir") : null;
        String string = indexerClass = puProperties != null ? (String)puProperties.get("kundera.indexer.class") : null;
        if (indexerClass == null) {
            indexerClass = this.kunderaMetadata.getApplicationMetadata().getPersistenceUnitMetadata(this.persistenceUnit).getProperties().getProperty("kundera.indexer.class");
        }
        if (luceneDirectoryPath == null) {
            luceneDirectoryPath = this.kunderaMetadata.getApplicationMetadata().getPersistenceUnitMetadata(this.persistenceUnit).getProperty("index.home.dir");
        }
        if (luceneDirectoryPath != null && !StringUtils.isEmpty((String)luceneDirectoryPath)) {
            this.clientMetadata.setLuceneIndexDir(luceneDirectoryPath);
            try {
                Method method = Class.forName("com.impetus.kundera.index.LuceneIndexer").getDeclaredMethod("getInstance", String.class);
                Indexer indexer = (Indexer)method.invoke(null, luceneDirectoryPath);
                this.indexManager = new IndexManager(indexer, this.kunderaMetadata);
            }
            catch (Exception e) {
                logger.error("Missing lucene from classpath. Please make sure those are available to load lucene directory {}!", (Object)luceneDirectoryPath);
                throw new InvalidConfigurationException(e);
            }
        } else if (indexerClass != null) {
            try {
                Class<?> indexerClazz = Class.forName(indexerClass);
                Indexer indexer = (Indexer)indexerClazz.newInstance();
                this.indexManager = new IndexManager(indexer, this.kunderaMetadata);
                this.clientMetadata.setIndexImplementor(indexerClass);
            }
            catch (Exception cnfex) {
                logger.error("Error while initialzing indexer:" + indexerClass, (Throwable)cnfex);
                throw new KunderaException(cnfex);
            }
        } else {
            this.indexManager = new IndexManager(null, this.kunderaMetadata);
        }
    }

    @Override
    public abstract void initialize(Map<String, Object> var1);

    protected abstract Object createPoolOrConnection();

    @Override
    public Client getClientInstance() {
        if (this.isThreadSafe()) {
            logger.info("Returning threadsafe used client instance for persistence unit : " + this.persistenceUnit);
            if (this.client == null) {
                this.client = this.instantiateClient(this.persistenceUnit);
            }
        } else {
            logger.debug("Returning fresh client instance for persistence unit : " + this.persistenceUnit);
            return this.instantiateClient(this.persistenceUnit);
        }
        return this.client;
    }

    protected abstract Client instantiateClient(String var1);

    @Override
    public abstract boolean isThreadSafe();

    protected String getPersistenceUnit() {
        return this.persistenceUnit;
    }

    protected Object getConnectionPoolOrConnection() {
        return this.connectionPoolOrConnection;
    }

    protected void setConnectionPoolOrConnection(Object connectionPoolOrConnection) {
        this.connectionPoolOrConnection = connectionPoolOrConnection;
    }

    private void setPersistenceUnit(String persistenceUnit) {
        this.persistenceUnit = persistenceUnit;
    }

    protected void setKunderaMetadata(EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata) {
        this.kunderaMetadata = kunderaMetadata;
    }

    protected void setExternalProperties(Map<String, Object> puProperties) {
        if (puProperties != null) {
            this.externalProperties = puProperties;
        }
    }

    protected void onValidation(String host, String port) {
        if (host == null || !StringUtils.isNumeric((String)port) || port.isEmpty()) {
            logger.error("Host or port should not be null / port should be numeric");
            throw new IllegalArgumentException("Host or port should not be null / port should be numeric");
        }
    }

    protected void unload() {
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
        this.externalProperties = null;
        this.hostPools.clear();
    }

    protected abstract void initializeLoadBalancer(String var1);

    public ClientMetadata getClientMetadata() {
        return this.clientMetadata;
    }

    protected static enum LoadBalancer {
        ROUNDROBIN,
        LEASTACTIVE;


        public static LoadBalancer getValue(String loadBalancename) {
            if (loadBalancename != null && loadBalancename.equalsIgnoreCase(ROUNDROBIN.name())) {
                return ROUNDROBIN;
            }
            if (loadBalancename != null && loadBalancename.equalsIgnoreCase(LEASTACTIVE.name())) {
                return LEASTACTIVE;
            }
            logger.info("Using default load balancer {} . " + ROUNDROBIN.name());
            return ROUNDROBIN;
        }
    }
}

