/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.metadata;

import com.impetus.kundera.metadata.MetadataProcessor;
import com.impetus.kundera.metadata.MetadataUtils;
import com.impetus.kundera.metadata.model.ApplicationMetadata;
import com.impetus.kundera.metadata.model.EntityMetadata;
import com.impetus.kundera.metadata.model.PersistenceUnitMetadata;
import com.impetus.kundera.metadata.processor.CacheableAnnotationProcessor;
import com.impetus.kundera.metadata.processor.EntityListenersProcessor;
import com.impetus.kundera.metadata.processor.IndexProcessor;
import com.impetus.kundera.metadata.processor.TableProcessor;
import com.impetus.kundera.metadata.validator.EntityValidator;
import com.impetus.kundera.metadata.validator.EntityValidatorImpl;
import com.impetus.kundera.metadata.validator.InvalidEntityDefinitionException;
import com.impetus.kundera.persistence.EntityManagerFactoryImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.NamedNativeQueries;
import javax.persistence.NamedNativeQuery;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.PersistenceException;
import javax.persistence.Table;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataBuilder {
    private static Logger log = LoggerFactory.getLogger(MetadataBuilder.class);
    private List<MetadataProcessor> metadataProcessors;
    private EntityValidator validator;
    private String persistenceUnit;
    private String client;
    private Map puProperties;
    private EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata;

    public MetadataBuilder(String puName, String client, Map puProperties, EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata) {
        this.persistenceUnit = puName;
        this.client = client;
        this.puProperties = puProperties;
        this.validator = new EntityValidatorImpl(puProperties);
        this.metadataProcessors = new ArrayList<MetadataProcessor>();
        this.kunderaMetadata = kunderaMetadata;
        this.metadataProcessors.add(new TableProcessor(puProperties, kunderaMetadata));
        this.metadataProcessors.add(new CacheableAnnotationProcessor());
        this.metadataProcessors.add(new IndexProcessor(kunderaMetadata));
        this.metadataProcessors.add(new EntityListenersProcessor());
    }

    public final void validate(Class<?> clazz) throws PersistenceException {
        this.validator.validate(clazz);
    }

    public EntityMetadata buildEntityMetadata(Class<?> clazz) {
        EntityMetadata metadata = new EntityMetadata(clazz);
        if (log.isDebugEnabled()) {
            log.debug("Processing @Entity >> " + clazz);
        }
        for (MetadataProcessor processor : this.metadataProcessors) {
            this.setSchemaAndPU(clazz, metadata);
            processor.process(clazz, metadata);
            metadata = this.belongsToPersistenceUnit(metadata);
            if (metadata == null) break;
            if (!MetadataUtils.isSchemaAttributeRequired(metadata.getPersistenceUnit(), this.kunderaMetadata) || !StringUtils.isBlank((String)metadata.getSchema())) continue;
            if (log.isErrorEnabled()) {
                log.error("It is mandatory to specify Schema alongwith Table name:" + metadata.getTableName() + ". This entity won't be persisted");
            }
            throw new InvalidEntityDefinitionException("It is mandatory to specify Schema alongwith Table name:" + metadata.getTableName() + ". This entity won't be persisted");
        }
        return metadata;
    }

    private EntityMetadata belongsToPersistenceUnit(EntityMetadata metadata) {
        PersistenceUnitMetadata puMetadata = this.kunderaMetadata.getApplicationMetadata().getPersistenceUnitMetadata(this.persistenceUnit);
        String keyspace = this.puProperties != null ? (String)this.puProperties.get("kundera.keyspace") : null;
        String string = keyspace = keyspace == null ? puMetadata.getProperty("kundera.keyspace") : keyspace;
        if (metadata.getPersistenceUnit() != null && !metadata.getPersistenceUnit().equals(this.persistenceUnit) || keyspace != null && metadata.getSchema() != null && !metadata.getSchema().equals(keyspace)) {
            metadata = null;
        } else {
            this.applyMetadataChanges(metadata);
        }
        return metadata;
    }

    private void applyMetadataChanges(EntityMetadata metadata) {
        metadata.setPersistenceUnit(this.persistenceUnit);
        PersistenceUnitMetadata puMetadata = this.kunderaMetadata.getApplicationMetadata().getPersistenceUnitMetadata(this.persistenceUnit);
        String keyspace = this.puProperties != null ? (String)this.puProperties.get("kundera.keyspace") : null;
        String string = keyspace = keyspace == null ? puMetadata.getProperty("kundera.keyspace") : keyspace;
        if (metadata.getSchema() == null) {
            metadata.setSchema(keyspace);
        }
        if (metadata.getTableName() == null) {
            metadata.setTableName(metadata.getEntityClazz().getSimpleName());
        }
    }

    private void setSchemaAndPU(Class<?> clazz, EntityMetadata metadata) {
        Table table = clazz.getAnnotation(Table.class);
        if (table != null) {
            metadata.setTableName(!StringUtils.isBlank((String)table.name()) ? table.name() : clazz.getSimpleName());
            this.addNamedNativeQueryMetadata(clazz);
            String schemaStr = table.schema();
            MetadataUtils.setSchemaAndPersistenceUnit(metadata, schemaStr, this.puProperties);
        }
        if (metadata.getPersistenceUnit() == null) {
            metadata.setPersistenceUnit(this.persistenceUnit);
        }
    }

    private void addNamedNativeQueryMetadata(Class clazz) {
        NamedQuery[] anns;
        NamedQuery ann;
        ApplicationMetadata appMetadata = this.kunderaMetadata.getApplicationMetadata();
        Object query = null;
        if (clazz.isAnnotationPresent(NamedQuery.class)) {
            ann = clazz.getAnnotation(NamedQuery.class);
            appMetadata.addQueryToCollection(ann.name(), ann.query(), false, clazz);
        }
        if (clazz.isAnnotationPresent(NamedQueries.class)) {
            ann = clazz.getAnnotation(NamedQueries.class);
            for (NamedQuery a : anns = ann.value()) {
                appMetadata.addQueryToCollection(a.name(), a.query(), false, clazz);
            }
        }
        if (clazz.isAnnotationPresent(NamedNativeQuery.class)) {
            ann = clazz.getAnnotation(NamedNativeQuery.class);
            appMetadata.addQueryToCollection(ann.name(), ann.query(), true, clazz);
        }
        if (clazz.isAnnotationPresent(NamedNativeQueries.class)) {
            ann = clazz.getAnnotation(NamedNativeQueries.class);
            for (NamedQuery a : anns = ann.value()) {
                appMetadata.addQueryToCollection(a.name(), a.query(), true, clazz);
            }
        }
    }
}

