/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.metadata;

import com.impetus.kundera.index.Index;
import com.impetus.kundera.index.IndexCollection;
import com.impetus.kundera.metadata.KunderaMetadataManager;
import com.impetus.kundera.metadata.model.ClientMetadata;
import com.impetus.kundera.metadata.model.EntityMetadata;
import com.impetus.kundera.metadata.model.MetamodelImpl;
import com.impetus.kundera.metadata.model.PersistenceUnitMetadata;
import com.impetus.kundera.metadata.model.Relation;
import com.impetus.kundera.metadata.model.attributes.AbstractAttribute;
import com.impetus.kundera.metadata.validator.InvalidEntityDefinitionException;
import com.impetus.kundera.persistence.EntityManagerFactoryImpl;
import com.impetus.kundera.property.PropertyAccessorHelper;
import java.lang.reflect.Field;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.persistence.Embeddable;
import javax.persistence.Embedded;
import javax.persistence.PersistenceException;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EmbeddableType;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;
import javax.validation.constraints.AssertFalse;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Future;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import javax.validation.constraints.Past;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.apache.commons.lang.StringUtils;

public class MetadataUtils {
    public static void populateColumnAndSuperColumnMaps(EntityMetadata m, Map<String, Field> columnNameToFieldMap, Map<String, Field> superColumnNameToFieldMap, EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata) {
        MetadataUtils.getEmbeddableType(m, columnNameToFieldMap, superColumnNameToFieldMap, kunderaMetadata);
    }

    public static Map<String, Field> createColumnsFieldMap(EntityMetadata m, EmbeddableType superColumn) {
        HashMap<String, Field> columnNameToFieldMap = new HashMap<String, Field>();
        Set attributes = superColumn.getAttributes();
        for (Attribute column : attributes) {
            columnNameToFieldMap.put(((AbstractAttribute)column).getJPAColumnName(), (Field)column.getJavaMember());
        }
        return columnNameToFieldMap;
    }

    public static Map<String, Field> createSuperColumnsFieldMap(EntityMetadata m, EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata) {
        HashMap<String, Field> superColumnNameToFieldMap = new HashMap<String, Field>();
        MetadataUtils.getEmbeddableType(m, null, superColumnNameToFieldMap, kunderaMetadata);
        return superColumnNameToFieldMap;
    }

    public static Collection getEmbeddedCollectionInstance(Field embeddedCollectionField) {
        AbstractCollection embeddedCollection = null;
        Class<?> embeddedCollectionFieldClass = embeddedCollectionField.getType();
        if (embeddedCollection == null || embeddedCollection.isEmpty()) {
            if (embeddedCollectionFieldClass.equals(List.class)) {
                embeddedCollection = new ArrayList();
            } else if (embeddedCollectionFieldClass.equals(Set.class)) {
                embeddedCollection = new HashSet();
            } else {
                throw new InvalidEntityDefinitionException("Field " + embeddedCollectionField.getName() + " must be either instance of List or Set");
            }
        }
        return embeddedCollection;
    }

    public static Object getEmbeddedGenericObjectInstance(Field embeddedCollectionField) {
        Class<?> embeddedClass = PropertyAccessorHelper.getGenericClass(embeddedCollectionField);
        Object embeddedObject = null;
        try {
            embeddedClass.getConstructor(new Class[0]);
            embeddedObject = embeddedClass.newInstance();
        }
        catch (NoSuchMethodException nsme) {
            throw new PersistenceException(embeddedClass.getName() + " is @Embeddable and must have a default no-argument constructor.");
        }
        catch (InstantiationException e) {
            throw new PersistenceException(embeddedClass.getName() + " could not be instantiated");
        }
        catch (IllegalAccessException e) {
            throw new PersistenceException(embeddedClass.getName() + " could not be accessed");
        }
        return embeddedObject;
    }

    public static String getEmbeddedCollectionPrefix(String embeddedCollectionName) {
        return embeddedCollectionName.substring(0, embeddedCollectionName.indexOf("#"));
    }

    public static String getEmbeddedCollectionPostfix(String embeddedCollectionName) {
        return embeddedCollectionName.substring(embeddedCollectionName.lastIndexOf("#") + 1, embeddedCollectionName.length());
    }

    public static String serializeKeys(Set<String> foreignKeys) {
        if (null == foreignKeys || foreignKeys.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String key : foreignKeys) {
            if (sb.length() > 0) {
                sb.append("~");
            }
            sb.append(key);
        }
        return sb.toString();
    }

    public static Set<String> deserializeKeys(String foreignKeys) {
        String[] array;
        HashSet<String> keys = new HashSet<String>();
        if (null == foreignKeys || foreignKeys.isEmpty()) {
            return keys;
        }
        for (String element : array = foreignKeys.split("~")) {
            keys.add(element);
        }
        return keys;
    }

    public static void setSchemaAndPersistenceUnit(EntityMetadata m, String schemaStr, Map puProperties) {
        if (schemaStr.indexOf("@") > 0) {
            String schemaName = null;
            if (puProperties != null) {
                schemaName = (String)puProperties.get("kundera.keyspace");
            }
            if (schemaName == null) {
                schemaName = schemaStr.substring(0, schemaStr.indexOf("@"));
            }
            m.setSchema(schemaName);
            m.setPersistenceUnit(schemaStr.substring(schemaStr.indexOf("@") + 1, schemaStr.length()));
        } else {
            m.setSchema(StringUtils.isBlank((String)schemaStr) ? null : schemaStr);
        }
    }

    public static boolean useSecondryIndex(ClientMetadata clientMetadata) {
        return clientMetadata != null ? clientMetadata.isUseSecondryIndex() : false;
    }

    public static String getMappedName(EntityMetadata parentMetadata, Relation relation, EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata) {
        if (relation != null) {
            String joinColumn = relation.getJoinColumnName(kunderaMetadata);
            if (joinColumn == null) {
                Class<?> clazz = relation.getTargetEntity();
                EntityMetadata metadata = KunderaMetadataManager.getEntityMetadata(kunderaMetadata, clazz);
                joinColumn = relation.getType().equals((Object)Relation.ForeignKey.ONE_TO_MANY) ? ((AbstractAttribute)parentMetadata.getIdAttribute()).getJPAColumnName() : ((AbstractAttribute)metadata.getIdAttribute()).getJPAColumnName();
            }
            return joinColumn;
        }
        return null;
    }

    public static String getEnclosingEmbeddedFieldName(EntityMetadata m, String criteria, boolean viaColumnName, EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata) {
        String enclosingEmbeddedFieldName = null;
        StringTokenizer strToken = new StringTokenizer(criteria, ".");
        String embeddableAttributeName = null;
        String embeddedFieldName = null;
        String nestedEmbeddedFieldName = null;
        if (strToken.countTokens() > 0) {
            embeddableAttributeName = strToken.nextToken();
        }
        if (strToken.countTokens() > 0) {
            embeddedFieldName = strToken.nextToken();
        }
        if (strToken.countTokens() > 0) {
            nestedEmbeddedFieldName = strToken.nextToken();
        }
        Metamodel metaModel = kunderaMetadata.getApplicationMetadata().getMetamodel(m.getPersistenceUnit());
        EntityType entity = metaModel.entity(m.getEntityClazz());
        try {
            Attribute attribute = entity.getAttribute(embeddableAttributeName);
            if (((MetamodelImpl)metaModel).isEmbeddable(((AbstractAttribute)attribute).getBindableJavaType())) {
                EmbeddableType embeddable = metaModel.embeddable(((AbstractAttribute)attribute).getBindableJavaType());
                for (AbstractAttribute attrib : embeddable.getAttributes()) {
                    if (viaColumnName && attrib.getName().equals(embeddedFieldName)) {
                        if (nestedEmbeddedFieldName != null && ((MetamodelImpl)metaModel).isEmbeddable(attrib.getBindableJavaType())) {
                            EmbeddableType nestedEmbeddable = metaModel.embeddable(attrib.getBindableJavaType());
                            for (AbstractAttribute nestedAttribute : embeddable.getAttributes()) {
                                if (viaColumnName && nestedAttribute.getName().equals(embeddedFieldName)) {
                                    return nestedAttribute.getName();
                                }
                                if (viaColumnName || !nestedAttribute.getJPAColumnName().equals(embeddedFieldName)) continue;
                                return nestedAttribute.getName();
                            }
                        } else {
                            if (nestedEmbeddedFieldName != null && !((MetamodelImpl)metaModel).isEmbeddable(attrib.getBindableJavaType())) {
                                return null;
                            }
                            return attribute.getName();
                        }
                    }
                    if (viaColumnName || !attrib.getJPAColumnName().equals(embeddedFieldName)) continue;
                    return attribute.getName();
                }
            }
        }
        catch (IllegalArgumentException iax) {
            return null;
        }
        return enclosingEmbeddedFieldName;
    }

    private static void getEmbeddableType(EntityMetadata m, Map<String, Field> columnNameToFieldMap, Map<String, Field> superColumnNameToFieldMap, EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata) {
        Metamodel metaModel = kunderaMetadata.getApplicationMetadata().getMetamodel(m.getPersistenceUnit());
        EntityType entityType = metaModel.entity(m.getEntityClazz());
        Set attributes = entityType.getAttributes();
        for (Attribute attribute : attributes) {
            if (((MetamodelImpl)metaModel).isEmbeddable(((AbstractAttribute)attribute).getBindableJavaType())) {
                superColumnNameToFieldMap.put(((AbstractAttribute)attribute).getJPAColumnName(), (Field)attribute.getJavaMember());
                if (columnNameToFieldMap == null) continue;
                MetadataUtils.getAttributeOfEmbedddable(columnNameToFieldMap, metaModel, attribute);
                continue;
            }
            if (columnNameToFieldMap == null) continue;
            columnNameToFieldMap.put(((AbstractAttribute)attribute).getJPAColumnName(), (Field)attribute.getJavaMember());
        }
    }

    private static void getAttributeOfEmbedddable(Map<String, Field> columnNameToFieldMap, Metamodel metaModel, Attribute attribute) {
        EmbeddableType embeddable = metaModel.embeddable(((AbstractAttribute)attribute).getBindableJavaType());
        for (Attribute embedAttrib : embeddable.getAttributes()) {
            if (!((MetamodelImpl)metaModel).isEmbeddable(embedAttrib.getJavaType())) {
                columnNameToFieldMap.put(((AbstractAttribute)embedAttrib).getJPAColumnName(), (Field)embedAttrib.getJavaMember());
                continue;
            }
            MetadataUtils.getAttributeOfEmbedddable(columnNameToFieldMap, metaModel, embedAttrib);
        }
    }

    public static boolean isEmbeddedAtributeIndexable(Field embeddedField) {
        Class<?> embeddableClass = PropertyAccessorHelper.getGenericClass(embeddedField);
        IndexCollection indexCollection = embeddableClass.getAnnotation(IndexCollection.class);
        return indexCollection != null && indexCollection.columns() != null;
    }

    public static boolean isColumnInEmbeddableIndexable(Field embeddedField, String columnFieldName) {
        Class<?> embeddableClass = PropertyAccessorHelper.getGenericClass(embeddedField);
        IndexCollection indexCollection = embeddableClass.getAnnotation(IndexCollection.class);
        if (indexCollection != null && indexCollection.columns() != null) {
            for (Index column : indexCollection.columns()) {
                if (columnFieldName == null || column == null || column.name() == null || !column.name().equals(columnFieldName)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean defaultTransactionSupported(String persistenceUnit, EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata) {
        PersistenceUnitMetadata puMetadata = KunderaMetadataManager.getPersistenceUnitMetadata(kunderaMetadata, persistenceUnit);
        String txResource = puMetadata.getProperty("kundera.transaction.resource.class");
        if (txResource == null) {
            return true;
        }
        if (txResource.isEmpty()) {
            throw new IllegalArgumentException("Property kundera.transaction.resource.class is blank");
        }
        return false;
    }

    public static boolean isSchemaAttributeRequired(String persistenceUnit, EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata) {
        PersistenceUnitMetadata puMetadata = KunderaMetadataManager.getPersistenceUnitMetadata(kunderaMetadata, persistenceUnit);
        String clientFactoryName = puMetadata != null ? puMetadata.getProperty("kundera.client.lookup.class") : null;
        return !"com.impetus.client.neo4j.Neo4JClientFactory".equalsIgnoreCase(clientFactoryName) && !"com.impetus.client.rdbms.RDBMSClientFactory".equalsIgnoreCase(clientFactoryName);
    }

    public static boolean indexSearchEnabled(String persistenceUnit, EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata) {
        PersistenceUnitMetadata puMetadata = KunderaMetadataManager.getPersistenceUnitMetadata(kunderaMetadata, persistenceUnit);
        String clientFactoryName = puMetadata != null ? puMetadata.getProperty("kundera.client.lookup.class") : null;
        return !"com.impetus.client.redis.RedisClientFactory".equalsIgnoreCase(clientFactoryName);
    }

    public static boolean isBasicElementCollectionField(Field collectionField) {
        if (!Collection.class.isAssignableFrom(collectionField.getType()) && !Map.class.isAssignableFrom(collectionField.getType())) {
            return false;
        }
        List<Class<?>> genericClasses = PropertyAccessorHelper.getGenericClasses(collectionField);
        for (Class<?> genericClass : genericClasses) {
            if (genericClass.getAnnotation(Embeddable.class) == null) continue;
            return false;
        }
        return true;
    }

    public static boolean containsBasicElementCollectionField(EntityMetadata m, EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata) {
        Metamodel metaModel = kunderaMetadata.getApplicationMetadata().getMetamodel(m.getPersistenceUnit());
        EntityType entityType = metaModel.entity(m.getEntityClazz());
        for (Attribute attr : entityType.getAttributes()) {
            if (!attr.isCollection() || attr.isAssociation() || !MetadataUtils.isBasicElementCollectionField((Field)attr.getJavaMember())) continue;
            return true;
        }
        return false;
    }

    public static void onJPAColumnMapping(EntityType entityType, EntityMetadata entityMetadata) {
        Set attributes = entityType.getAttributes();
        for (Attribute attribute : attributes) {
            if (entityMetadata.getIdAttribute().equals(attribute)) continue;
            entityMetadata.addJPAColumnMapping(((AbstractAttribute)attribute).getJPAColumnName(), attribute.getName());
        }
        entityMetadata.setEntityType(entityType);
    }

    public static boolean onCheckValidationConstraints(Field attribute) {
        return attribute.isAnnotationPresent(AssertFalse.class) || attribute.isAnnotationPresent(AssertTrue.class) || attribute.isAnnotationPresent(DecimalMax.class) || attribute.isAnnotationPresent(DecimalMin.class) || attribute.isAnnotationPresent(Digits.class) || attribute.isAnnotationPresent(Future.class) || attribute.isAnnotationPresent(Max.class) || attribute.isAnnotationPresent(Min.class) || attribute.isAnnotationPresent(NotNull.class) || attribute.isAnnotationPresent(Null.class) || attribute.isAnnotationPresent(Past.class) || attribute.isAnnotationPresent(Pattern.class) || attribute.isAnnotationPresent(Size.class);
    }

    public static boolean onCheckEmbeddableAttribute(Field attribute) {
        return attribute.isAnnotationPresent(Embedded.class);
    }
}

