/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.metadata.model;

import com.impetus.kundera.metadata.MetadataUtils;
import com.impetus.kundera.metadata.model.PropertyIndex;
import com.impetus.kundera.metadata.model.Relation;
import com.impetus.kundera.metadata.model.attributes.AbstractAttribute;
import com.impetus.kundera.metadata.model.type.AbstractManagedType;
import com.impetus.kundera.persistence.event.CallbackMethod;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.JoinColumn;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.SingularAttribute;
import org.apache.commons.lang.StringUtils;

public final class EntityMetadata {
    private Class<?> entityClazz;
    private String tableName;
    private String schema;
    private String persistenceUnit;
    private String indexName;
    private boolean isIndexable = true;
    private boolean cacheable = false;
    private boolean isCounterColumnType = false;
    private SingularAttribute idAttribute;
    private Map<String, String> jpaColumnMapping = new HashMap<String, String>();
    private Method readIdentifierMethod;
    private Method writeIdentifierMethod;
    private Map<String, PropertyIndex> indexPrperties = new HashMap<String, PropertyIndex>();
    private Map<Class<?>, List<? extends CallbackMethod>> callbackMethodsMap = new HashMap();
    private Map<String, Relation> relationsMap = new HashMap<String, Relation>();
    private Type type;
    private boolean isRelationViaJoinTable;
    private List<String> relationNames;
    private boolean isParent;
    private EntityType entityType;

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public EntityMetadata(Class<?> entityClazz) {
        this.entityClazz = entityClazz;
    }

    public Class<?> getEntityClazz() {
        return this.entityClazz;
    }

    public String getTableName() {
        this.getEntityType();
        return this.entityType != null && !StringUtils.isBlank((String)((AbstractManagedType)this.entityType).getTableName()) ? ((AbstractManagedType)this.entityType).getTableName() : this.tableName;
    }

    private EntityType getEntityType() {
        return this.entityType;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getSchema() {
        this.getEntityType();
        return this.entityType != null && !StringUtils.isBlank((String)((AbstractManagedType)this.entityType).getSchemaName()) ? ((AbstractManagedType)this.entityType).getSchemaName() : this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getPersistenceUnit() {
        return this.persistenceUnit;
    }

    public void setPersistenceUnit(String persistenceUnit) {
        this.persistenceUnit = persistenceUnit;
    }

    public Method getReadIdentifierMethod() {
        return this.readIdentifierMethod;
    }

    public void setReadIdentifierMethod(Method readIdentifierMethod) {
        this.readIdentifierMethod = readIdentifierMethod;
    }

    public Method getWriteIdentifierMethod() {
        return this.writeIdentifierMethod;
    }

    public void setWriteIdentifierMethod(Method writeIdentifierMethod) {
        this.writeIdentifierMethod = writeIdentifierMethod;
    }

    public void addIndexProperty(String columnName, PropertyIndex index) {
        this.indexPrperties.put(columnName, index);
    }

    public void addRelation(String property, Relation relation) {
        this.relationsMap.put(property, relation);
        this.addRelationName(relation);
    }

    public Relation getRelation(String property) {
        return this.relationsMap.get(property);
    }

    public List<Relation> getRelations() {
        return new ArrayList<Relation>(this.relationsMap.values());
    }

    public Map<String, PropertyIndex> getIndexProperties() {
        return this.indexPrperties;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public boolean isIndexable() {
        return this.isIndexable;
    }

    public void setIndexable(boolean isIndexable) {
        this.isIndexable = isIndexable;
    }

    public void setCallbackMethodsMap(Map<Class<?>, List<? extends CallbackMethod>> callbackMethodsMap) {
        this.callbackMethodsMap = callbackMethodsMap;
    }

    public Map<Class<?>, List<? extends CallbackMethod>> getCallbackMethodsMap() {
        return this.callbackMethodsMap;
    }

    public List<? extends CallbackMethod> getCallbackMethods(Class<?> event) {
        return this.callbackMethodsMap.get(event);
    }

    public boolean isCacheable() {
        return this.cacheable;
    }

    public void setCacheable(boolean cacheable) {
        this.cacheable = cacheable;
    }

    public String toString() {
        int start = 0;
        StringBuilder builder = new StringBuilder();
        builder.append(this.entityClazz.getName() + " (\n");
        builder.append("\tTable: " + this.tableName + ", \n");
        builder.append("\tKeyspace: " + this.schema + ",\n");
        builder.append("\tPersistence Unit: " + this.persistenceUnit + ",\n");
        builder.append("\tId: " + this.idAttribute.getName() + ",\n");
        builder.append("\tCacheable: " + this.cacheable + ",\n");
        if (!this.indexPrperties.isEmpty()) {
            builder.append("\tIndexes (");
            start = 0;
            for (String string : this.indexPrperties.keySet()) {
                if (start++ != 0) {
                    builder.append(", ");
                }
                builder.append(this.indexPrperties.get(string));
            }
            builder.append("),\n");
        }
        if (!this.callbackMethodsMap.isEmpty()) {
            builder.append("\tListeners (\n");
            for (Map.Entry entry : this.callbackMethodsMap.entrySet()) {
                String key = ((Class)entry.getKey()).getSimpleName();
                for (CallbackMethod cbm : (List)entry.getValue()) {
                    builder.append("\t\t" + key + ": " + cbm + "\n");
                }
            }
            builder.append("\t)\n");
        }
        if (!this.relationsMap.isEmpty()) {
            builder.append("\tRelation (\n");
            for (Relation relation : this.relationsMap.values()) {
                if (relation.getMapKeyJoinClass() != null) {
                    builder.append(" --- via ").append(relation.getMapKeyJoinClass().getSimpleName()).append(" ---\n");
                }
                builder.append("\t\t" + relation.getTargetEntity().getName() + "#" + relation.getProperty().getName());
                builder.append(" (" + relation.getCascades());
                builder.append(", " + (Object)((Object)relation.getType()));
                builder.append(", " + relation.getFetchType());
                builder.append(")\n");
            }
            builder.append("\t)\n");
        }
        builder.append(")");
        return builder.toString();
    }

    public boolean isRelationViaJoinTable() {
        return this.isRelationViaJoinTable;
    }

    public boolean isParent() {
        return this.isParent;
    }

    public void setParent(boolean isParent) {
        this.isParent = isParent;
    }

    public void setRelationViaJoinTable(boolean isRelationViaJoinTable) {
        this.isRelationViaJoinTable = isRelationViaJoinTable;
    }

    public List<String> getRelationNames() {
        return this.relationNames;
    }

    private void addRelationName(Relation rField) {
        if (rField != null && !rField.isRelatedViaJoinTable()) {
            String relationName = this.getJoinColumnName(rField.getProperty());
            if (rField.getProperty().isAnnotationPresent(PrimaryKeyJoinColumn.class)) {
                relationName = this.getIdAttribute().getName();
            }
            this.addToRelationNameCollection(relationName);
        }
    }

    private void addToRelationNameCollection(String relationName) {
        if (this.relationNames == null) {
            this.relationNames = new ArrayList<String>();
        }
        if (relationName != null) {
            this.relationNames.add(relationName);
        }
    }

    private String getJoinColumnName(Field relation) {
        String columnName = null;
        JoinColumn ann = relation.getAnnotation(JoinColumn.class);
        if (ann != null) {
            columnName = ann.name();
        }
        return StringUtils.isBlank(columnName) ? relation.getName() : columnName;
    }

    public boolean isCounterColumnType() {
        return this.isCounterColumnType;
    }

    public void setCounterColumnType(boolean isCounterColumnType) {
        this.isCounterColumnType = isCounterColumnType;
    }

    public SingularAttribute getIdAttribute() {
        return this.idAttribute;
    }

    public void setIdAttribute(SingularAttribute idAttribute) {
        this.idAttribute = idAttribute;
    }

    public void addJPAColumnMapping(String jpaColumnName, String fieldName) {
        this.jpaColumnMapping.put(jpaColumnName, fieldName);
    }

    public String getFieldName(String jpaColumnName) {
        String fieldName = this.jpaColumnMapping.get(jpaColumnName);
        if (fieldName == null) {
            this.getEntityType();
            MetadataUtils.onJPAColumnMapping(this.entityType, this);
            fieldName = this.jpaColumnMapping.get(jpaColumnName);
        }
        if (fieldName == null && jpaColumnName.equals(((AbstractAttribute)this.getIdAttribute()).getJPAColumnName())) {
            return this.getIdAttribute().getName();
        }
        return fieldName;
    }

    public void setEntityType(EntityType entityType) {
        if (entityType != null) {
            this.entityType = entityType;
        }
    }

    public static enum Type {
        COLUMN_FAMILY{

            @Override
            public boolean isColumnFamilyMetadata() {
                return true;
            }

            @Override
            public boolean isSuperColumnFamilyMetadata() {
                return false;
            }

            @Override
            public boolean isDocumentMetadata() {
                return false;
            }
        }
        ,
        SUPER_COLUMN_FAMILY{

            @Override
            public boolean isColumnFamilyMetadata() {
                return false;
            }

            @Override
            public boolean isSuperColumnFamilyMetadata() {
                return true;
            }

            @Override
            public boolean isDocumentMetadata() {
                return false;
            }
        };


        public abstract boolean isColumnFamilyMetadata();

        public abstract boolean isSuperColumnFamilyMetadata();

        public abstract boolean isDocumentMetadata();
    }
}

