/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.metadata.model;

import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;

public class JoinTableMetadata {
    private String joinTableName;
    private String joinTableSchema;
    private Set<String> joinColumns;
    private Set<String> inverseJoinColumns;

    public JoinTableMetadata(Field relationField) {
        JoinTable jtAnn = relationField.getAnnotation(JoinTable.class);
        this.setJoinTableName(jtAnn.name());
        this.setJoinTableSchema(jtAnn.schema());
        for (JoinColumn joinColumn : jtAnn.joinColumns()) {
            this.addJoinColumns(joinColumn.name());
        }
        for (JoinColumn inverseJoinColumn : jtAnn.inverseJoinColumns()) {
            this.addInverseJoinColumns(inverseJoinColumn.name());
        }
    }

    public String getJoinTableName() {
        return this.joinTableName;
    }

    public void setJoinTableName(String joinTableName) {
        this.joinTableName = joinTableName;
    }

    public String getJoinTableSchema() {
        return this.joinTableSchema;
    }

    public void setJoinTableSchema(String joinTableSchema) {
        this.joinTableSchema = joinTableSchema;
    }

    public Set<String> getJoinColumns() {
        return this.joinColumns;
    }

    public void addJoinColumns(String joinColumn) {
        if (this.joinColumns == null || this.joinColumns.isEmpty()) {
            this.joinColumns = new HashSet<String>();
        }
        this.joinColumns.add(joinColumn);
    }

    public Set<String> getInverseJoinColumns() {
        return this.inverseJoinColumns;
    }

    public void addInverseJoinColumns(String inverseJoinColumn) {
        if (this.inverseJoinColumns == null || this.inverseJoinColumns.isEmpty()) {
            this.inverseJoinColumns = new HashSet<String>();
        }
        this.inverseJoinColumns.add(inverseJoinColumn);
    }
}

