/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.metadata.model;

import com.impetus.kundera.metadata.model.EntityMetadata;
import com.impetus.kundera.metadata.model.IdDiscriptor;
import com.impetus.kundera.metadata.model.attributes.AbstractAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EmbeddableType;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.metamodel.StaticMetamodel;
import javax.persistence.metamodel.Type;

@StaticMetamodel(value=MetamodelImpl.class)
public class MetamodelImpl
implements Metamodel {
    Map<String, EntityMetadata> entityMetadataMap;
    Map<String, Class<?>> entityNameToClassMap;
    private Map<Class<?>, EntityType<?>> entityTypes;
    private Map<Class<?>, ManagedType<?>> embeddables;
    private Map<Class<?>, ManagedType<?>> mappedSuperClassTypes;
    private Map<String, IdDiscriptor> keyValues;
    private Map<Class<?>, List<String>> classToTables;

    public <X> EntityType<X> entity(Class<X> paramClass) {
        EntityType<?> entityType = this.entityTypes.get(paramClass);
        if (entityType == null) {
            throw new IllegalArgumentException("Not an entity, {class:" + paramClass + "}");
        }
        return entityType;
    }

    public <X> ManagedType<X> managedType(Class<X> paramClass) {
        ManagedType<?> managedType = (ManagedType<?>)this.entityTypes.get(paramClass);
        if (managedType == null && (managedType = this.embeddables.get(paramClass)) == null) {
            managedType = this.mappedSuperClassTypes.get(paramClass);
        }
        if (managedType == null) {
            throw new IllegalArgumentException("Not a managed type, {class: " + paramClass + "}");
        }
        return managedType;
    }

    public <X> EmbeddableType<X> embeddable(Class<X> paramClass) {
        EmbeddableType embeddableType = (EmbeddableType)this.embeddables.get(paramClass);
        if (embeddableType == null) {
            throw new IllegalArgumentException("Not a embeddable type, {class: " + paramClass + "}");
        }
        return embeddableType;
    }

    public Set<ManagedType<?>> getManagedTypes() {
        HashSet managedTypeCollection = new HashSet();
        if (this.entityTypes != null) {
            managedTypeCollection.addAll(this.entityTypes.values());
        }
        if (this.embeddables != null) {
            managedTypeCollection.addAll(this.embeddables.values());
        }
        if (this.mappedSuperClassTypes != null) {
            managedTypeCollection.addAll(this.mappedSuperClassTypes.values());
        }
        return managedTypeCollection;
    }

    public Set<EntityType<?>> getEntities() {
        HashSet entities = null;
        if (this.entityTypes != null) {
            entities = new HashSet(this.entityTypes.values());
        }
        return entities;
    }

    public Set<EmbeddableType<?>> getEmbeddables() {
        HashSet embeddableEntities = null;
        if (this.embeddables != null) {
            embeddableEntities = new HashSet(this.embeddables.values());
        }
        return embeddableEntities;
    }

    public MetamodelImpl() {
        this.setEntityMetadataMap(new HashMap<String, EntityMetadata>());
    }

    public Map<String, EntityMetadata> getEntityMetadataMap() {
        if (this.entityMetadataMap == null) {
            this.entityMetadataMap = new HashMap<String, EntityMetadata>();
        }
        return this.entityMetadataMap;
    }

    public void setEntityMetadataMap(Map<String, EntityMetadata> entityMetadataMap) {
        this.entityMetadataMap = entityMetadataMap;
    }

    public void addEntityMetadata(Class<?> clazz, EntityMetadata entityMetadata) {
        this.getEntityMetadataMap().put(clazz.getName(), entityMetadata);
    }

    public EntityMetadata getEntityMetadata(Class<?> entityClass) {
        return this.getEntityMetadataMap().get(entityClass.getName());
    }

    public Map<String, Class<?>> getEntityNameToClassMap() {
        if (this.entityNameToClassMap == null) {
            this.entityNameToClassMap = new HashMap();
        }
        return this.entityNameToClassMap;
    }

    public void setEntityNameToClassMap(Map<String, Class<?>> entityNameToClassMap) {
        this.entityNameToClassMap = entityNameToClassMap;
    }

    public void addEntityNameToClassMapping(String className, Class<?> entityClass) {
        this.getEntityNameToClassMap().put(className, entityClass);
    }

    public Class<?> getEntityClass(String className) {
        return this.getEntityNameToClassMap().get(className);
    }

    public void assignManagedTypes(Map<Class<?>, EntityType<?>> managedTypes) {
        if (this.entityTypes == null) {
            this.entityTypes = managedTypes;
        } else {
            this.entityTypes.putAll(managedTypes);
        }
    }

    public void assignEmbeddables(Map<Class<?>, ManagedType<?>> embeddables) {
        if (this.embeddables == null) {
            this.embeddables = embeddables;
        } else {
            this.embeddables.putAll(embeddables);
        }
    }

    public void assignMappedSuperClass(Map<Class<?>, ManagedType<?>> mappedSuperClass) {
        if (this.mappedSuperClassTypes == null) {
            this.mappedSuperClassTypes = mappedSuperClass;
        } else {
            this.mappedSuperClassTypes.putAll(this.mappedSuperClassTypes);
        }
    }

    public boolean isEmbeddable(Class embeddableClazz) {
        return this.embeddables != null ? this.embeddables.containsKey(embeddableClazz) && this.embeddables.get(embeddableClazz).getPersistenceType().equals((Object)Type.PersistenceType.EMBEDDABLE) : false;
    }

    public Attribute getEntityAttribute(Class clazz, String fieldName) {
        if (this.entityTypes != null && this.entityTypes.containsKey(clazz)) {
            EntityType<?> entityType = this.entityTypes.get(clazz);
            return entityType.getAttribute(fieldName);
        }
        throw new IllegalArgumentException("No entity found: " + clazz);
    }

    public Map<String, EmbeddableType> getEmbeddables(Class clazz) {
        HashMap<String, EmbeddableType> embeddableAttibutes = new HashMap<String, EmbeddableType>();
        if (this.entityTypes != null) {
            EntityType<?> entity = this.entityTypes.get(clazz);
            for (Attribute attribute : entity.getAttributes()) {
                if (!this.isEmbeddable(((AbstractAttribute)attribute).getBindableJavaType())) continue;
                embeddableAttibutes.put(attribute.getName(), this.embeddable(((AbstractAttribute)attribute).getBindableJavaType()));
            }
        }
        return embeddableAttibutes;
    }

    public IdDiscriptor getKeyValue(String entityName) {
        if (this.keyValues != null) {
            return this.keyValues.get(entityName);
        }
        return null;
    }

    public void addKeyValues(Map<String, IdDiscriptor> keyDiscriptors) {
        if (this.keyValues == null) {
            this.keyValues = new HashMap<String, IdDiscriptor>();
        }
        this.keyValues.putAll(keyDiscriptors);
    }
}

