/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.metadata.model;

import com.impetus.kundera.metadata.KunderaMetadataManager;
import com.impetus.kundera.metadata.model.EntityMetadata;
import com.impetus.kundera.metadata.model.JoinTableMetadata;
import com.impetus.kundera.metadata.model.attributes.AbstractAttribute;
import com.impetus.kundera.persistence.EntityManagerFactoryImpl;
import com.impetus.kundera.property.PropertyAccessorHelper;
import com.impetus.kundera.utils.ReflectUtils;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;

public final class Relation {
    private Field property;
    private Class<?> targetEntity;
    private Class<?> mapKeyJoinClass;
    private Class<?> propertyType;
    private FetchType fetchType;
    private List<CascadeType> cascades;
    private boolean optional;
    private String mappedBy;
    private ForeignKey type;
    private String joinColumnName;
    private boolean isRelatedViaJoinTable;
    private JoinTableMetadata joinTableMetadata;
    private EntityMetadata targetEntityMetadata;
    private boolean isJoinedByPrimaryKey;
    private Field biDirectionalField;

    public Relation(Field property, Class<?> targetEntity, Class<?> propertyType, FetchType fetchType, List<CascadeType> cascades, boolean optional, String mappedBy, ForeignKey type) {
        this.property = property;
        this.targetEntity = targetEntity;
        this.propertyType = propertyType;
        this.fetchType = fetchType;
        this.cascades = cascades;
        this.optional = optional;
        this.mappedBy = mappedBy;
        this.type = type;
    }

    public Field getProperty() {
        return this.property;
    }

    public Class<?> getTargetEntity() {
        return this.targetEntity;
    }

    public Class<?> getMapKeyJoinClass() {
        return this.mapKeyJoinClass;
    }

    public void setMapKeyJoinClass(Class<?> mapKeyJoinClass) {
        this.mapKeyJoinClass = mapKeyJoinClass;
    }

    public Class<?> getPropertyType() {
        return this.propertyType;
    }

    public FetchType getFetchType() {
        return this.fetchType;
    }

    public List<CascadeType> getCascades() {
        return this.cascades;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public String getMappedBy() {
        return this.mappedBy;
    }

    public ForeignKey getType() {
        return this.type;
    }

    public String getJoinColumnName(EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata) {
        if (this.joinColumnName == null && this.isJoinedByPrimaryKey) {
            EntityMetadata joinClassMetadata = KunderaMetadataManager.getEntityMetadata(kunderaMetadata, this.targetEntity);
            this.joinColumnName = ((AbstractAttribute)joinClassMetadata.getIdAttribute()).getJPAColumnName();
        }
        if (this.joinTableMetadata != null) {
            String string = this.joinColumnName = this.joinTableMetadata.getJoinColumns() != null ? this.joinTableMetadata.getJoinColumns().iterator().next() : null;
        }
        if (this.isBiDirectional() && this.biDirectionalField.isAnnotationPresent(JoinColumn.class)) {
            this.joinColumnName = this.biDirectionalField.getAnnotation(JoinColumn.class).name();
        }
        return this.joinColumnName != null ? this.joinColumnName : this.property.getName();
    }

    public void setJoinColumnName(String joinColumnName) {
        this.joinColumnName = joinColumnName;
    }

    public boolean isRelatedViaJoinTable() {
        return this.isRelatedViaJoinTable;
    }

    public void setRelatedViaJoinTable(boolean isRelatedViaJoinTable) {
        this.isRelatedViaJoinTable = isRelatedViaJoinTable;
    }

    public JoinTableMetadata getJoinTableMetadata() {
        return this.joinTableMetadata;
    }

    public void setJoinTableMetadata(JoinTableMetadata joinTableMetadata) {
        this.joinTableMetadata = joinTableMetadata;
    }

    public boolean isJoinedByPrimaryKey() {
        return this.isJoinedByPrimaryKey;
    }

    public void setJoinedByPrimaryKey(boolean isJoinedByPrimaryKey) {
        this.isJoinedByPrimaryKey = isJoinedByPrimaryKey;
    }

    public boolean isUnary() {
        return this.type.equals((Object)ForeignKey.ONE_TO_ONE) || this.type.equals((Object)ForeignKey.MANY_TO_ONE);
    }

    public boolean isCollection() {
        return this.type.equals((Object)ForeignKey.ONE_TO_MANY) || this.type.equals((Object)ForeignKey.MANY_TO_MANY);
    }

    public boolean isBiDirectional() {
        return this.biDirectionalField != null;
    }

    public Field getBiDirectionalField() {
        return this.biDirectionalField;
    }

    public void setBiDirectionalField(Class referencedClass) {
        Field[] fields = this.getTargetEntity().getDeclaredFields();
        Class clazzz = null;
        for (Field field : fields) {
            Type[] types;
            ParameterizedType type;
            if (ReflectUtils.isTransientOrStatic(field)) continue;
            clazzz = field.getType();
            if (PropertyAccessorHelper.isCollection(clazzz)) {
                type = (ParameterizedType)field.getGenericType();
                types = type.getActualTypeArguments();
                clazzz = (Class)types[0];
            } else if (Map.class.isAssignableFrom(clazzz)) {
                type = (ParameterizedType)field.getGenericType();
                types = type.getActualTypeArguments();
                clazzz = (Class)types[1];
            }
            if (!clazzz.equals(referencedClass)) continue;
            this.biDirectionalField = field;
            break;
        }
    }

    public static enum ForeignKey {
        ONE_TO_ONE,
        ONE_TO_MANY,
        MANY_TO_ONE,
        MANY_TO_MANY;

    }
}

