/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.metadata.model;

import javax.persistence.SequenceGenerator;

public class SequenceGeneratorDiscriptor {
    private static final int default_initial_value = 1;
    private static final String default_sequence_name = "sequence_name";
    private static final int default_allocation_size = 50;
    private int initialValue;
    private int allocationSize;
    private String sequenceName;
    private String schemaName;
    private String catalog;

    public SequenceGeneratorDiscriptor(SequenceGenerator sequenceGenerator, String defaultSchemaName) {
        this.initialValue = sequenceGenerator.initialValue();
        this.allocationSize = sequenceGenerator.allocationSize();
        this.sequenceName = sequenceGenerator.sequenceName().isEmpty() ? default_sequence_name : sequenceGenerator.sequenceName();
        this.schemaName = sequenceGenerator.schema().isEmpty() ? defaultSchemaName : sequenceGenerator.schema();
    }

    public SequenceGeneratorDiscriptor(String defaultSchemaName) {
        this.initialValue = 1;
        this.allocationSize = 50;
        this.sequenceName = default_sequence_name;
        this.schemaName = defaultSchemaName;
    }

    public int getInitialValue() {
        return this.initialValue;
    }

    public int getAllocationSize() {
        return this.allocationSize;
    }

    public String getSequenceName() {
        return this.sequenceName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getCatalog() {
        return this.catalog;
    }
}

