/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.metadata.model;

import javax.persistence.TableGenerator;
import javax.persistence.UniqueConstraint;

public class TableGeneratorDiscriptor {
    private static final String default_table_name = "kundera_sequences";
    private static final String default_pkColumn_name = "sequence_name";
    private static final String default_valueColumn_name = "sequence_value";
    private static final int default_allocation_size = 50;
    private static final int default_initial_value = 1;
    private String table;
    private String catalog;
    private String schema;
    private String pkColumnName;
    private String valueColumnName;
    private String pkColumnValue;
    private int initialValue;
    private int allocationSize;
    private UniqueConstraint[] uniqueConstraints;

    public TableGeneratorDiscriptor(TableGenerator tableGenerator, String defaultSchemaName, String defaultPkColumnValue) {
        this.table = tableGenerator.table().isEmpty() ? default_table_name : tableGenerator.table();
        this.schema = tableGenerator.schema().isEmpty() ? defaultSchemaName : tableGenerator.schema();
        this.pkColumnName = tableGenerator.pkColumnName().isEmpty() ? default_pkColumn_name : tableGenerator.pkColumnName();
        this.valueColumnName = tableGenerator.valueColumnName().isEmpty() ? default_valueColumn_name : tableGenerator.valueColumnName();
        this.pkColumnValue = tableGenerator.pkColumnValue().isEmpty() ? defaultPkColumnValue : tableGenerator.pkColumnValue();
        this.initialValue = tableGenerator.initialValue() != 0 ? tableGenerator.initialValue() : 1;
        this.allocationSize = tableGenerator.allocationSize();
    }

    public TableGeneratorDiscriptor(String defaultSchemaName, String defaultPkColumnValue) {
        this.table = default_table_name;
        this.schema = defaultSchemaName;
        this.pkColumnName = default_pkColumn_name;
        this.valueColumnName = default_valueColumn_name;
        this.pkColumnValue = defaultPkColumnValue;
        this.initialValue = 1;
        this.allocationSize = 50;
    }

    public String getTable() {
        return this.table;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getPkColumnName() {
        return this.pkColumnName;
    }

    public String getValueColumnName() {
        return this.valueColumnName;
    }

    public String getPkColumnValue() {
        return this.pkColumnValue;
    }

    public int getInitialValue() {
        return this.initialValue;
    }

    public int getAllocationSize() {
        return this.allocationSize;
    }

    public UniqueConstraint[] getUniqueConstraints() {
        return this.uniqueConstraints;
    }
}

