/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.metadata.model.type;

import com.impetus.kundera.metadata.MetadataUtils;
import com.impetus.kundera.metadata.model.type.AbstractManagedType;
import java.lang.reflect.Field;
import java.util.Set;
import javax.persistence.metamodel.IdentifiableType;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIdentifiableType<X>
extends AbstractManagedType<X>
implements IdentifiableType<X> {
    private SingularAttribute<? super X, ?> idAttribute;
    private boolean isIdClass;
    private Set<SingularAttribute<? super X, ?>> idClassAttributes;
    private static Logger log = LoggerFactory.getLogger(AbstractIdentifiableType.class);

    AbstractIdentifiableType(Class<X> clazz, Type.PersistenceType persistenceType, AbstractIdentifiableType<? super X> superClazzType) {
        super(clazz, persistenceType, superClazzType);
    }

    public <Y> SingularAttribute<? super X, Y> getId(Class<Y> paramClass) {
        if (this.idAttribute != null) {
            if (this.idAttribute.getJavaType().equals(paramClass) && !this.isIdClass) {
                return this.idAttribute;
            }
            this.onError();
        } else {
            AbstractIdentifiableType superType = (AbstractIdentifiableType)this.getSupertype();
            if (superType != null) {
                return superType.getId(paramClass);
            }
        }
        this.onError();
        return null;
    }

    public <Y> SingularAttribute<X, Y> getDeclaredId(Class<Y> paramClass) {
        if (this.idAttribute != null && this.idAttribute.getJavaType().equals(paramClass) && !this.isIdClass) {
            return this.idAttribute;
        }
        this.onError();
        return null;
    }

    public <Y> SingularAttribute<? super X, Y> getVersion(Class<Y> paramClass) {
        throw new UnsupportedOperationException("Method not supported");
    }

    public <Y> SingularAttribute<X, Y> getDeclaredVersion(Class<Y> paramClass) {
        throw new UnsupportedOperationException("Method not supported");
    }

    public IdentifiableType<? super X> getSupertype() {
        return (AbstractIdentifiableType)super.getSuperClazzType();
    }

    public boolean hasSingleIdAttribute() {
        return !this.isIdClass && this.getIdAttribute() != null;
    }

    public boolean hasVersionAttribute() {
        log.warn("Versioning not yet supported. returning false, By default");
        return false;
    }

    public Set<SingularAttribute<? super X, ?>> getIdClassAttributes() {
        if (this.isIdClass) {
            return this.idClassAttributes;
        }
        if (this.getSuperClazzType() != null) {
            this.idClassAttributes = ((AbstractIdentifiableType)this.getSuperClazzType()).getIdClassAttributes();
        }
        throw new IllegalArgumentException("The identifiable type does not have an id class");
    }

    public Type<?> getIdType() {
        if (this.idAttribute != null && !this.isIdClass) {
            return this.idAttribute.getType();
        }
        return this.getSupertype().getIdType();
    }

    public void addIdAttribute(SingularAttribute<? super X, ?> idAttribute, boolean isIdClass, Set<SingularAttribute<? super X, ?>> idClassAttributes) {
        this.idAttribute = idAttribute;
        this.isIdClass = isIdClass;
        this.idClassAttributes = idClassAttributes;
        if (MetadataUtils.onCheckValidationConstraints((Field)idAttribute.getJavaMember())) {
            this.hasValidationConstraints = true;
        }
    }

    public SingularAttribute<? super X, ?> getIdAttribute() {
        this.idAttribute = this.idAttribute == null ? (this.getSuperClazzType() != null ? ((AbstractIdentifiableType)this.getSuperClazzType()).getIdAttribute() : null) : this.idAttribute;
        return this.idAttribute;
    }

    private void onError() {
        throw new IllegalArgumentException("id attribute of the given type is not declared in the identifiable type or if the identifiable type has an id class(e.g. @IdClass is in use)");
    }
}

